# 通知設計書 41-ヒープスナップショット書込先変更警告

## 概要

本ドキュメントは、Julia の Profile モジュールにおけるヒープスナップショット書込先変更警告（`@warn "Cannot write to current directory"`）の通知設計について記載する。

### 本通知の処理概要

ヒープスナップショットの取得時に、カレントディレクトリへのファイル書き込みが権限不足等の理由で失敗した場合、書き込み先を `tempdir()` に自動変更し、その旨をユーザーに警告する通知である。

**業務上の目的・背景**：ヒープスナップショットはメモリリークの調査やGCの挙動分析に使用される重要なデバッグツールである。`Profile.take_heap_snapshot()` を呼び出した際、デフォルトではカレントディレクトリに `.heapsnapshot` ファイルを生成するが、権限の問題やディスク容量不足等でカレントディレクトリに書き込めない場合がある。その際、処理を完全に失敗させるのではなく、代替の一時ディレクトリに保存先を変更することでユーザーの作業を中断させない設計となっている。本警告は、保存先が意図と異なる場所に変更されたことをユーザーに通知し、ファイルの所在を明確にする目的で発行される。

**通知の送信タイミング**：`Profile.take_heap_snapshot()` が `dir` キーワード引数なしで呼び出され、かつカレントディレクトリへの `touch` 操作が例外をスローした時点で送信される。

**通知の受信者**：Julia プロセスを実行している開発者・運用者。ログ出力先（通常は `stderr`）を監視している人物。

**通知内容の概要**：カレントディレクトリ（`pwd()`）に書き込めないこと、および代替として `tempdir()` にヒープスナップショットが保存されることを通知する。

**期待されるアクション**：ユーザーは `tempdir()` 配下に生成されたスナップショットファイルを確認し、必要に応じて適切なディレクトリに移動する。また、カレントディレクトリの権限設定を見直すか、`dir` キーワード引数で明示的に書き込み先を指定することが推奨される。

## 通知種別

ログ出力（`@warn` マクロによる標準エラー出力へのWarnレベルログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn` マクロによる即時ログ出力） |
| 優先度 | 中（Warn レベル） |
| リトライ | なし（ログ出力のため） |

### 送信先決定ロジック

Julia のログシステム（`Base.CoreLogging`）に委譲される。デフォルトでは `stderr` に出力される。`maxlog=1` が指定されており、同一カレントディレクトリに対しては最大1回のみ出力される（`_id=Symbol(wd)` による識別）。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
┌ Warning: Cannot write to current directory `$(pwd())` so saving heap snapshot to `$(tempdir())`
└ @ Profile stdlib/Profile/src/Profile.jl:1462
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| `pwd()` | カレントディレクトリのパス | `Base.pwd()` | Yes |
| `tempdir()` | 一時ディレクトリのパス | `Base.tempdir()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `Profile.take_heap_snapshot()` | `dir` 引数が `nothing` かつ `touch(fpath)` が例外をスロー | カレントディレクトリに書き込みテスト用ファイルを作成できない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `maxlog=1` | 同一カレントディレクトリ（`Symbol(wd)`）に対して最大1回のみ |
| `dir` 引数指定時 | `dir` キーワード引数が明示的に指定された場合は本パスを通らない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["take_heap_snapshot() 呼び出し"] --> B{"dir 引数の確認"}
    B -->|"dir指定あり"| C["指定ディレクトリに保存"]
    B -->|"dir=nothing"| D["カレントディレクトリに touch でテスト"]
    D -->|"成功"| E["rm(fpath) でテストファイル削除"]
    E --> F["カレントディレクトリに保存"]
    D -->|"例外発生"| G["@warn 警告出力"]
    G --> H["fpath を tempdir() に変更"]
    H --> I["tempdir()に保存"]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディレクトリ書き込み不可 | `touch(fpath)` で例外発生 | `tempdir()` にフォールバックし警告を出力 |
| `tempdir()` も書き込み不可 | システムの一時ディレクトリが利用不能 | 上位に例外が伝播する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 同一ディレクトリあたり上限 | 1回（`maxlog=1`, `_id=Symbol(wd)` による制御） |

### 配信時間帯

制限なし（ユーザー操作に応じて随時発行）

## セキュリティ考慮事項

- ログメッセージにカレントディレクトリと一時ディレクトリのフルパスが含まれるため、ログの共有時にはパス情報の漏洩に注意が必要
- ヒープスナップショット自体にメモリ内容が含まれる可能性があるため、`redact_data=true`（デフォルト）の使用を推奨

## 備考

- `maxlog=1` と `_id=Symbol(wd)` の組み合わせにより、同じカレントディレクトリでは1回限りの警告となるが、カレントディレクトリが変更されると再度警告が発行され得る
- ヒープスナップショットファイル名は `$(getpid())_$(time_ns()).heapsnapshot` の形式で自動生成される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヒープスナップショット機能は Chrome DevTools のヒープスナップショットフォーマット（`.heapsnapshot`）に準拠したJSONファイルを生成する。ストリーミングモードではノード・エッジ・文字列・メタデータの4つの中間ファイルを生成し、後でアセンブルする。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `take_heap_snapshot` 関数のシグネチャとドキュメント文字列（1375-1406行目） |

**読解のコツ**: Julia の多重ディスパッチにより `take_heap_snapshot` は複数のメソッドを持つ。引数なし版（1453行目）がデフォルトのエントリーポイントである。

#### Step 2: エントリーポイントを理解する

処理の起点は引数なしの `take_heap_snapshot` メソッド（1453行目）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `take_heap_snapshot(all_one::Bool=false; dir, kwargs...)` メソッド（1453-1469行目） |

**主要処理フロー**:
1. **1454行目**: ファイル名を `"$(getpid())_$(time_ns()).heapsnapshot"` 形式で生成
2. **1455-1456行目**: `dir` が `nothing` かどうかを確認
3. **1457-1459行目**: カレントディレクトリのパスを取得し `touch` でテスト
4. **1460行目**: テスト成功時は `rm` でテストファイルを削除
5. **1461-1463行目**: `catch` ブロックで `@warn` を発行し `tempdir()` にフォールバック
6. **1468行目**: 確定したパスで `take_heap_snapshot(fpath, all_one; kwargs...)` を呼び出し

#### Step 3: ストリーミング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Profile.jl | `stdlib/Profile/src/Profile.jl` | `_stream_heap_snapshot` 関数（1428-1452行目） |
| 3-2 | heapsnapshot_reassemble.jl | `stdlib/Profile/src/heapsnapshot_reassemble.jl` | `assemble_snapshot` 関数（80-213行目） |

**主要処理フロー**:
- **1430-1451行目**: 4つの中間ファイル（.nodes, .edges, .strings, .metadata.json）を開き、C関数 `jl_gc_take_heap_snapshot` を呼び出し

### プログラム呼び出し階層図

```
take_heap_snapshot(; dir=nothing, ...)     [Profile.jl:1453]
    │
    ├─ pwd()                                [カレントディレクトリ取得]
    ├─ touch(fpath)                         [書き込みテスト]
    │      └─ catch → @warn               [本通知の発行: L1462]
    │              └─ tempdir()            [フォールバック先取得]
    │
    └─ take_heap_snapshot(fpath, all_one)   [Profile.jl:1407]
           │
           ├─ _stream_heap_snapshot(...)    [Profile.jl:1428]
           │      └─ jl_gc_take_heap_snapshot (ccall)
           │
           └─ HeapSnapshot.assemble_snapshot(...)  [heapsnapshot_reassemble.jl:80]
                  └─ HeapSnapshot.cleanup_streamed_files(...)
```

### データフロー図

```
[入力]                       [処理]                           [出力]

pwd() ─────────────────▶ touch()でテスト ──(失敗)──▶ @warn ログ出力
                              │                              (stderr)
dir=nothing ───────────▶ フォールバック判定 ────────▶ fpath決定
                              │
GCヒープデータ ────────▶ jl_gc_take_heap_snapshot ──▶ .heapsnapshot ファイル
                              │                       (tempdir() or pwd())
                              ▼
                     中間ファイル4種生成 ──▶ assemble_snapshot ──▶ 最終ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Profile.jl | `stdlib/Profile/src/Profile.jl` | ソース | 通知発行元、ヒープスナップショットのメインロジック |
| heapsnapshot_reassemble.jl | `stdlib/Profile/src/heapsnapshot_reassemble.jl` | ソース | ストリーミングファイルのアセンブル処理 |
