# 通知設計書 43-アロケーションプロファイル停止警告

## 概要

本ドキュメントは、Julia の Profile.Allocs モジュールにおけるアロケーションプロファイリングのサンプル不足警告（`@warn "There were no samples collected."`）の通知設計について記載する。

### 本通知の処理概要

アロケーションプロファイリングの結果を表示する際に、収集されたサンプルが空の場合にユーザーに警告を発行する通知である。

**業務上の目的・背景**：`Profile.Allocs` モジュールはメモリ割り当てのプロファイリング機能を提供する。`@profile` マクロやAPIを使ってアロケーションを記録し、その結果を `print` や `fetch` で取得・表示する。しかし、プロファイリング対象のコードが短時間で完了した場合や、サンプリングレートが低すぎる場合、サンプルが全く収集されないことがある。このような場合、ユーザーが結果がないことに気づかずに分析を続けることを防ぐため、本警告を発行する。

**通知の送信タイミング**：`Profile.Allocs.print()` が呼び出され、フラット表示（`flat` 関数）またはツリー表示（`tree` 関数）の結果が空の場合に送信される。

**通知の受信者**：Julia プロセスを実行しアロケーションプロファイリングを行っている開発者。

**通知内容の概要**：サンプルが収集されなかったこと、およびプログラムをより長時間実行するか `sample_rate=1.0` でサンプリングレートを上げることを推奨するメッセージ。

**期待されるアクション**：ユーザーはプロファイリング対象のコードをより長時間実行するか、`sample_rate` パラメータを調整して再度プロファイリングを実施する。

## 通知種別

ログ出力（`@warn` マクロによる標準エラー出力へのWarnレベルログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@warn` マクロによる即時ログ出力） |
| 優先度 | 中（Warn レベル） |
| リトライ | なし（ログ出力のため） |

### 送信先決定ロジック

Julia のログシステムに委譲される。デフォルトでは `stderr` に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
┌ Warning: There were no samples collected.
│ Run your program longer (perhaps by running it multiple times),
│ or adjust the frequency of samples to record every event with
│ the `sample_rate=1.0` kwarg.
└ @ Profile.Allocs stdlib/Profile/src/Allocs.jl:227
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `Profile.Allocs.print()` / `flat()` | `isempty(lilist)`（解析結果のスタックフレームリストが空） | フラット表示で結果が空の場合 |
| API呼び出し | `Profile.Allocs.print()` / `tree()` | `isempty(root.down)`（ツリーのルート直下が空） | ツリー表示で結果が空の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サンプルが存在する場合 | 1件以上のアロケーションサンプルが収集された場合は警告なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["Allocs.print() 呼び出し"] --> B["fetch() でデータ取得"]
    B --> C{"format 確認"}
    C -->|":flat"| D["parse_flat() 実行"]
    C -->|":tree"| E["tree!() 実行"]
    D --> F{"結果が空?"}
    E --> G{"root.down が空?"}
    F -->|Yes| H["warning_empty() 呼び出し"]
    F -->|No| I["正常表示"]
    G -->|Yes| H
    G -->|No| I
    H --> J["@warn 出力"]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サンプル不足 | プロファイリング対象コードが短すぎる、またはサンプルレートが低い | 警告を出力して `true` を返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 上限 | 特に制限なし（呼び出しごとに出力） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージは固定文字列のみであり、機密情報は含まれない

## 備考

- `Profile.Allocs` は Julia 1.8 で追加された機能
- サンプリングレート 1.0 は全アロケーションを記録するが、パフォーマンスに大きな影響を与える
- `Profile.Allocs.clear()` でプロファイルデータをクリアした後に `print()` を呼ぶとこの警告が発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アロケーションプロファイリングのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Allocs.jl | `stdlib/Profile/src/Allocs.jl` | `RawAlloc` 構造体（25-31行目）、`Alloc` 構造体（132-138行目）、`AllocResults` 構造体（140-142行目） |

**読解のコツ**: `RawAlloc` はC側のデータ構造に対応し、`Alloc` はJulia側でデコードされたデータ。`decode` 関数（185-192行目）がC側データをJulia側データに変換する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Allocs.jl | `stdlib/Profile/src/Allocs.jl` | `print` 関数群（243-248行目）と `Profile.print(io, data::AllocResults, ...)` 拡張（252-268行目） |

**主要処理フロー**:
1. **243行目**: `print(; kwargs...)` が `fetch()` でデータ取得し `Profile.print` に渡す
2. **270-283行目**: `Profile.print` が `:tree` または `:flat` 形式を選択して処理

#### Step 3: 警告発行箇所を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Allocs.jl | `stdlib/Profile/src/Allocs.jl` | `warning_empty()` 関数（225-231行目） |
| 3-2 | Allocs.jl | `stdlib/Profile/src/Allocs.jl` | `flat()` 関数（321-333行目）、326行目で `isempty(lilist)` チェック |
| 3-3 | Allocs.jl | `stdlib/Profile/src/Allocs.jl` | `tree()` 関数（405-420行目）、413行目で `isempty(root.down)` チェック |

### プログラム呼び出し階層図

```
Profile.Allocs.print(; kwargs...)         [Allocs.jl:243]
    │
    ├─ Allocs.fetch()                      [Allocs.jl:125]
    │      └─ jl_fetch_alloc_profile (ccall)
    │             └─ decode(raw_results)   [Allocs.jl:185]
    │
    └─ Profile.print(io, data::AllocResults, ...) [Allocs.jl:252]
           │
           ├─ flat(io, data, ...)          [Allocs.jl:321]
           │      ├─ parse_flat(...)       [Allocs.jl:286]
           │      └─ isempty → warning_empty() [Allocs.jl:225: 本通知]
           │
           └─ tree(io, data, ...)          [Allocs.jl:405]
                  ├─ tree!(...)            [Allocs.jl:335]
                  └─ isempty → warning_empty() [Allocs.jl:225: 本通知]
```

### データフロー図

```
[入力]                        [処理]                       [出力]

Cランタイム ────────────▶ jl_fetch_alloc_profile
アロケーション記録              │
                               ▼
                         decode() → AllocResults
                               │
                               ▼
                    flat()/tree() で解析
                               │
                               ▼
                    結果が空 → warning_empty() ──▶ @warn ログ出力
                    結果あり → print出力                (stderr)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Allocs.jl | `stdlib/Profile/src/Allocs.jl` | ソース | 通知発行元、アロケーションプロファイリング全体のロジック |
| Profile.jl | `stdlib/Profile/src/Profile.jl` | ソース | Profileモジュール本体、共通データ構造（`StackFrameTree` 等）の定義 |
