# 通知設計書 46-BugReportingインストール試行通知

## 概要

本ドキュメントは、Julia の InteractiveUtils モジュールにおける BugReporting パッケージの一時インストール試行通知（`@info "Package BugReporting not found"`）の通知設計について記載する。

### 本通知の処理概要

`report_bug` 関数が呼び出された際に、BugReporting パッケージが現在の環境に存在しない場合、一時的なインストールを試行することをユーザーに通知する情報メッセージである。

**業務上の目的・背景**：Julia のバグレポート機能は BugReporting パッケージに依存しているが、標準環境にはインストールされていない場合がある。ユーザーがバグレポートを作成しようとした際にパッケージが見つからなかった場合、一時的な環境を作成してインストールを試行する。本通知は、パッケージが見つからなかったことと、一時インストールが行われることをユーザーに伝え、処理の進行状況を明示する目的で発行される。

**通知の送信タイミング**：`report_bug(kind)` 関数内で `Base.locate_package(BugReportingId)` が `nothing` を返した時点で送信される。

**通知の受信者**：Julia のバグレポート機能を使用しているユーザー。

**通知内容の概要**：BugReporting パッケージが見つからなかったこと、および一時インストールを試行することを通知する。

**期待されるアクション**：ユーザーは一時インストール処理の完了を待機する。将来的にはバグレポート機能を頻繁に使用する場合、`Pkg.add("BugReporting")` でインストールすることを検討する。

## 通知種別

ログ出力（`@info` マクロによる標準エラー出力へのInfoレベルログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`@info` マクロによる即時ログ出力） |
| 優先度 | 低（Info レベル） |
| リトライ | なし（ログ出力のため） |

### 送信先決定ロジック

Julia のログシステムに委譲される。デフォルトでは `stderr` に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
[ Info: Package `BugReporting` not found - attempting temporary installation
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `report_bug(kind)` 関数内での `locate_package` 実行 | `Base.locate_package(BugReportingId) === nothing` | BugReporting パッケージが見つからない場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| パッケージが存在する場合 | `locate_package` が非 `nothing` を返した場合はこの通知はスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["report_bug(kind) 呼び出し"] --> B["@info 'Loading BugReporting package...'"]
    B --> C["Base.locate_package(BugReportingId)"]
    C --> D{"パッケージが存在?"}
    D -->|Yes| E["Base.require で読み込み"]
    D -->|No| F["@info 'Package BugReporting not found...' 出力"]
    F --> G["一時ディレクトリ作成 (mktempdir)"]
    G --> H["LOAD_PATH を一時環境に切替"]
    H --> I["Pkg.add(BugReporting) 実行"]
    I --> J["Base.require(BugReportingId) 実行"]
    J --> K["LOAD_PATH を復元"]
    K --> L["make_interactive_report 実行"]
    E --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| インストール失敗 | ネットワーク未接続やレジストリ不達 | 例外が上位に伝播する |
| require失敗 | パッケージの読み込みに問題がある | 例外が上位に伝播する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 上限 | 特に制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 一時インストールはネットワーク経由でパッケージをダウンロードするため、ネットワーク環境への依存がある
- 一時ディレクトリは `mktempdir` で作成され、処理後に自動的にクリーンアップされる

## 備考

- 一時インストール時には `LOAD_PATH` と `ACTIVE_PROJECT` が一時的に変更され、処理後に復元される
- BugReporting パッケージの UUID は `bcf9a6e7-4020-453c-b88e-690564246bb8`
- 本通知は No.45（BugReportingパッケージ読込通知）の後に発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッケージの識別と環境管理の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `BugReportingId` の `PkgId` と `UUID` 定義（351-352行目） |
| 1-2 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `LOAD_PATH` と `ACTIVE_PROJECT` の操作（360-363, 367-368行目） |

**読解のコツ**: Julia のパッケージ管理はUUIDベースで一意に識別される。`LOAD_PATH` はパッケージ検索パスのスタックであり、一時環境を作るために一時的に入れ替えている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | `report_bug(kind)` 関数（349-376行目） |

**主要処理フロー**:
1. **350行目**: No.45 の通知を出力
2. **354行目**: `Base.locate_package(BugReportingId)` でパッケージ存在確認
3. **355行目**: `nothing` の場合、`@info "Package BugReporting not found - attempting temporary installation"` を出力（本通知）
4. **357-358行目**: `Pkg` stdlib を読み込み
5. **359行目**: `mktempdir` で一時ディレクトリを作成
6. **360-361行目**: `LOAD_PATH` を一時 `Project.toml` に入れ替え
7. **362-363行目**: `ACTIVE_PROJECT` をリセット
8. **364行目**: `PackageSpec` を作成
9. **365行目**: `Pkg.add` でインストール
10. **366行目**: `Base.require` で読み込み
11. **367-368行目**: `LOAD_PATH` と `ACTIVE_PROJECT` を復元

### プログラム呼び出し階層図

```
report_bug(kind)                             [InteractiveUtils.jl:349]
    │
    ├─ @info "Loading BugReporting package..."  [350行目: No.45]
    │
    ├─ Base.locate_package(BugReportingId)      [354行目]
    │      └─ === nothing
    │
    ├─ @info "Package BugReporting not found..."  [355行目: 本通知]
    │
    ├─ Base.require_stdlib(Pkg)                 [357-358行目]
    │
    ├─ mktempdir()                              [359行目]
    │      ├─ LOAD_PATH 入れ替え               [360-361行目]
    │      ├─ Pkg.add(pkgspec)                  [365行目]
    │      ├─ Base.require(BugReportingId)      [366行目]
    │      └─ LOAD_PATH 復元                   [367-368行目]
    │
    └─ BugReporting.make_interactive_report()   [375行目]
```

### データフロー図

```
[入力]                        [処理]                           [出力]

kind ──────────────────▶ report_bug()
                               │
BugReportingId ────────▶ locate_package() → nothing
                               │
                               ├─ @info ──────────────────▶ ログ出力 (stderr)
                               │
                               ├─ mktempdir + Pkg.add ───▶ 一時環境にパッケージ追加
                               │
                               └─ make_interactive_report ─▶ バグレポート
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InteractiveUtils.jl | `stdlib/InteractiveUtils/src/InteractiveUtils.jl` | ソース | 通知発行元、`report_bug` 関数の定義 |
