# 通知設計書 5-スレッド無効化フック失敗警告

## 概要

本ドキュメントは、Juliaランタイムにおけるスレッド無効化フック失敗警告通知の設計を記述する。ライブラリのスレッド機能を無効化するためのフック関数が実行中に例外をスローした場合に警告ログを出力する。

### 本通知の処理概要

**業務上の目的・背景**：Juliaは外部ライブラリ（BLAS等）のスレッド機能を制御するためのフック機構を持つ。マルチスレッド環境でのライブラリ動作を安全に管理するため、ライブラリ固有のスレッド無効化処理を登録・実行する。フック関数が失敗した場合、ライブラリのスレッド設定が不整合な状態になる可能性があり、開発者への通知が必要である。

**通知の送信タイミング**：`disable_library_threading`関数内で、登録されたフック関数をpop/実行する際に例外が発生した場合に通知される。

**通知の受信者**：Juliaプログラムを実行している開発者。ログメッセージとして標準エラー出力（または設定されたログハンドラ）に出力される。

**通知内容の概要**：「a hook from a library to disable threading failed:」というメッセージが`@warn`マクロにより出力される。例外オブジェクトとバックトレースが`exception`キーワード引数として付随する。

**期待されるアクション**：開発者はフック関数を提供しているライブラリのバージョンや設定を確認する。フック失敗はスレッドの不整合を引き起こす可能性があるため、該当ライブラリのアップデートや設定変更を検討する。

## 通知種別

ログ出力（Warnレベル） - Juliaの`@warn`マクロによるロギングシステム経由の警告通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`disable_library_threading`関数内で即座に出力） |
| 優先度 | 中（スレッド設定の不整合は予期しない動作を引き起こす可能性あり） |
| リトライ | 無し |

### 送信先決定ロジック

Juliaのロギングフレームワーク（`CoreLogging`）に委譲される。デフォルトでは`stderr`に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
┌ Warning: a hook from a library to disable threading failed:
│   exception =
│    ErrorException("...")
│    Stacktrace:
│     [1] ...
└ @ Base initdefs.jl:552
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| exception | 発生した例外オブジェクトとバックトレースのタプル | `(err, catch_backtrace())` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `disable_library_threading()`の実行 | 登録されたフック関数`f()`が例外をスロー | フック関数のtry-catchで捕捉された任意の例外 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フック関数が正常完了 | 例外が発生しなければ通知されない |
| フックリストが空 | 登録されたフック関数がない場合は処理自体が実行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[disable_library_threading呼び出し] --> B["library_threading_enabled = false"]
    B --> C{フックリストが空?}
    C -->|Yes| D[終了]
    C -->|No| E["f = pop!(hooks)"]
    E --> F["f() 実行"]
    F --> G{例外発生?}
    G -->|No| C
    G -->|Yes| H["@warn フック失敗警告"]
    H --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（データベースは使用しない）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フック関数例外 | ライブラリのスレッド無効化処理が失敗 | 警告出力後、次のフックの処理を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし。失敗したフックはリストから除去される） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（失敗したフックごとに出力） |

### 配信時間帯

制限なし（スレッド無効化処理時に出力）

## セキュリティ考慮事項

例外のバックトレースにライブラリの内部パスやコード構造が含まれる可能性がある。本番環境ではログの出力先管理に注意が必要である。

## 備考

- `disable_library_threading_hooks`は`Base.OncePerProcess`で管理される（535行目）
- `at_disable_library_threading`関数でフックを登録する（537-543行目）
- フックはLIFO順（`pop!`）で実行される
- `library_threading_enabled`グローバル変数で状態管理される（531行目）
- フック登録時に既にスレッドが無効化されていれば即座に`disable_library_threading`が呼ばれる（539-541行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スレッド無効化フックの管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | initdefs.jl | `base/initdefs.jl` | `library_threading_enabled`グローバル変数（531行目）とフックリスト（535行目） |

**読解のコツ**: `OncePerProcess`はセッションごとに1回だけ初期化されるコンテナであり、sysimage構築時のフック登録が次のセッションに持ち越されないよう設計されている。

#### Step 2: エントリーポイントを理解する

通知が発生する`disable_library_threading`関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | initdefs.jl | `base/initdefs.jl` | `disable_library_threading`関数（545-557行目） |

**主要処理フロー**:
1. **546行目**: `library_threading_enabled = false`でフラグを無効化
2. **547行目**: `while !isempty(hooks)`でフックリストを順次処理
3. **548行目**: `f = pop!(hooks)`でフック関数を取り出す（LIFO順）
4. **550行目**: `f()`でフック関数を実行
5. **551-553行目**: 例外時に`@warn`を出力

#### Step 3: フック登録のフローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | initdefs.jl | `base/initdefs.jl` | `at_disable_library_threading`関数（537-543行目） - フック登録API |

### プログラム呼び出し階層図

```
ライブラリ初期化コード
    |
    +-- at_disable_library_threading(f)  [base/initdefs.jl:537]
        |
        +-- push!(hooks, f)  [base/initdefs.jl:538]
        +-- (既に無効なら) disable_library_threading()  [base/initdefs.jl:540]

disable_library_threading()  [base/initdefs.jl:545]
    |
    +-- library_threading_enabled = false
    +-- while !isempty(hooks)
        |
        +-- f = pop!(hooks)
        +-- f()  (try)
        +-- (例外時) @warn "a hook from a library..."  [base/initdefs.jl:552]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

フック関数リスト ────> disable_library_threading       ──> library_threading_enabled = false
                       |
                       +-- pop! + f()
                       +-- (失敗時) @warn ──────────> stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| initdefs.jl | `base/initdefs.jl` | ソース | スレッド無効化フック管理の全実装 |
