# 通知設計書 52-履歴ファイル無効化通知

## 概要

本ドキュメントは、Julia REPLの履歴ファイル初期化時にエラーが発生し、セッション中の履歴ファイル機能が無効化された場合に発行される情報通知の設計を記述する。

### 本通知の処理概要

REPL起動時に履歴ファイルの初期化を試み、ファイルの作成・読み込みに失敗した場合にユーザーへ通知し、当該セッションでの履歴ファイル機能を無効化する処理である。

**業務上の目的・背景**：Julia REPLは入力履歴をファイルに永続化し、セッション間で履歴を共有する機能を持つ。しかし、ファイルシステムの問題（パーミッション不足、ディスク容量不足など）により履歴ファイルの初期化に失敗する場合がある。この通知は、履歴機能が利用できない状態であることをユーザーに明示し、REPLセッション自体は正常に続行できることを伝えるために存在する。

**通知の送信タイミング**：REPL起動時のステージII（履歴セットアップ）において、`find_hist_file()` でパスを取得し `mkpath` でディレクトリを作成し `HistoryFile(path)` でファイルを開く一連の処理が例外をスローした場合にトリガーされる。

**通知の受信者**：REPLを起動したユーザー本人。エラー出力（stderr）経由でターミナルに表示される。

**通知内容の概要**：エラーの詳細（例外情報とスタックトレース）に続き、「Disabling history file for this session」という情報メッセージが表示される。

**期待されるアクション**：ユーザーは履歴ファイルのパス・パーミッションを確認し問題を修正するか、履歴なしでセッションを継続する。

## 通知種別

ログ（Info） - Julia標準ロギングフレームワーク `@info` マクロによるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（REPL初期化フロー内で即座に出力） |
| 優先度 | 中（Infoレベルだが、機能喪失を伴う） |
| リトライ | 無し |

### 送信先決定ロジック

REPLセッションを起動したユーザー本人が受信者。`@info` マクロによりグローバルロガーの設定に従いstderrへ出力される。事前に `print_response` で例外情報も出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
[例外情報とスタックトレース]
Info: Disabling history file for this session
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| (例外情報) | 履歴ファイル初期化時の例外 | `current_exceptions()` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| REPL初期化 | 履歴ファイルのセットアップ失敗 | `repl.history_file == true` かつ履歴ファイル初期化時に例外がスローされた場合 | ステージIIの try-catch ブロック内で処理 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `repl.history_file == false` | 履歴ファイル機能が最初から無効の場合、初期化自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[REPL起動 ステージII] --> B{repl.history_file == true?}
    B -->|No| C[履歴セットアップスキップ]
    B -->|Yes| D[find_hist_file でパス取得]
    D --> E[mkpath でディレクトリ作成]
    E --> F[HistoryFile でファイルオープン]
    F --> G{例外発生?}
    G -->|No| H[履歴初期化完了]
    G -->|Yes| I[print_response で例外情報出力]
    I --> J[@info Disabling history file]
    J --> K[repl.history_file = false]
    K --> L[セッション続行（履歴なし）]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルシステム上の履歴ファイルを参照）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし（`repl.history_file` フラグが `false` に設定される）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイルシステムエラー | パーミッション不足、ディスク容量不足など | 例外を catch し、履歴機能を無効化してセッション続行 |
| パス解決エラー | 履歴ファイルパスが不正 | 同上 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 該当なし（REPL起動時に1回のみ発生し得る） |
| 1日あたり上限 | 該当なし |

### 配信時間帯

制限なし（REPL起動時に発生）

## セキュリティ考慮事項

履歴ファイルのパス情報がエラーメッセージに含まれる場合があるが、ユーザーのローカル環境情報であり、リモートに送信されることはない。

## 備考

- 履歴ファイルの初期化はREPLセットアップのステージIIで行われる（REPL.jl 1362行目以降）
- 例外情報は `print_response` で先に出力され、その後に `@info` メッセージが出力される
- `repl.history_file = false` に設定されるため、以降のセッションでは履歴関連の処理がスキップされる
- 履歴初期化は `@async history_do_initialize(hp)` で非同期に行われるが、ファイルオープン自体は同期的に実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

REPL履歴管理に関するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | 1366-1369行目: `REPLHistoryProvider` の初期化。各モードのプロンプトと紐づけ |

**読解のコツ**: `REPLHistoryProvider` は REPL の全モード（julia, shell, help, pkg）で共有される統一履歴プロバイダである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | 1370-1385行目: 履歴ファイル初期化の try-catch ブロック全体 |

**主要処理フロー**:
1. **1370行目**: `if repl.history_file` で履歴ファイル機能が有効かチェック
2. **1372行目**: `find_hist_file()` で履歴ファイルパスを取得
3. **1373行目**: `mkpath(dirname(path))` でディレクトリを作成
4. **1374行目**: `hp.history = HistoryFile(path)` でファイルをオープン
5. **1375行目**: `@async history_do_initialize(hp)` で非同期に履歴読み込み開始
6. **1379-1385行目**: catch ブロックで例外処理、`@info` 出力、フラグ無効化

#### Step 3: 例外発生後の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | 1381行目: `print_response` で例外情報を出力 |
| 3-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | 1383行目: `@info "Disabling history file for this session"` で通知 |
| 3-3 | REPL.jl | `stdlib/REPL/src/REPL.jl` | 1384行目: `repl.history_file = false` でフラグ無効化 |

### プログラム呼び出し階層図

```
REPL setup_interface (Stage II)
    |
    +-- [条件] repl.history_file == true
           |
           +-- find_hist_file()
           +-- mkpath(dirname(path))
           +-- HistoryFile(path)
           +-- @async history_do_initialize(hp)
           |
           +-- [例外発生時]
                  +-- print_response(repl, exceptions, ...)
                  +-- @info "Disabling history file for this session"
                  +-- repl.history_file = false
```

### データフロー図

```
[入力]                     [処理]                              [出力]

repl.history_file -------> 履歴ファイル初期化 try ブロック -----> 正常: 履歴有効
      = true                       |
                                   +-> 例外発生
                                   |       |
                                   |       +-> print_response --> stderr (例外詳細)
                                   |       +-> @info -----------> stderr ("Disabling...")
                                   |       +-> repl.history_file = false
                                   |
                                   +-----------------------------> 異常: 履歴無効
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | 履歴初期化とエラー処理（1362-1386行目） |
