# 通知設計書 55-SyntaxHighlightPassエラー

## 概要

本ドキュメントは、Julia REPLの構文ハイライトパス（`SyntaxHighlightPass`）の実行中にエラーが発生した場合に発行されるエラー通知の設計を記述する。

### 本通知の処理概要

REPLの入力行に対する構文ハイライト処理で、`JuliaSyntaxHighlighting.highlight` 関数の呼び出しが例外をスローした場合に、エラー情報をログに出力し、ハイライトなしの入力文字列をフォールバックとして返す処理である。

**業務上の目的・背景**：Julia REPLは入力中のコードにリアルタイムで構文ハイライトを適用する。`SyntaxHighlightPass` は `JuliaSyntaxHighlighting` パッケージの `highlight` 関数を呼び出してASTに基づく構文色付けを行う。しかし、特定の入力パターンやエッジケースでハイライト処理が例外をスローする可能性がある。この通知は、ハイライトエラーがREPLの操作性を損なわないようフォールバック処理を行いつつ、開発者にエラーの存在を通知するために存在する。

**通知の送信タイミング**：`SyntaxHighlightPass` の `call` メソッド（`(::SyntaxHighlightPass)(input, ast, context)`）内で `JuliaSyntaxHighlighting.highlight(input, ast)` が例外をスローした場合にトリガーされる。`maxlog=1` により1セッション中1回のみ出力される。

**通知の受信者**：REPLを使用している開発者本人。ターミナルの標準エラー出力を通じて表示される。

**通知内容の概要**：「Error in SyntaxHighlightPass」というメッセージと、発生した例外およびスタックトレース情報が含まれる。

**期待されるアクション**：開発者は、Julia本体や `JuliaSyntaxHighlighting` パッケージのバグレポートを提出することが推奨される。ハイライトなしでもREPLの動作は継続するため、即座の対応は不要である。

## 通知種別

ログ（Error） - Julia標準ロギングフレームワーク `@error` マクロによるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（スタイリングパス実行中に即座に出力） |
| 優先度 | 高（Errorレベル） |
| リトライ | 無し |

### 送信先決定ロジック

REPLセッション中のコード入力者本人が受信者。`@error` マクロによりグローバルロガーの設定に従いstderrへ出力される。`maxlog=1` により1セッション中1回のみ出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
Error: Error in SyntaxHighlightPass
  exception = {例外オブジェクトとスタックトレース}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| exception | 発生した例外とスタックトレース | `(e, catch_backtrace())` タプル | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| REPL入力 | 構文ハイライトパスの実行 | `JuliaSyntaxHighlighting.highlight(input, ast)` が例外をスロー | `SyntaxHighlightPass` の call メソッド内の try-catch |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 正常なハイライト処理 | ハイライト関数が正常に完了した場合は通知されない |
| `maxlog=1` 制限到達 | 既に1回通知が出力されている場合は抑止される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[REPL入力変更検出] --> B[apply_styling_passes 呼び出し]
    B --> C[JuliaSyntax.parseall でAST生成]
    C --> D[SyntaxHighlightPass 実行]
    D --> E[JuliaSyntaxHighlighting.highlight 呼び出し]
    E --> F{例外発生?}
    F -->|No| G[AnnotatedString 返却]
    F -->|Yes| H[@error Error in SyntaxHighlightPass]
    H --> I[AnnotatedString input フォールバック返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ハイライト処理エラー | `JuliaSyntaxHighlighting.highlight` が任意の例外をスロー | `@error` で通知し、入力文字列をそのまま `AnnotatedString` として返却（フォールバック） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし。次の入力時に再度試行される） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1（`maxlog=1` によりセッション中1回のみ） |
| 1日あたり上限 | 1（同上） |

### 配信時間帯

制限なし（REPLセッション中いつでも発生し得る）

## セキュリティ考慮事項

例外情報にスタックトレースが含まれるが、ローカル環境で表示されるのみであり、セキュリティ上の問題はない。

## 備考

- `SyntaxHighlightPass` は `StylingPass` 抽象型のサブタイプとして定義されている（StylingPasses.jl 57行目）
- ASTは `apply_styling_passes` 内で `JuliaSyntax.parseall` により1回だけパースされ、全スタイリングパスで共有される（50行目）
- フォールバックとして `AnnotatedString(input)` が返され、スタイリングなしの入力がそのまま表示される（64行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

スタイリングパスシステムの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 16-20行目: `StylingContext` 構造体。カーソル位置やリージョン情報を保持 |
| 1-2 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 24行目: `StylingPass` 抽象型 |
| 1-3 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 57行目: `SyntaxHighlightPass` 構造体定義 |

**読解のコツ**: `StylingPass` のサブタイプはcallableオブジェクトとして定義され、`(pass)(input, ast, context)` の形で呼び出される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 44-54行目: `apply_styling_passes` 関数。ASTをパースし全パスを適用 |

**主要処理フロー**:
1. **50行目**: `JuliaSyntax.parseall` でASTを生成
2. **52行目**: 各パスに対して `apply_style` を呼び出し
3. **53行目**: `merge_annotations` で結果を統合

#### Step 3: SyntaxHighlightPass のエラー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | 59-66行目: `SyntaxHighlightPass` の call メソッド |

**主要処理フロー**:
- **61行目**: `JuliaSyntaxHighlighting.highlight(input, ast)` 呼び出し
- **63行目**: `@error "Error in SyntaxHighlightPass" exception=(e, catch_backtrace()) maxlog=1` 通知
- **64行目**: `AnnotatedString(input)` フォールバック返却

### プログラム呼び出し階層図

```
apply_styling_passes(input, passes, context)  [StylingPasses.jl:44]
    |
    +-- JuliaSyntax.parseall(GreenNode, input)  [StylingPasses.jl:50]
    +-- [各パスに対して]
           |
           +-- apply_style(pass, input, ast, context)  [StylingPasses.jl:40]
                  |
                  +-- SyntaxHighlightPass(input, ast, context)  [StylingPasses.jl:59]
                         |
                         +-- JuliaSyntaxHighlighting.highlight(input, ast)
                         |       |
                         |       +-- [例外発生時]
                         |              +-- @error "Error in SyntaxHighlightPass"  [StylingPasses.jl:63]
                         |              +-- return AnnotatedString(input)  [StylingPasses.jl:64]
                         |
                         +-- [正常時] return AnnotatedString (ハイライト付き)
    |
    +-- merge_annotations(results)  [StylingPasses.jl:53]
```

### データフロー図

```
[入力]                       [処理]                              [出力]

入力文字列(String) -------> JuliaSyntax.parseall -> AST
                                    |
                                    +-> SyntaxHighlightPass
                                    |       |
                                    |       +-> highlight(input, ast)
                                    |       |       |
                                    |       |       +-> 正常: AnnotatedString (色付き)
                                    |       |       +-> 異常: @error -> stderr
                                    |       |                  +-> AnnotatedString(input) (無色)
                                    |
                                    +-> merge_annotations
                                            |
                                            +-> 最終 AnnotatedString --> REPL表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StylingPasses.jl | `stdlib/REPL/src/StylingPasses.jl` | ソース | スタイリングパスシステムと SyntaxHighlightPass の実装（1-66行目） |
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | StylingPasses モジュールのインクルードとusing（70-71行目） |
| LineEdit.jl | `stdlib/REPL/src/LineEdit.jl` | ソース | スタイリングパスの利用（7行目のusing） |
