# 通知設計書 57-ドキュメント検索不能警告

## 概要

本ドキュメントは、Julia REPLのドキュメント検索機能（`apropos`）において、指定された型のドキュメントオブジェクトに対して検索が実行できない場合に発行される警告通知の設計を記述する。

### 本通知の処理概要

`docsearch` 関数のフォールバックメソッドにおいて、既知のドキュメント型（`AbstractString`、`Symbol`、`Array`、`MultiDoc`、`DocStr`、`Markdown.MD` など）に該当しないドキュメントオブジェクトが検索対象として渡された場合に、警告を出力して `false`（検索不一致）を返す処理である。

**業務上の目的・背景**：Juliaのヘルプモード（`?` キーで起動）や `apropos` 関数は、ドキュメント文字列を検索してユーザーが必要な情報を見つけるのを支援する。ドキュメントオブジェクトは様々な型で格納されるが、全ての型に対する検索ロジックが実装されているわけではない。この警告は、未対応の型に遭遇した場合にその事実を開発者に通知し、将来的な検索機能の拡張の手がかりとするために存在する。

**通知の送信タイミング**：`docsearch(haystack, needle)` のフォールバックメソッドが呼び出された時にトリガーされる。これは、`haystack` が `AbstractString`、`Symbol`、`Nothing`、`Array`、`MultiDoc`、`DocStr`、`Markdown.MD` のいずれにも該当しない場合に発生する。`maxlog=1` により1セッション中1回のみ出力される。

**通知の受信者**：REPLのヘルプモードまたは `apropos` 関数を使用している開発者本人。

**通知内容の概要**：「Unable to search documentation of type {型名}」という警告メッセージが表示される。

**期待されるアクション**：通常、ユーザーの直接的なアクションは不要である。Julia開発者がこの警告を観察した場合、該当する型に対する `docsearch` メソッドの追加を検討する。

## 通知種別

ログ（Warn） - Julia標準ロギングフレームワーク `@warn` マクロによるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ドキュメント検索処理中に即座に出力） |
| 優先度 | 低（Warnレベル） |
| リトライ | 無し |

### 送信先決定ロジック

REPLセッション中のコード入力者本人が受信者。`@warn` マクロによりグローバルロガーの設定に従いstderrへ出力される。`maxlog=1` により1回のみ。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
Warning: Unable to search documentation of type {typeof(haystack)}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| typeof(haystack) | 検索不能なドキュメントオブジェクトの型名 | `typeof(haystack)` の結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ヘルプモード/apropos | ドキュメント検索の実行 | `docsearch` のフォールバックメソッドが呼び出された場合 | 既知の型に対するメソッドがディスパッチされなかった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既知の型 | `AbstractString`、`Symbol`、`Nothing`、`Array`、`MultiDoc`、`DocStr`、`Markdown.MD` の場合は専用メソッドが呼ばれる |
| `maxlog=1` 制限到達 | 既に1回通知が出力されている場合は抑止される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[apropos/ヘルプ検索実行] --> B[docsearch 呼び出し]
    B --> C{haystack の型?}
    C -->|AbstractString| D[occursin で検索]
    C -->|Symbol| E[string 変換後に検索]
    C -->|Array| F[各要素を再帰検索]
    C -->|MultiDoc/DocStr/MD| G[専用メソッドで検索]
    C -->|Nothing| H[false 返却]
    C -->|その他| I[@warn Unable to search documentation]
    I --> J[false 返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Juliaのドキュメントシステムのメタデータを参照）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 未対応型 | `docsearch` のフォールバックメソッドが呼び出される | `@warn` で通知し `false` を返却（検索不一致として扱う） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1（`maxlog=1` によりセッション中1回のみ） |
| 1日あたり上限 | 1（同上） |

### 配信時間帯

制限なし（REPLセッション中いつでも発生し得る）

## セキュリティ考慮事項

通知にはドキュメントオブジェクトの型名のみが含まれ、機密情報は含まない。

## 備考

- `docsearch` はJuliaの多重ディスパッチを利用して型ごとに異なる検索戦略を適用する
- フォールバックメソッドは、未対応の型に対するセーフティネットとして機能する
- `maxlog=1` により、同一型への繰り返し検索で大量の警告が出ることを防止する
- この関数は `apropos` 関数から間接的に呼び出される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ドキュメントシステムの型構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docview.jl | `stdlib/REPL/src/docview.jl` | 7-8行目: `Base.Docs` からインポートされる型（`DocStr`、`MultiDoc`、`Binding` など） |

**読解のコツ**: Juliaのドキュメントシステムは `Base.Docs` モジュールに実装されており、`MultiDoc` はバインディングに対する複数のドキュメント、`DocStr` は個々のドキュメント文字列を表す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docview.jl | `stdlib/REPL/src/docview.jl` | 932-945行目: `docsearch` 関数群の定義 |

**主要処理フロー**:
1. **933行目**: `docsearch(haystack::AbstractString, needle)` - 文字列検索
2. **934行目**: `docsearch(haystack::Symbol, needle)` - シンボルの文字列変換
3. **935行目**: `docsearch(::Nothing, needle)` - Nothing は常に false
4. **936-941行目**: `docsearch(haystack::Array, needle)` - 配列の再帰検索
5. **942-944行目**: `docsearch(haystack, needle)` - フォールバック（本通知）

#### Step 3: 専用メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docview.jl | `stdlib/REPL/src/docview.jl` | 948-953行目: `docsearch(haystack::MultiDoc, needle)` |
| 3-2 | docview.jl | `stdlib/REPL/src/docview.jl` | 955-963行目: `docsearch(haystack::DocStr, needle)` |
| 3-3 | docview.jl | `stdlib/REPL/src/docview.jl` | 968行目: `docsearch(haystack::Markdown.MD, needle)` |

### プログラム呼び出し階層図

```
apropos(needle)  [Base.Docs]
    |
    +-- [各モジュールのドキュメントを走査]
           |
           +-- docsearch(doc_object, needle)  [docview.jl:932-968]
                  |
                  +-- [型に応じたメソッドディスパッチ]
                         |
                         +-- docsearch(::AbstractString, needle)  -> occursin
                         +-- docsearch(::Symbol, needle)  -> string変換
                         +-- docsearch(::Nothing, needle)  -> false
                         +-- docsearch(::Array, needle)  -> 再帰検索
                         +-- docsearch(::MultiDoc, needle)  -> values走査
                         +-- docsearch(::DocStr, needle)  -> parsedoc
                         +-- docsearch(::Markdown.MD, needle)  -> stripmd
                         +-- docsearch(haystack, needle)  [フォールバック]
                                |
                                +-- @warn "Unable to search documentation..."  [docview.jl:943]
                                +-- return false
```

### データフロー図

```
[入力]                        [処理]                              [出力]

検索キーワード(needle) +    docsearch メソッドディスパッチ
ドキュメントオブジェクト          |
(haystack) ----------------->   +-> 既知の型 -> 検索実行 -------> true/false
                                |
                                +-> 未知の型 -> @warn ----------> stderr (型名表示)
                                                +-> false -------> 検索不一致
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docview.jl | `stdlib/REPL/src/docview.jl` | ソース | docsearch 関数群（932-968行目） |
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | docview.jl のインクルード（100行目） |
