# 通知設計書 59-マージレビュー通知

## 概要

本ドキュメントは、LibGit2のマージ操作が正常に完了した後に、変更のレビューとコミットを促す情報通知の設計を記述する。

### 本通知の処理概要

`LibGit2.merge!` 関数（通常マージ版）により、Gitリポジトリへのマージが正常に完了した後に、ユーザーにマージされた変更のレビューとコミットを促す情報メッセージを出力する処理である。

**業務上の目的・背景**：Gitの通常マージ（非Fast-Forward）では、マージ操作自体はワーキングツリーとインデックスを更新するが、コミットは自動的には作成されない。ユーザーはマージ結果を確認し、コンフリクトがあれば解決した上で、手動でコミットを作成する必要がある。この通知は、マージ後のワークフローの次のステップをユーザーに案内するために存在する。

**通知の送信タイミング**：`merge!(repo::GitRepo, anns::Vector{GitAnnotated})` 関数（キーワード引数版、`fastforward` パラメータなし）内で、`git_merge` のC API呼び出しが正常に完了した直後にトリガーされる。

**通知の受信者**：LibGit2を通じてGit操作を行っているユーザー（主にPkg.jlなどのパッケージマネージャ経由）。

**通知内容の概要**：「Review and commit merged changes」というメッセージが表示される。

**期待されるアクション**：ユーザーは、マージされた変更内容を確認し、コンフリクトがあれば解決し、マージコミットを作成する。

## 通知種別

ログ（Info） - Julia標準ロギングフレームワーク `@info` マクロによるコンソール出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（マージ操作完了直後に出力） |
| 優先度 | 中（Infoレベル、ワークフロー案内） |
| リトライ | 無し |

### 送信先決定ロジック

LibGit2を通じてマージ操作を行ったユーザー本人が受信者。`@info` マクロによりグローバルロガーの設定に従い出力される。

## 通知テンプレート

### メール通知の場合

該当なし（コンソールログ出力のみ）

### 本文テンプレート

```
Info: Review and commit merged changes
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| （なし） | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `merge!(repo, anns)` の正常完了 | `git_merge` C API呼び出しが成功（`@check` で検証） | merge.jl 147-161行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| マージ失敗 | `@check` マクロによりC API呼び出しが失敗した場合は例外がスローされ、通知に到達しない |
| Fast-Forwardマージ | `ffmerge!` 関数は別の関数であり、本通知は発行されない |
| merge_analysis の結果による分岐 | `merge!(repo, anns, fastforward)` 版から呼ばれた場合のみ本通知が出力される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[merge! 関数呼び出し] --> B[ensure_initialized]
    B --> C[git_merge C API 呼び出し]
    C --> D{@check 成功?}
    D -->|No| E[例外スロー]
    D -->|Yes| F[@info Review and commit merged changes]
    F --> G[return true]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Git内部データ構造を使用）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし（Gitリポジトリのワーキングツリーとインデックスが更新される）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| git_merge 失敗 | C API呼び出しが非ゼロステータスを返す | `@check` マクロにより例外がスローされ、通知には到達しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

本通知には固定メッセージのみが含まれ、リポジトリ情報やファイル情報は含まれない。

## 備考

- この `merge!` メソッドは2つのシグネチャがあり、本通知は `fastforward` パラメータなしのバージョン（merge.jl 147-161行目）でのみ発行される
- `fastforward` パラメータありのバージョン（merge.jl 199-254行目）は、通常マージが必要な場合にこのメソッドを内部的に呼び出す（228-230行目）
- `@check` マクロはlibgit2のエラーコードをJulia例外に変換する
- `GC.@preserve anns` でアノテーションオブジェクトがGCされないよう保護される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LibGit2のマージ関連データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | merge.jl | `stdlib/LibGit2/src/merge.jl` | 1-15行目: `GitAnnotated` の説明。マージ元のアノテーション付きコミット |
| 1-2 | merge.jl | `stdlib/LibGit2/src/merge.jl` | 57-97行目: `merge_analysis` 関数。マージ分析結果の型と意味 |

**読解のコツ**: `GitAnnotated` はコミットの参照にメタデータ（どのように参照されたか）を付加したオブジェクト。`merge_analysis` の返り値が後続のマージ方法の決定に使われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | merge.jl | `stdlib/LibGit2/src/merge.jl` | 147-161行目: `merge!(repo, anns)` 関数（キーワード引数版） |

**主要処理フロー**:
1. **150行目**: `ensure_initialized()` でlibgit2の初期化確認
2. **152-157行目**: `ccall(:git_merge, ...)` でC APIを呼び出し
3. **159行目**: `@info "Review and commit merged changes"` で通知
4. **160行目**: `return true` でマージ成功を返却

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge.jl | `stdlib/LibGit2/src/merge.jl` | 199-254行目: `merge!(repo, anns, fastforward)` 関数。マージ分析に基づく分岐処理 |

**主要処理フロー**:
- **202行目**: `merge_analysis` で分析実行
- **219-231行目**: Fast-Forward可能かつ preference が NONE の場合の分岐
- **227-230行目**: 通常マージの場合にキーワード引数版 `merge!` を呼び出し（本通知が発行される）

### プログラム呼び出し階層図

```
[外部呼び出し元（Pkg.jl等）]
    |
    +-- merge!(repo, anns, fastforward)  [merge.jl:199]
           |
           +-- merge_analysis(repo, anns)  [merge.jl:85]
           |
           +-- [MERGE_ANALYSIS_FASTFORWARD の場合]
           |       +-- ffmerge!(repo, anns[1])  [merge.jl:106]  ※通知なし
           |
           +-- [MERGE_ANALYSIS_NORMAL の場合]
                   +-- merge!(repo, anns; merge_opts, checkout_opts)  [merge.jl:147]
                          |
                          +-- ccall(:git_merge, ...)  [merge.jl:153]
                          +-- @info "Review and commit merged changes"  [merge.jl:159]
                          +-- return true
```

### データフロー図

```
[入力]                       [処理]                              [出力]

GitRepo +                  merge!(repo, anns)
GitAnnotated[] ----------->       |
                                  +-> ensure_initialized()
                                  +-> ccall(:git_merge, ...) --> Git内部データ更新
                                  +-> @info ----------------------> stderr (通知)
                                  +-> return true ----------------> 呼び出し元
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| merge.jl | `stdlib/LibGit2/src/merge.jl` | ソース | merge! 関数群と merge_analysis（全体） |
