# 通知設計書 61-Fast-Forwardマージ不可警告

## 概要

本ドキュメントは、Julia の LibGit2 モジュールにおいて Fast-Forward マージが実行できない場合に出力される警告通知の設計を記述する。

### 本通知の処理概要

Fast-Forward マージのみが許可されている状態でマージ分析の結果が Fast-Forward 不可と判定された場合に、ユーザーに対して警告メッセージをログ出力する通知である。

**業務上の目的・背景**：Git リポジトリのマージ操作において、Fast-Forward マージが要求されたにもかかわらず、ブランチの分岐状態により Fast-Forward が不可能な場合がある。この警告により、ユーザーはマージが失敗した原因を即座に理解し、適切な対処（通常マージへの切り替えやリベースの実行など）を行うことができる。Fast-Forward 限定マージは履歴の線形性を保つために使用されるため、この制約違反を明確に通知することは重要である。

**通知の送信タイミング**：`merge!` 関数の内部処理において、`merge_analysis` の結果が `MERGE_ANALYSIS_FASTFORWARD` ではなく、かつ `ffpref` が `MERGE_PREFERENCE_FASTFORWARD_ONLY` の場合にこの警告が発生する。つまり、Fast-Forward のみを許可するマージポリシーが設定されているが、実際のブランチ状態が Fast-Forward マージに適さない場合である。

**通知の受信者**：`merge!` 関数を呼び出した Julia プログラムの開発者またはエンドユーザー。Julia のロギングフレームワークを通じて、設定されたロガーに配信される。

**通知内容の概要**：`"Cannot perform fast-forward merge"` という固定メッセージが `@warn` マクロで出力される。追加のコンテキスト情報（ブランチ名やリポジトリパスなど）は含まれない。

**期待されるアクション**：ユーザーは `fastforward=false` を指定して通常のマージを試行するか、事前にリベースを行って Fast-Forward 可能な状態にすることが期待される。

## 通知種別

ログ（Warn） - Julia 標準ロギングフレームワーク `@warn` マクロによるログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（関数呼び出し中に即座にログ出力） |
| 優先度 | 中（Warn レベル） |
| リトライ | 無 |

### 送信先決定ロジック

Julia の標準ロギングフレームワークにより、現在アクティブなロガーにメッセージが配信される。デフォルトでは `stderr` に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Warning: Cannot perform fast-forward merge
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| （なし） | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `merge!(repo, anns, true)` 呼び出し | `ffpref == MERGE_PREFERENCE_FASTFORWARD_ONLY` かつ `ma` に `MERGE_ANALYSIS_FASTFORWARD` フラグが立っていない場合 | Fast-Forward 限定マージを要求したが、分岐状態により Fast-Forward 不可の場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `fastforward=false` で呼び出された場合 | Fast-Forward 限定でないマージの場合はこの警告は発生しない |
| マージ分析が UP_TO_DATE の場合 | 既に最新であればマージ不要のため関数は早期リターンする |
| マージ分析が FASTFORWARD の場合 | Fast-Forward 可能ならば正常にマージが実行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[merge! 呼び出し] --> B[merge_analysis 実行]
    B --> C{UP_TO_DATE?}
    C -->|Yes| D[return true]
    C -->|No| E{ffpref 決定}
    E --> F{FASTFORWARD_ONLY?}
    F -->|Yes| G{MERGE_ANALYSIS_FASTFORWARD?}
    G -->|Yes| H[ffmerge! 実行]
    G -->|No| I["@warn Cannot perform fast-forward merge"]
    I --> J[return false]
    F -->|No| K[通常マージ処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Git リポジトリのオブジェクトデータベースのみを参照）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| マージ不可 | Fast-Forward マージが不可能な場合 | `@warn` を出力し `false` を返す |
| 不明なマージ分析結果 | `merge_analysis` が想定外の値を返した場合 | `ArgumentError` がスローされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（関数呼び出し時に即座に出力）

## セキュリティ考慮事項

本通知には機密情報は含まれない。リポジトリのパスやブランチ名も通知メッセージには含まれないため、情報漏洩のリスクは低い。

## 備考

- 同じ `merge.jl` ファイル内には、複数のマージヘッドで Fast-Forward マージが実行できない場合の別の警告（No.60）も存在する。本通知は単一のマージヘッドで Fast-Forward が不可能な場合に特化している。
- この通知が出力された場合、`merge!` 関数は `false` を返す。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

マージ操作で使用されるデータ構造（GitAnnotated、MergeOptions など）を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.jl | `stdlib/LibGit2/src/types.jl` | MergeOptions 構造体（行620-635）の定義。マージの動作を制御するオプション |
| 1-2 | consts.jl | `stdlib/LibGit2/src/consts.jl` | MERGE_ANALYSIS_* と MERGE_PREFERENCE_* の定数定義 |

**読解のコツ**: `@kwdef` マクロにより構造体のフィールドにデフォルト値が設定されている。`@static if` によりライブラリバージョンに応じたフィールドの有無が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LibGit2.jl | `stdlib/LibGit2/src/LibGit2.jl` | `merge!` の公開 API（行783-858）。ユーザーが直接呼び出す関数 |

**主要処理フロー**:
1. **行790-850**: コミッティッシュやブランチの指定に応じて `GitAnnotated` オブジェクトの配列を構築
2. **行851-857**: 内部の `merge!(repo, upst_anns, fastforward, ...)` を呼び出す

#### Step 3: マージ分析と実行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | merge.jl | `stdlib/LibGit2/src/merge.jl` | `merge_analysis` 関数（行85-97）。マージ可能性を分析する |
| 3-2 | merge.jl | `stdlib/LibGit2/src/merge.jl` | `merge!(repo, anns, fastforward)` 関数（行199-254）。**本通知の発生箇所（行241）** |

**主要処理フロー**:
- **行202**: `merge_analysis` でマージ分析を実行
- **行203-205**: UP_TO_DATE チェック
- **行207-217**: `ffpref` の決定
- **行232-243**: `MERGE_PREFERENCE_FASTFORWARD_ONLY` の処理ブロック
- **行241**: `@warn "Cannot perform fast-forward merge"` - 本通知の出力箇所

### プログラム呼び出し階層図

```
LibGit2.merge!(repo; fastforward=true, ...)   [LibGit2.jl:783]
    |
    +-- GitAnnotated の構築                      [LibGit2.jl:790-850]
    |
    +-- merge!(repo, upst_anns, fastforward)    [merge.jl:199]
            |
            +-- merge_analysis(repo, anns)       [merge.jl:85]
            |       |
            |       +-- git_merge_analysis (C)   [libgit2]
            |
            +-- (ffpref == FASTFORWARD_ONLY && !FASTFORWARD)
                    |
                    +-- @warn "Cannot perform fast-forward merge"  [merge.jl:241]
                    +-- return false
```

### データフロー図

```
[入力]                        [処理]                           [出力]

GitRepo            ------>  merge_analysis()          ------>  analysis, preference
GitAnnotated[]                                                 (Cint, Cint)
                              |
fastforward=true   ------>  ffpref 決定               ------>  FASTFORWARD_ONLY
                              |
analysis           ------>  FASTFORWARD フラグチェック  ------>  @warn (stderr)
                                                               return false
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| merge.jl | `stdlib/LibGit2/src/merge.jl` | ソース | マージ操作の実装。本通知の発生元（行241） |
| LibGit2.jl | `stdlib/LibGit2/src/LibGit2.jl` | ソース | モジュール定義と公開 API の `merge!` 関数 |
| types.jl | `stdlib/LibGit2/src/types.jl` | ソース | MergeOptions 等の構造体定義 |
| consts.jl | `stdlib/LibGit2/src/consts.jl` | ソース | マージ関連の定数定義 |
