# 通知設計書 65-トランスポート検証拒否エラー

## 概要

本ドキュメントは、Julia の LibGit2 モジュールにおいて証明書コールバック内で予期しないトランスポート種別が検出された場合に出力されるエラー通知の設計を記述する。

### 本通知の処理概要

`certificate_callback` 関数内で、証明書のタイプが TLS でも SSH でもない未知のトランスポートが検出された場合に、検証を拒否してエラーログを出力する通知である。

**業務上の目的・背景**：LibGit2 の証明書コールバックは TLS と SSH の2種類のトランスポートに対応している。これ以外のトランスポートタイプが出現した場合、libgit2 ライブラリのバージョン不整合や内部エラーの可能性がある。セキュリティ上の観点から、未知のトランスポートの検証は拒否し、その旨をエラーログで通知する。これにより、開発者は潜在的なセキュリティリスクを認識できる。

**通知の送信タイミング**：`certificate_callback` 関数の末尾で、トランスポート種別が `"TLS"` でも `"SSH"` でもない場合（`transport` が `nothing` の場合を含む）に発生する。

**通知の受信者**：LibGit2 経由でリモートリポジトリに接続する Julia プログラムの開発者。Julia のロギングフレームワークを通じて配信される。

**通知内容の概要**：`"unexpected transport encountered, refusing to validate"` というメッセージとともに、`cert_type` の値がキーワード引数として出力される。

**期待されるアクション**：開発者は libgit2 および関連ライブラリのバージョンを確認し、未知のトランスポートタイプの原因を調査することが期待される。

## 通知種別

ログ（Error） - Julia 標準ロギングフレームワーク `@error` マクロによるログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック関数内で即座にログ出力） |
| 優先度 | 高（Error レベル） |
| リトライ | 無 |

### 送信先決定ロジック

Julia の標準ロギングフレームワークにより、現在アクティブなロガーにメッセージが配信される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Error: unexpected transport encountered, refusing to validate
  cert_type = <cert_type_value>
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cert_type | 証明書タイプの値（Cint） | `unsafe_load(convert(Ptr{Cint}, cert_p))` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コールバック | `certificate_callback` の実行 | `cert_type` が `CERT_TYPE_TLS` でも `CERT_TYPE_SSH` でもない場合 | 未知のトランスポート種別 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `valid != 0` | 既に検証済みの場合は早期リターン |
| `!NetworkOptions.verify_host(host, transport)` | ユーザーがホスト検証を無効化している場合 |
| `cert_type == CERT_TYPE_TLS` | TLS 処理パスが使用される |
| `cert_type == CERT_TYPE_SSH` | SSH 処理パスが使用される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[certificate_callback 呼び出し] --> B{valid != 0?}
    B -->|Yes| C[CERT_ACCEPT]
    B -->|No| D[cert_type 判定]
    D --> E{TLS?}
    E -->|Yes| F[TLS 検証処理]
    E -->|No| G{SSH?}
    G -->|Yes| H[SSH 検証処理]
    G -->|No| I["@error unexpected transport encountered"]
    I --> J[CERT_REJECT 返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 未知のトランスポート | `cert_type` が TLS でも SSH でもない場合 | `@error` を出力し `CERT_REJECT` を返す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- `cert_type` の値のみが出力され、証明書の内容やホスト情報は含まれない。
- 未知のトランスポートに対して `CERT_REJECT` を返すことで、安全側に倒す設計となっている。

## 備考

- `certificate_callback` は `@cfunction` マクロにより C 関数ポインタとして登録される（callbacks.jl 行518）。
- `cert_type` の判定は `CERT_TYPE_TLS` と `CERT_TYPE_SSH` の2値で行われ、それ以外は全てこのエラーパスに入る。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `CertHostKey` 構造体（行366-375） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `certificate_callback` 関数（行381-425）。**本通知の発生箇所（行423）** |

**主要処理フロー**:
1. **行387**: `valid` チェック
2. **行389**: `cert_type` の取得
3. **行390-391**: トランスポート種別の判定（TLS or SSH or nothing）
4. **行396-421**: TLS/SSH の各検証処理
5. **行423**: `@error("unexpected transport encountered, refusing to validate", cert_type)` - **本通知**
6. **行424**: `CERT_REJECT` 返却

### プログラム呼び出し階層図

```
certificate_callback(cert_p, valid, host_p, data_p)   [callbacks.jl:381]
    |
    +-- cert_type 判定                                  [callbacks.jl:389-391]
    |       |
    |       +-- CERT_TYPE_TLS -> "TLS"
    |       +-- CERT_TYPE_SSH -> "SSH"
    |       +-- その他 -> nothing
    |
    +-- (transport == nothing)
            |
            +-- @error "unexpected transport encountered" [callbacks.jl:423]
            +-- return CERT_REJECT                        [callbacks.jl:424]
```

### データフロー図

```
[入力]                        [処理]                              [出力]

cert_p (Ptr)         ------>  unsafe_load -> cert_type
host_p (Ptr{Cchar})  ------>  unsafe_string -> host
valid (Cint)         ------>  valid チェック
                                |
                                +-- cert_type 判定
                                        |
                                        +-- (未知) @error  ------>  エラーログ (stderr)
                                                                    CERT_REJECT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | ソース | `certificate_callback`。本通知の発生元（行423） |
| consts.jl | `stdlib/LibGit2/src/consts.jl` | ソース | CERT_TYPE_TLS/SSH、CERT_ACCEPT/REJECT 定数 |
| types.jl | `stdlib/LibGit2/src/types.jl` | ソース | RemoteCallbacks 構造体 |
