# 通知設計書 66-SSH既知ホストファイル解析エラー警告

## 概要

本ドキュメントは、Julia の LibGit2 モジュールにおいて SSH 既知ホストファイルの解析（readfile）中にエラーが発生した場合に出力される警告通知の設計を記述する。

### 本通知の処理概要

`ssh_knownhost_check` 関数内で、`libssh2_knownhost_readfile` が既知ホストファイルの読み取り中に負の値（エラー）を返した場合に、該当ファイルのパスとともに警告を出力する通知である。

**業務上の目的・背景**：SSH 接続のホスト検証において、既知ホストファイル（通常 `~/.ssh/known_hosts`）の読み取りは不可欠な処理である。ファイルのフォーマットが不正であったり、ファイルが破損している場合、`libssh2_knownhost_readfile` はエラーを返す。この警告により、開発者はファイルの問題を認識し、修正することができる。なお、このファイルの読み取りに失敗しても、他の既知ホストファイルの検査は継続される。

**通知の送信タイミング**：`ssh_knownhost_check` 関数内で、`libssh2_knownhost_readfile` の戻り値が負（`count < 0`）の場合に発生する。

**通知の受信者**：LibGit2 経由で SSH 接続を使用する Julia プログラムの開発者。Julia のロギングフレームワークを通じて配信される。

**通知内容の概要**：`"Error parsing SSH known hosts file \`$file\`"` というメッセージで、問題のあるファイルパスが含まれる。

**期待されるアクション**：開発者は該当する SSH 既知ホストファイルの内容を確認し、不正な行を修正するか、ファイルを再生成することが期待される。

## 通知種別

ログ（Warn） - Julia 標準ロギングフレームワーク `@warn` マクロによるログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（関数実行中に即座にログ出力） |
| 優先度 | 中（Warn レベル） |
| リトライ | 無 |

### 送信先決定ロジック

Julia の標準ロギングフレームワークにより、現在アクティブなロガーにメッセージが配信される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Warning: Error parsing SSH known hosts file `/path/to/known_hosts`
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file | 問題のある既知ホストファイルのパス | `NetworkOptions.ssh_known_hosts_files()` から取得したファイルリスト | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | `ssh_knownhost_check` 内の `libssh2_knownhost_readfile` 呼び出し | `count < 0`（戻り値が負） | 既知ホストファイルの解析エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `count >= 0` | ファイルの読み取りが成功した場合 |
| `!ispath(file)` | ファイルが存在しない場合はスキップされ、readfile は呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ssh_knownhost_check 呼び出し] --> B[各ファイルをループ]
    B --> C{ispath file?}
    C -->|No| D[次のファイルへ]
    C -->|Yes| E[libssh2_knownhost_init]
    E --> F[libssh2_knownhost_readfile]
    F --> G{count < 0?}
    G -->|Yes| H["@warn Error parsing SSH known hosts file"]
    H --> I[knownhost_free]
    I --> D
    G -->|No| J[libssh2_knownhost_checkp]
    J --> K{結果判定}
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| SSH 既知ホストファイル | ホスト鍵の読み取り | OpenSSH 形式のファイル |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル解析エラー | `libssh2_knownhost_readfile` が負の値を返した場合 | `@warn` を出力し、リソースを解放して次のファイルへ進む |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（ファイル単位でスキップし次のファイルへ進む） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

既知ホストファイルのパスがログに出力されるが、ファイルの内容は含まれない。

## 備考

- 複数の既知ホストファイルが設定されている場合、解析に失敗したファイルはスキップされ、残りのファイルの検査が継続される。
- `libssh2_knownhost_readfile` の第3引数 `1` は標準 OpenSSH 形式を示す。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `KnownHost` 構造体（行427-433）。libssh2 の既知ホストエントリ |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `ssh_knownhost_check` 関数（行444-504）。**本通知の発生箇所（行475）** |

**主要処理フロー**:
1. **行449-454**: ホスト・ポートの解析
2. **行458-463**: libssh2 セッション初期化
3. **行464**: 各既知ホストファイルをループ
4. **行465**: `ispath(file)` チェック
5. **行466-468**: `libssh2_knownhost_init`
6. **行469-473**: `libssh2_knownhost_readfile` 実行
7. **行474-478**: `count < 0` の場合 - **行475 で `@warn` 出力**、リソース解放して `continue`
8. **行479-499**: 正常時の `libssh2_knownhost_checkp` 実行

### プログラム呼び出し階層図

```
certificate_callback(...)                           [callbacks.jl:381]
    |
    +-- ssh_knownhost_check(files, host, cert)      [callbacks.jl:435]
            |
            +-- for file in files                   [callbacks.jl:464]
                    |
                    +-- libssh2_knownhost_init       [libssh2]
                    +-- libssh2_knownhost_readfile   [libssh2]
                    |       |
                    |       +-- (count < 0)
                    |               |
                    |               +-- @warn "Error parsing SSH known hosts file" [行475]
                    |               +-- knownhost_free
                    |               +-- continue
                    |
                    +-- libssh2_knownhost_checkp     [libssh2]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

SSH known hosts files  ------>  libssh2_knownhost_readfile  ------>  count (Cint)
                                        |
                                        +-- count < 0       ------>  @warn (stderr)
                                        |                            continue
                                        +-- count >= 0      ------>  checkp 処理へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | ソース | `ssh_knownhost_check` 関数。本通知の発生元（行475） |
| consts.jl | `stdlib/LibGit2/src/consts.jl` | ソース | LIBSSH2_KNOWNHOST_* 定数 |
