# 通知設計書 67-SSH既知ホストファイル検索エラー警告

## 概要

本ドキュメントは、Julia の LibGit2 モジュールにおいて SSH 既知ホストファイルの検索（checkp）中にエラーが発生した場合に出力される警告通知の設計を記述する。

### 本通知の処理概要

`ssh_knownhost_check` 関数内で、`libssh2_knownhost_checkp` が `LIBSSH2_KNOWNHOST_CHECK_FAILURE` を返した場合に、該当ファイルのパスとともに警告を出力する通知である。

**業務上の目的・背景**：SSH 既知ホストの検証処理において、ファイルの読み取りは成功したものの、ホスト鍵の検索処理自体でエラーが発生する場合がある。これは、既知ホストファイル内のエントリが破損しているか、libssh2 の内部エラーが発生した場合に起こりうる。この警告により、開発者は検索処理の問題を認識し、既知ホストファイルの状態を確認することができる。エラーが発生したファイルはスキップされ、次のファイルの検査が継続される。

**通知の送信タイミング**：`ssh_knownhost_check` 関数内で、`libssh2_knownhost_checkp` の戻り値が `LIBSSH2_KNOWNHOST_CHECK_FAILURE` の場合に発生する。

**通知の受信者**：LibGit2 経由で SSH 接続を使用する Julia プログラムの開発者。Julia のロギングフレームワークを通じて配信される。

**通知内容の概要**：`"Error searching SSH known hosts file \`$file\`"` というメッセージで、問題のあるファイルパスが含まれる。

**期待されるアクション**：開発者は該当する SSH 既知ホストファイルの内容を確認し、破損したエントリの修正やファイルの再生成を行うことが期待される。

## 通知種別

ログ（Warn） - Julia 標準ロギングフレームワーク `@warn` マクロによるログ出力

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（関数実行中に即座にログ出力） |
| 優先度 | 中（Warn レベル） |
| リトライ | 無 |

### 送信先決定ロジック

Julia の標準ロギングフレームワークにより、現在アクティブなロガーにメッセージが配信される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Warning: Error searching SSH known hosts file `/path/to/known_hosts`
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file | 問題のある既知ホストファイルのパス | `NetworkOptions.ssh_known_hosts_files()` から取得したファイルリスト | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | `ssh_knownhost_check` 内の `libssh2_knownhost_checkp` 呼び出し | `check == LIBSSH2_KNOWNHOST_CHECK_FAILURE` | 既知ホストファイルの検索エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `check == MATCH` | ホスト鍵が一致した場合（即座にリターン） |
| `check == MISMATCH` | ホスト鍵が不一致の場合（即座にリターン） |
| `check == NOTFOUND` | ホストが見つからない場合（次のファイルへ、警告なし） |
| ファイルが存在しない場合 | `ispath(file)` が false なら readfile/checkp は呼ばれない |
| readfile が失敗した場合 | No.66 の警告が出力され、checkp は呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ssh_knownhost_check 内ファイルループ] --> B[libssh2_knownhost_readfile 成功]
    B --> C[libssh2_knownhost_checkp 実行]
    C --> D{check の値?}
    D -->|MATCH| E[knownhost_free, return MATCH]
    D -->|MISMATCH| F[knownhost_free, return MISMATCH]
    D -->|FAILURE| G["@warn Error searching SSH known hosts file"]
    D -->|NOTFOUND| H[knownhost_free, continue]
    G --> I[knownhost_free]
    I --> J[continue - 次のファイルへ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| SSH 既知ホストファイル | ホスト鍵の検索 | OpenSSH 形式のファイル |

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ホスト鍵検索エラー | `libssh2_knownhost_checkp` が `FAILURE` を返した場合 | `@warn` を出力し、リソースを解放して次のファイルへ進む |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（ファイル単位でスキップし次のファイルへ） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

既知ホストファイルのパスがログに出力されるが、ホスト鍵やファイルの内容は含まれない。

## 備考

- No.66（SSH既知ホストファイル解析エラー警告）との違い: No.66 は `readfile`（ファイル読み取り）のエラー、No.67 は `checkp`（ホスト鍵検索）のエラーである。
- `FAILURE` の場合のみ警告が出力される。`NOTFOUND` の場合は次のファイルへ進むが警告は出力されない。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `KnownHost` 構造体（行427-433） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | `ssh_knownhost_check` 関数（行444-504）。**本通知の発生箇所（行496）** |

**主要処理フロー**:
1. **行464-465**: ファイルループと `ispath` チェック
2. **行466-468**: `libssh2_knownhost_init`
3. **行469-478**: `libssh2_knownhost_readfile` とエラーチェック（No.66）
4. **行479-487**: `libssh2_knownhost_checkp` 呼び出し
5. **行488-492**: MATCH/MISMATCH の場合は即座にリターン
6. **行493-499**: その他のケース - **行495-496 で FAILURE チェックと `@warn` 出力**

### プログラム呼び出し階層図

```
certificate_callback(...)                           [callbacks.jl:381]
    |
    +-- ssh_knownhost_check(files, host, cert)      [callbacks.jl:435]
            |
            +-- for file in files                   [callbacks.jl:464]
                    |
                    +-- libssh2_knownhost_readfile   [libssh2] (成功)
                    |
                    +-- libssh2_knownhost_checkp     [libssh2]
                            |
                            +-- (check == FAILURE)
                                    |
                                    +-- @warn "Error searching SSH known hosts file" [行496]
                                    +-- knownhost_free
                                    +-- continue
```

### データフロー図

```
[入力]                          [処理]                              [出力]

host (String)          ------>  libssh2_knownhost_checkp    ------>  check (Cint)
key (Vector{Cchar})                    |
known hosts entries                    +-- check == FAILURE  ------>  @warn (stderr)
                                       |                             continue
                                       +-- check == MATCH   ------>  return MATCH
                                       +-- check == MISMATCH ----->  return MISMATCH
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.jl | `stdlib/LibGit2/src/callbacks.jl` | ソース | `ssh_knownhost_check` 関数。本通知の発生元（行496） |
| consts.jl | `stdlib/LibGit2/src/consts.jl` | ソース | LIBSSH2_KNOWNHOST_CHECK_* 定数 |
