# 通知設計書 7-プロジェクト読込失敗警告

## 概要

本ドキュメントは、Juliaランタイムにおけるプロジェクト読込失敗警告通知の設計を記述する。アクティブプロジェクトのProject.tomlファイルの読み込みに失敗した場合に警告ログを出力し、最新の構文バージョンにフォールバックする。

### 本通知の処理概要

**業務上の目的・背景**：Juliaはプロジェクトファイル（Project.toml）から構文バージョン情報を読み取り、パーサーの動作を制御する。プロジェクトファイルが破損している、パーミッションがない、またはTOMLパースエラーが発生した場合、構文バージョンの取得に失敗する。本通知はこの失敗を開発者に警告し、最新の構文バージョンがデフォルトとして使用されることを伝える。

**通知の送信タイミング**：`parser_for_active_project`関数内で、`project_get_syntax_version(parsed_toml(project))`が例外をスローした場合に通知される。

**通知の受信者**：Juliaプログラムを実行している開発者。ログメッセージとして標準エラー出力（または設定されたログハンドラ）に出力される。

**通知内容の概要**：「Failed to read project $project - defaulting to latest syntax. err=$e」というメッセージが`@warn`マクロにより出力される。対象のプロジェクトファイルパスと発生した例外が含まれる。

**期待されるアクション**：開発者はProject.tomlファイルの内容を確認し、構文エラーやファイルの破損を修正する。

## 通知種別

ログ出力（Warnレベル） - Juliaの`@warn`マクロによるロギングシステム経由の警告通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`parser_for_active_project`関数内で即座に出力） |
| 優先度 | 中（パーサー動作に影響するが、フォールバックにより動作は継続する） |
| リトライ | 無し |

### 送信先決定ロジック

Juliaのロギングフレームワーク（`CoreLogging`）に委譲される。デフォルトでは`stderr`に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
┌ Warning: Failed to read project /path/to/Project.toml - defaulting to latest syntax. err=ErrorException("...")
└ @ Base loading.jl:1005
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| project | プロジェクトファイルのパス | `active_project()`の返り値 | Yes |
| e | 発生した例外オブジェクト | `catch`ブロックで捕捉 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `parser_for_active_project()`の実行 | `project_get_syntax_version`または`parsed_toml`が例外をスロー | TOMLパースエラー、ファイル読み込みエラー等 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトファイルの読み込み成功 | 正常に構文バージョンが取得された場合 |
| `project`がnothing | アクティブプロジェクトが設定されていない場合（try文に入らない） |
| `!isfile(project)` | プロジェクトファイルが存在しない場合（条件分岐で回避される） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[parser_for_active_project呼び出し] --> B["project = active_project()"]
    B --> C{projectがnothingでなく、ファイルが存在?}
    C -->|No| D["VERSIONをデフォルトとして使用"]
    C -->|Yes| E["project_get_syntax_version(parsed_toml(project))"]
    E --> F{例外発生?}
    F -->|No| G["取得した構文バージョンを使用"]
    F -->|Yes| H["@warn Failed to read project..."]
    H --> D
    D --> I["VersionedParse(sv)返却"]
    G --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルシステムからProject.tomlを参照する）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| TOMLパースエラー | Project.tomlの構文が不正 | 警告出力後、VERSIONをデフォルトの構文バージョンとして使用 |
| ファイル読み込みエラー | パーミッション不足等 | 警告出力後、VERSIONをデフォルトの構文バージョンとして使用 |
| キー不在 | syntax_versionキーが存在しない | 警告出力後、VERSIONをデフォルトの構文バージョンとして使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（呼び出しごとに出力） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

警告メッセージにプロジェクトファイルのフルパスが含まれる。ユーザーのディレクトリ構造が露出するが、ローカルログへの出力であり重大なリスクはない。

## 備考

- `parser_for_active_project`はコード解析時にパーサーの構文バージョンを決定するために使用される
- フォールバック先は`VERSION`（現在のJuliaバージョン）であり、最新の構文が適用される
- `VersionedParse`構造体でパーサーの構文バージョンを管理する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パーサーの構文バージョン管理に関連する構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | loading.jl | `base/loading.jl` | `VersionedParse`構造体と構文バージョン管理の仕組み |

**読解のコツ**: Juliaは複数の構文バージョンをサポートしており、Project.tomlの`syntax`セクションでプロジェクトごとの構文バージョンを指定できる。

#### Step 2: エントリーポイントを理解する

通知が発生する`parser_for_active_project`関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loading.jl | `base/loading.jl` | `parser_for_active_project`関数（998-1009行目） |

**主要処理フロー**:
1. **999行目**: `active_project()`でアクティブプロジェクトのパスを取得
2. **1000行目**: `sv = VERSION`をデフォルト値として設定
3. **1001行目**: プロジェクトが存在する場合にtryブロックに入る
4. **1003行目**: `parsed_toml(project)`でTOMLをパースし、`project_get_syntax_version`で構文バージョンを取得
5. **1004-1005行目**: 例外時に`@warn`を出力
6. **1008行目**: `VersionedParse(sv)`を返す

#### Step 3: 関連する関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | initdefs.jl | `base/initdefs.jl` | `active_project`関数（345-367行目） - アクティブプロジェクトのパスを返す |

### プログラム呼び出し階層図

```
Juliaパーサー / コード読み込み
    |
    +-- parser_for_active_project()  [base/loading.jl:998]
        |
        +-- active_project()  [base/initdefs.jl:345]
        |
        +-- parsed_toml(project)
        |   +-- (TOML解析)
        |
        +-- project_get_syntax_version(...)
        |
        +-- (例外時) @warn "Failed to read project..."  [base/loading.jl:1005]
        |
        +-- VersionedParse(sv)
```

### データフロー図

```
[入力]                     [処理]                         [出力]

Project.tomlファイル ──> parsed_toml                    ──> VersionedParse(sv)
active_project()          |
                          +-- project_get_syntax_version
                          |
                          +-- (失敗時) @warn ──────> stderr
                          +-- VERSION (フォールバック)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loading.jl | `base/loading.jl` | ソース | パーサー構文バージョン決定とプロジェクト読み込みロジック |
| initdefs.jl | `base/initdefs.jl` | ソース | active_project関数の定義 |
