# 通知設計書 73-download関数非推奨警告

## 概要

本ドキュメントは、`Base.download`関数の使用が非推奨であり、`Downloads.download`への移行を促す警告通知の設計を定義する。

### 本通知の処理概要

`Base.download(url, path)`が呼び出された際に、`Downloads.download`パッケージの使用を推奨する非推奨警告を出力する通知機能である。

**業務上の目的・背景**：Julia 1.6以降、ダウンロード機能は標準ライブラリパッケージ`Downloads`に移管された。`Base.download`は薄いラッパーとして残されているが、新しいコードでは`Downloads.download`を直接使用すべきである。本警告は、旧APIに依存するコードの発見と移行を促進するために設けられている。移管の目的は、HTTP/ダウンロード関連の機能をより柔軟に進化させるため、コアランタイムから分離することにある。

**通知の送信タイミング**：`Base.download(url)`または`Base.download(url, path)`が呼び出された時点で、内部の`do_download`関数経由で`depwarn()`が発火する。

**通知の受信者**：`Base.download`を使用しているJuliaコードの開発者。

**通知内容の概要**：「Base.download is deprecated; use Downloads.download instead」というメッセージが表示される。

**期待されるアクション**：開発者は`using Downloads`を追加し、`Base.download`の呼び出しを`Downloads.download`に置き換えること。

## 通知種別

ログ出力（`depwarn`経由、CoreLogging.Warn レベル / `_group=:depwarn`）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（関数呼び出し時に即座に評価） |
| 優先度 | 中（`--depwarn`フラグに応じて動的に変更） |
| リトライ | なし |

### 送信先決定ロジック

`depwarn()`関数を通じてJuliaの標準ログシステムに出力される。`--depwarn`オプションの設定に従う。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Base.download is deprecated; use Downloads.download instead
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | - |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| msg | 固定メッセージ「Base.download is deprecated; use Downloads.download instead」 | ハードコード（download.jl:23） | Yes |
| funcsym | `:download` | ハードコード（download.jl:23） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `Base.download(url::AbstractString, path::AbstractString)` | `--depwarn=yes` | download.jl:19 |
| API呼び出し | `Base.download(url::AbstractString)` | `--depwarn=yes` | download.jl:20 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `--depwarn=no`（デフォルト） | depwarnのデフォルト動作により抑制 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Base.download呼び出し] --> B[do_download関数]
    B --> C[depwarn発火]
    C --> D[Downloads.download呼び出し]
    D --> E{ダウンロード結果}
    E -->|成功| F[ファイルパスを返却]
    E -->|失敗| G[例外送出]
    F --> H[終了]
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | ログ出力のみのためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ログ出力のみのためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ErrorException | `--depwarn=error`設定時にBase.downloadを使用 | depwarnがエラーとして送出される |
| ダウンロードエラー | URL不正やネットワーク障害 | Downloads.download側の例外がそのまま伝搬 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（depwarnとしてのリトライは行わない） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（depwarnのmaxlog=1により自然に制限） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（関数呼び出し時に即座に通知）

## セキュリティ考慮事項

- 通知メッセージにはURLやファイルパスの情報は含まれない（固定メッセージのみ）
- ダウンロード先のURLやパスはログに出力されないため、セキュリティリスクは低い

## 備考

- `Base.download`は内部で`Downloads`パッケージを遅延ロード（`require`）し、`invokelatest`で`Downloads().download`を呼び出す
- `Downloads`パッケージはJulia 1.6で標準ライブラリに追加された
- `path`引数が`nothing`の場合は一時ファイルにダウンロードされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

`Base.download`は単純なラッパー関数であり、複雑なデータ構造は使用していない。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | download.jl | `base/download.jl` | ファイル全体（26行）が対象。`Downloads`パッケージの遅延ロードの仕組み |

**読解のコツ**: `Downloads()`関数（3行目）が`require`でパッケージを遅延ロードしている点に注目。`invokelatest`でワールドエイジの問題を回避している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | download.jl | `base/download.jl` | `download(url, path)`（19行目）と`download(url)`（20行目）の2つのエントリーポイント |

**主要処理フロー**:
1. **19-20行目**: `download`の2つのメソッドが`do_download`を呼び出す
2. **22-25行目**: `do_download`内で`depwarn()`発火後、`invokelatest(Downloads().download, url, path)`を実行

#### Step 3: depwarnメカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | deprecated.jl | `base/deprecated.jl` | `depwarn()`関数（252行目）：非推奨警告の出力メカニズム |

### プログラム呼び出し階層図

```
download(url, path) (download.jl:19)
    |
    +-- do_download(url, path) (download.jl:22)
           |
           +-- depwarn("Base.download is deprecated; ...", :download) (download.jl:23)
           |      +-- _depwarn() (deprecated.jl:259)
           |
           +-- Downloads() (download.jl:3)
           |      +-- require(PkgId(..., "Downloads")) -- 遅延ロード
           |
           +-- invokelatest(Downloads().download, url, path) (download.jl:24)
```

### データフロー図

```
[入力]                      [処理]                          [出力]

url::AbstractString ──────> do_download() ──────────────> ファイルパス
path::AbstractString         |
                             +-- depwarn() ──> ログ出力
                             |
                             +-- Downloads().download(url, path)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| download.jl | `base/download.jl` | ソース | `Base.download`のラッパー定義、`depwarn`呼び出し |
| deprecated.jl | `base/deprecated.jl` | ソース | `depwarn()`関数の定義 |
| loading.jl | `base/loading.jl` | ソース | `require()`関数による`Downloads`パッケージの遅延ロード |
