# 通知設計書 77-プリコンパイル生成デバッグ

## 概要

本ドキュメントは、プリコンパイルキャッシュファイルまたはオブジェクトキャッシュファイルの生成開始時に出力されるデバッグ通知の設計を定義する。

### 本通知の処理概要

パッケージのプリコンパイル処理が開始される際に、キャッシュファイル（`.ji`）またはオブジェクトキャッシュファイル（ネイティブコード）の生成開始をデバッグレベルで記録する通知機能である。

**業務上の目的・背景**：Juliaのプリコンパイルシステムは、パッケージの初回ロードや依存関係の変更時にキャッシュファイルを生成する。このプロセスは時間がかかる場合があり（数秒から数分）、開発者がどのタイプのキャッシュが生成されているかを把握するのは、パフォーマンスのチューニングや問題診断において重要である。オブジェクトキャッシュの生成は通常のキャッシュよりも時間がかかるため、どちらが生成されているかの情報は有用である。

**通知の送信タイミング**：`compilecache()`関数内で、プリコンパイル用の子Juliaプロセスを起動する直前に出力される。

**通知の受信者**：プリコンパイルの問題を診断するJulia開発者、パッケージメンテナ。

**通知内容の概要**：生成されるキャッシュの種類（オブジェクトキャッシュまたは通常キャッシュ）とパッケージ名が通知される。

**期待されるアクション**：通常は情報提供のみ。プリコンパイルに問題がある場合のデバッグ情報として活用。

## 通知種別

ログ出力（`@debug`レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（プリコンパイル開始時に即座に出力） |
| 優先度 | 低（デバッグレベル、通常は表示されない） |
| リトライ | なし |

### 送信先決定ロジック

`@debug`マクロを通じてJuliaの標準ログシステムに出力される。デフォルトでは表示されない。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
Generating object cache file for {pkg}
Generating cache file for {pkg}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | - |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pkg | パッケージのPkgId（`repr("text/plain", pkg)`で表示） | `compilecache()`の引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プリコンパイル | オブジェクトキャッシュファイル生成開始 | `output_o !== nothing` | loading.jl:3358 |
| プリコンパイル | 通常キャッシュファイル生成開始 | `output_o === nothing` | loading.jl:3362 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デバッグレベルが無効 | `@debug`はデフォルトで抑制されている |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[compilecache呼び出し] --> B{output_o !== nothing?}
    B -->|Yes| C["@debug Generating object cache file"]
    B -->|No| D["@debug Generating cache file"]
    C --> E[CacheFlags設定]
    D --> E
    E --> F[子Juliaプロセス起動]
    F --> G{プリコンパイル結果}
    G -->|成功| H[キャッシュファイル生成完了]
    G -->|失敗| I[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | ファイルシステムとプロセス環境のみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | ログ出力のみ（キャッシュファイル自体は子プロセスが生成） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プリコンパイル失敗 | 子プロセスがエラーで終了 | デバッグログとは別に`@warn "The call to compilecache failed"`が出力される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（デバッグログ自体にリトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- パッケージ名がログに含まれるが、機密情報ではない

## 備考

- `output_o`はオブジェクトキャッシュファイルの出力パスで、`nothing`の場合は通常の`.ji`キャッシュのみ生成
- オブジェクトキャッシュ生成時は`JULIA_CPU_TARGET`環境変数が参照され、`--output-o`オプションが追加される
- `CacheFlags`は最適化レベルなどのコンパイルオプションを制御する
- `PRECOMPILE_TRACE_COMPILE`が設定されている場合、`--trace-compile`オプションが追加される
- 子プロセスには`julia_cmd()`で生成されたJuliaコマンドが使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | loading.jl | `base/loading.jl` | `CacheFlags`構造体：プリコンパイルオプション |
| 1-2 | loading.jl | `base/loading.jl` | `PkgId`構造体：パッケージ識別子 |

**読解のコツ**: `output_o`がnullかどうかでオブジェクトキャッシュと通常キャッシュが区別される点を押さえること。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loading.jl | `base/loading.jl` | `compilecache()`関数（3345-3374行目付近）：プリコンパイルプロセスの構築 |

**主要処理フロー**:
1. **3352-3355行目**: `output_o === nothing`の場合、キャッシュフラグからopt_level=0に設定
2. **3356行目**: `translate_cache_flags()`でオプション変換
3. **3357-3358行目**: `output_o !== nothing`の場合、`@debug "Generating object cache file"`出力
4. **3362行目**: `output_o === nothing`の場合、`@debug "Generating cache file"`出力
5. **3365行目**: `--output-ji`オプション設定
6. **3371行目以降**: 子Juliaプロセスの起動

### プログラム呼び出し階層図

```
compilecache(pkg, ...) (loading.jl)
    |
    +-- CacheFlags設定
    +-- translate_cache_flags()
    |
    +-- output_o チェック
    |      +-- @debug "Generating object cache file" (loading.jl:3358)
    |      +-- @debug "Generating cache file" (loading.jl:3362)
    |
    +-- julia_cmd() -- 子プロセスコマンド生成
    +-- open(pipeline(...)) -- 子プロセス起動
```

### データフロー図

```
[入力]                          [処理]                          [出力]

pkg (PkgId) ──────────────> compilecache()
output_o (出力パス) ──────>      |
cacheflags (フラグ) ──────>      +-- @debug ログ出力 ──────> デバッグログ
                               |
                               +-- 子プロセス起動 ──────> .ji / .so ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loading.jl | `base/loading.jl` | ソース | `compilecache()`関数でのデバッグログ出力（3358, 3362行目） |
