# 通知設計書 9-キャッシュモジュール不在警告

## 概要

本ドキュメントは、Juliaランタイムにおけるキャッシュモジュール不在警告通知の設計を記述する。特定のビルドIDを持つべきモジュールがプリコンパイルキャッシュに見つからない場合に警告ログを出力する。

### 本通知の処理概要

**業務上の目的・背景**：Juliaのインクリメンタルプリコンパイルシステムでは、依存モジュールのビルドIDを追跡して整合性を保つ。あるモジュールが`_concrete_dependencies`に登録された特定のビルドIDで存在するはずなのに、キャッシュから見つからない場合、そのモジュールはプリコンパイルをサポートしていない可能性がある。本通知はこの状況を開発者に警告する。

**通知の送信タイミング**：`_require`関数（パッケージのrequire処理）内で、`_concrete_dependencies`に含まれるパッケージがプリコンパイルキャッシュから見つからなかった場合に通知される。

**通知の受信者**：Juliaプログラムを実行している開発者。ログメッセージとして標準エラー出力（または設定されたログハンドラ）に出力される。

**通知内容の概要**：「Module {name} with build ID {uuid} is missing from the cache. This may mean {pkg} does not support precompilation but is imported by a module that does.」というメッセージが`@warn`マクロにより出力される。

**期待されるアクション**：開発者は該当パッケージがプリコンパイルをサポートしているか確認する。`__precompile__(false)`を使用しているパッケージがプリコンパイル可能なモジュールから依存されている場合は、依存関係の見直しが必要である。

## 通知種別

ログ出力（Warnレベル） - Juliaの`@warn`マクロによるロギングシステム経由の警告通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（`_require`関数内で即座に出力） |
| 優先度 | 高（プリコンパイルの整合性に影響する） |
| リトライ | 無し |

### 送信先決定ロジック

Juliaのロギングフレームワーク（`CoreLogging`）に委譲される。デフォルトでは`stderr`に出力される。

## 通知テンプレート

### メール通知の場合

該当なし（ログ出力のみ）

### 本文テンプレート

```
┌ Warning: Module MyPackage with build ID 12345678-1234-1234-1234-123456789abc is missing from the cache.
│  This may mean MyPackage [uuid] does not support precompilation but is imported by a module that does.
└ @ Base loading.jl:2847
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pkg.name | モジュール名 | `_concrete_dependencies`のPkgIdの名前 | Yes |
| UUID(concrete_build_id) | ビルドID（UUID形式） | `_concrete_dependencies`のビルドID | Yes |
| pkg | パッケージの表示名 | `repr("text/plain", pkg)` | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | `_require`関数でのパッケージロード | `_concrete_dependencies`に含まれるパッケージがキャッシュから見つからない | プリコンパイルローダーで処理されなかったモジュールが_concrete_dependenciesに存在 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プリコンパイルキャッシュが正常にロードされた | 正常にキャッシュからロードされた場合は通知されない |
| _concrete_dependenciesにパッケージが含まれない | 依存関係に含まれない場合はチェック対象外 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A["_require(pkg)"] --> B[プリコンパイルキャッシュ検索]
    B --> C{キャッシュからロード成功?}
    C -->|Yes| D[返却]
    C -->|No| E["_concrete_dependenciesをチェック"]
    E --> F{pkgが_concrete_dependenciesに存在?}
    F -->|No| G[通常のファイルロードへ]
    F -->|Yes| H["@warn Module with build ID is missing"]
    H --> I{インクリメンタルプリコンパイル中?}
    I -->|Yes| J["throw(PrecompilableError())"]
    I -->|No| G
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリの`_concrete_dependencies`と`loaded_modules`を参照する）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PrecompilableError | インクリメンタルプリコンパイル中にキャッシュ不在 | 例外をスローしてプリコンパイルを中止 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | なし（該当パッケージごとに出力） |

### 配信時間帯

制限なし

## セキュリティ考慮事項

本通知にはセキュリティ上の懸念はない。パッケージ名とビルドIDのみが出力される。

## 備考

- `_concrete_dependencies`はプリコンパイル時に依存モジュールのビルドIDを記録するために使用される
- インクリメンタルプリコンパイル中（`JLOptions().incremental != 0`）はフェイルファストのため`PrecompilableError`がスローされる
- `use_compiled_modules == 3`の場合は、本チェックの前にエラーが発生する（2839-2840行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

プリコンパイルキャッシュとモジュール依存関係の管理構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | loading.jl | `base/loading.jl` | `_concrete_dependencies`の定義と役割 |
| 1-2 | loading.jl | `base/loading.jl` | `loaded_modules`辞書の構造 |

**読解のコツ**: `_concrete_dependencies`はプリコンパイル時に設定される依存パッケージとそのビルドIDのリストである。実行時に各依存が正しいビルドIDでロードされているか検証するために使用される。

#### Step 2: エントリーポイントを理解する

通知が発生する箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | loading.jl | `base/loading.jl` | `_require`関数内の_concrete_dependenciesチェック（2843-2854行目） |

**主要処理フロー**:
1. **2845行目**: `for (concrete_pkg, concrete_build_id) in _concrete_dependencies`でループ
2. **2846行目**: `pkg == concrete_pkg`で対象パッケージか判定
3. **2847-2848行目**: `@warn`でモジュール不在の警告を出力
4. **2849行目**: `JLOptions().incremental != 0`でインクリメンタルプリコンパイル中か判定
5. **2851行目**: インクリメンタル時は`PrecompilableError`をスロー

### プログラム呼び出し階層図

```
using/import パッケージ
    |
    +-- require(pkg)
        |
        +-- _require(pkg)  [base/loading.jl]
            |
            +-- (キャッシュ検索失敗後)
            +-- for (concrete_pkg, id) in _concrete_dependencies
            |   +-- pkg == concrete_pkg ?
            |       +-- @warn "Module with build ID is missing"  [base/loading.jl:2847]
            |       +-- (incremental) throw(PrecompilableError())
            |
            +-- (通常のファイルロードへフォールバック)
```

### データフロー図

```
[入力]                          [処理]                        [出力]

PkgId (パッケージID) ────> _require                        ──> Module (成功時)
_concrete_dependencies       |                              ──> @warn ログ出力 (不在時)
                             +-- キャッシュ検索
                             +-- _concrete_dependencies照合
                             +-- (不在時) @warn ──> stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| loading.jl | `base/loading.jl` | ソース | パッケージロード、プリコンパイルキャッシュ管理の全実装 |
