---
generated_at: 2026-02-05 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-ドキュメント置換警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし。すべての主張にソースコード根拠がある。

## 2) 参照した情報（Evidence一覧）

- E-01: `base/docs/Docs.jl` 237-263行目 (`doc!` 関数)
- E-02: `base/docs/Docs.jl` 77-79行目 (`modules`, `META`, `METAType` 定義)
- E-03: `base/docs/Docs.jl` 81-99行目 (`meta`, `initmeta` 関数)
- E-04: `base/docs/Docs.jl` 253行目 (`@warn` 呼び出し)
- E-05: `base/docs/Docs.jl` 252行目 (active_module 比較)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 既存ドキュメントが存在する場合に警告が出力される | E-01 (247行目), E-04 | ○ |
| C-02 | `MultiDoc` が `docs` と `order` フィールドを持つ | E-01 | ○ |
| C-03 | `meta(__module__)` でモジュール単位のメタデータを管理する | E-02, E-03 | ○ |
| C-04 | active_module() と一致する場合は警告が抑止される | E-04, E-05 | ○ |
| C-05 | 新規追加時は `order` に追加される | E-01 (257行目) | ○ |
| C-06 | 置換時は順序が維持される | E-01 (255-258行目のコメント) | ○ |
| C-07 | バインディング名、シグネチャ、モジュール名がメッセージに含まれる | E-04 | ○ |
| C-08 | ログレベルは Warn である | E-04 (`@warn` マクロ使用) | ○ |
| C-09 | Issue #23011 に基づきインタラクティブ使用時の抑止が追加された | E-01 (250-251行目のコメント) | ○ |
| C-10 | `doc!` 関数が通知の発生元である | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `doc!` 関数の条件分岐が正しく記載されているか確認
- [ ] `active_module()` の挙動がREPL環境で正しく動作することを確認
- [ ] `MultiDoc` 構造体の定義が正確であることを確認
