---
generated_at: 2026-02-05 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-非推奨API使用警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/deprecated.jl` 126-230行目 (`@deprecate` マクロ定義)
- E-02: `base/deprecated.jl` 252-258行目 (`depwarn` 関数)
- E-03: `base/deprecated.jl` 259-288行目 (`_depwarn` 関数)
- E-04: `base/deprecated.jl` 261行目 (`JLOptions()` 取得)
- E-05: `base/deprecated.jl` 262-263行目 (depwarn==2 で ErrorException)
- E-06: `base/deprecated.jl` 265行目 (ログレベル判定)
- E-07: `base/deprecated.jl` 266-287行目 (`@logmsg` 呼び出し)
- E-08: `base/deprecated.jl` 290-316行目 (`firstcaller` 関数)
- E-09: `base/deprecated.jl` 285行目 (`maxlog` 設定)
- E-10: `base/deprecated.jl` 136-139行目 (Julia 1.5 の compat note)
- E-11: `base/deprecated.jl` 257行目 (`@invokelatest` 使用)
- E-12: `base/deprecated.jl` 320-349行目 (`@deprecate_binding`, `@deprecate_stdlib` 等)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `@deprecate` マクロが非推奨メソッドを自動生成する | E-01 | ○ |
| C-02 | `depwarn` 関数がログ出力を行う | E-02, E-03 | ○ |
| C-03 | `depwarn==2` で ErrorException がスローされる | E-05 | ○ |
| C-04 | `depwarn==0` (デフォルト) では BelowMinLevel が設定される | E-06 | ○ |
| C-05 | `depwarn==1` または `force=true` で Warn レベルが設定される | E-06 | ○ |
| C-06 | `firstcaller` がバックトレースから呼び出し元を特定する | E-08 | ○ |
| C-07 | `maxlog=1` で同一APIの呼び出しに対して1回のみ出力 | E-09 | ○ |
| C-08 | `funcsym === nothing` の場合 maxlog が nothing になる | E-09 | ○ |
| C-09 | Julia 1.5 以降、デフォルトが `no` に変更された | E-10 | ○ |
| C-10 | `@invokelatest` でバックエッジ追加を防止している | E-11, E-02 (254-256行目コメント) | ○ |
| C-11 | `@nospecializeinfer` が付与されている | E-02 (252行目) | ○ |
| C-12 | `_module` がバックトレースの `linfo` から取得される | E-07 (272-278行目) | ○ |
| C-13 | `_group=:depwarn` が設定される | E-07 (283行目) | ○ |
| C-14 | `@deprecate_binding` と `@deprecate_stdlib` マクロが存在する | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `depwarn` フラグの3つの値（0, 1, 2）に対する動作が正確であることを確認
- [ ] `firstcaller` のバックトレース走査ロジックが正しく説明されているか確認
- [ ] `@logmsg` のパラメータ設定が正確であることを確認
