---
generated_at: 2026-02-05 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-GMP/MPFRビット不一致エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
ソースコードとの照合により、各主張の根拠を検証しています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/gmp.jl` 108-139行目 (`__init__` 関数)
- E-02: `base/gmp.jl` 110行目 (条件チェック)
- E-03: `base/gmp.jl` 111-113行目 (メッセージ生成)
- E-04: `base/gmp.jl` 114行目 (`@error`/`@warn` 分岐)
- E-05: `base/gmp.jl` 35-42行目 (ランタイム値取得関数)
- E-06: `base/gmp.jl` 47-57行目 (`Limb` 型定義)
- E-07: `base/gmp.jl` 117-121行目 (メモリ関数設定)
- E-08: `base/gmp.jl` 124-126行目 (try-catch)
- E-09: `base/gmp.jl` 128-138行目 (ALLOC_OVERFLOW_FUNCTION)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メジャーバージョンまたはビット幅の不一致時に通知が出力される | E-02 | ○ |
| C-02 | ビット幅不一致で `@error`、バージョンのみ不一致で `@warn` | E-04 | ○ |
| C-03 | メッセージに動的/静的バージョンとビット幅が含まれる | E-03 | ○ |
| C-04 | `version()` は C グローバル `__gmp_version` から取得される | E-05 (35-36行目) | ○ |
| C-05 | `bits_per_limb()` は C グローバル `__gmp_bits_per_limb` から取得される | E-05 (38行目) | ○ |
| C-06 | `BITS_PER_LIMB` に基づいて `Limb` 型が決定される | E-06 | ○ |
| C-07 | `__init__` 全体が try-catch で囲まれている | E-01, E-08 | ○ |
| C-08 | 初期化例外は `showerror_nostdio` で出力される | E-08 (125行目) | ○ |
| C-09 | GMP メモリアロケータがJuliaのGC関数に置き換えられる | E-07 | ○ |
| C-10 | `ALLOC_OVERFLOW_FUNCTION` はパッチ済みGMP検出に使用される | E-09 | ○ |
| C-11 | プロセス起動時に1回のみ発生する | E-01 (`__init__` は1回のみ呼ばれる) | ○ |
| C-12 | ZERO と ONE が初期化される | E-01 (122-123行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] `@error`/`@warn` の分岐条件が正確であることを確認
- [ ] メッセージ内の文字列補間が正しく展開されることを確認
- [ ] `__init__` の例外処理が正確に記載されていることを確認
