---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-プロファイル印刷リスナークラッシュ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
ソースコードとの照合により、各主張の根拠を検証しています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `base/Base.jl` 335-353行目 (`profile_printing_listener` 関数)
- E-02: `base/Base.jl` 355-372行目 (`start_profile_listener` 関数)
- E-03: `base/Base.jl` 374-411行目 (`__init__` 関数)
- E-04: `base/Base.jl` 349行目 (`@error` 呼び出し)
- E-05: `base/Base.jl` 347行目 (`InterruptException` チェック)
- E-06: `base/Base.jl` 393-396行目 (非Windows条件)
- E-07: `base/Base.jl` 339行目 (`require_stdlib` 呼び出し)
- E-08: `base/Base.jl` 340-344行目 (`peek_report` とヒープスナップショット)
- E-09: `base/Base.jl` 358行目 (`errormonitor` ラッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `profile_printing_listener` がクラッシュすると `@error` が出力される | E-01, E-04 | ○ |
| C-02 | `InterruptException` は除外される | E-05 | ○ |
| C-03 | 非Windowsプラットフォームでのみ動作する | E-06 | ○ |
| C-04 | `start_profile_listener` が `AsyncCondition` を作成する | E-02 (356行目) | ○ |
| C-05 | `errormonitor` でタスクがラップされている | E-09 | ○ |
| C-06 | `jl_set_peek_cond` でC runtimeにコールバック設定される | E-02 (371行目) | ○ |
| C-07 | `atexit` でクリーンアップが登録される | E-02 (359-366行目) | ○ |
| C-08 | Profile stdlibが遅延ロードされる | E-07 | ○ |
| C-09 | `JULIA_PROFILE_PEEK_HEAP_SNAPSHOT` でヒープスナップショットが制御される | E-08 (341行目) | ○ |
| C-10 | `_trywait(cond)` でシグナル待ちループが実装されている | E-01 (338行目) | ○ |
| C-11 | メッセージは "Profile printing listener crashed" である | E-04 | ○ |
| C-12 | `exception=ex,catch_backtrace()` で例外情報が付加される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] `profile_printing_listener` の try-catch 構造が正確に記載されているか確認
- [ ] `InterruptException` の除外条件が正確であることを確認
- [ ] 非Windows限定の動作が正確に記載されていることを確認
