---
generated_at: 2026-02-05 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：34-パッケージコールバックエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **C-10**：Revise.jl がコールバックを登録するという主張は間接的推測

## 2) 参照した情報（Evidence一覧）

- E-01: `base/loading.jl` 1627行目 -- `@error "Error during package callback" exception=errs`
- E-02: `base/loading.jl` 1616-1632行目 -- `run_package_callbacks` 関数の全体定義
- E-03: `base/loading.jl` 1617行目 -- `run_extension_callbacks(modkey)` の呼び出し
- E-04: `base/loading.jl` 1619行目 -- `unlock(require_lock)`
- E-05: `base/loading.jl` 1629行目 -- `lock(require_lock)` (finally)
- E-06: `base/loading.jl` 1621-1622行目 -- コールバックのイテレーションと invokelatest
- E-07: `base/loading.jl` 1624-1626行目 -- catch ブロックとコメント
- E-08: `base/loading.jl` 1618行目 -- `assert_havelock(require_lock)`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コールバックエラー時に @error が発行される | E-01 | ○ |
| C-02 | 通知メッセージは "Error during package callback" | E-01 | ○ |
| C-03 | exception キーワード引数で例外スタックが含まれる | E-01 | ○ |
| C-04 | require_lock を一時解放してコールバックを実行する | E-04, E-05 | ○ |
| C-05 | finally ブロックで require_lock が再取得される | E-05 | ○ |
| C-06 | run_extension_callbacks が先に呼ばれる | E-03 | ○ |
| C-07 | コールバックエラーはパッケージロードを阻害しない | E-07 | ○ |
| C-08 | base/loading.jl の1627行目で発火する | E-01 | ○ |
| C-09 | package_callbacks をイテレートし invokelatest で実行する | E-06 | ○ |
| C-10 | Revise.jl などがコールバックを登録する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10 について：Revise.jl がコールバックを登録するという主張は、一般的な知識に基づくが、本プロジェクト内のソースコードからは直接確認できない。
  - 候補：Revise.jl のソースコード / Julia パッケージドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 通知のコードパスは明確であり、主要な主張はソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `base/loading.jl` 1627行目の @error メッセージが設計書と一致するか確認
- [ ] require_lock の unlock/lock ペアが正しいか確認
- [ ] コールバックエラー後もパッケージロードが続行されることを確認
