---
generated_at: 2026-02-05 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-拡張機能ロードエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし -- すべての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `base/loading.jl` 1774行目 -- `@error "Error during loading of extension $(extid.id.name) of $(extid.parentid.name), ..."`
- E-02: `base/loading.jl` 1759-1782行目 -- `run_extension_callbacks(extid::ExtensionId)` 関数の全体定義
- E-03: `base/loading.jl` 1769-1771行目 -- インクリメンタルプリコンパイル時の rethrow
- E-04: `base/loading.jl` 1764行目 -- `_require_prelocked(extid.id)` の呼び出し
- E-05: `base/loading.jl` 1763行目 -- `loading_extension = true`
- E-06: `base/loading.jl` 1779行目 -- `loading_extension = false` (finally)
- E-07: `base/loading.jl` 1639-1644行目 -- `ExtensionId` 構造体の定義
- E-08: `base/loading.jl` 1646-1648行目 -- `EXT_PRIMED`, `EXT_DORMITORY`, `EXT_DORMITORY_FAILED`
- E-09: `base/loading.jl` 1784行目以降 -- `run_extension_callbacks(pkgid::PkgId)` の定義
- E-10: `base/loading.jl` 1765行目 -- `@debug "Extension loaded"` 成功時の出力

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 拡張機能ロードエラー時に @error が発行される | E-01 | ○ |
| C-02 | 通知メッセージに拡張名と親パッケージ名が含まれる | E-01 | ○ |
| C-03 | retry_load_extensions() によるリトライが案内される | E-01 | ○ |
| C-04 | インクリメンタルプリコンパイル時は rethrow される | E-03 | ○ |
| C-05 | _require_prelocked で拡張機能がロードされる | E-04 | ○ |
| C-06 | loading_extension フラグが設定・解除される | E-05, E-06 | ○ |
| C-07 | ExtensionId は id, parentid, n_total_triggers, ntriggers を持つ | E-07 | ○ |
| C-08 | EXT_DORMITORY_FAILED に失敗した拡張が追加される | E-08 | ○ |
| C-09 | ntriggers == 0 で拡張がロードされる | E-09 | ○ |
| C-10 | 成功時は @debug "Extension loaded" が出力される | E-10 | ○ |
| C-11 | base/loading.jl の1774行目で発火する | E-01 | ○ |
| C-12 | run_extension_callbacks(pkgid) から run_extension_callbacks(extid) が呼ばれる | E-09, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `base/loading.jl` 1774行目の @error メッセージが設計書と一致するか確認
- [ ] インクリメンタルプリコンパイル時の rethrow 条件が正しいか確認
- [ ] EXT_DORMITORY_FAILED への追加ロジックを確認
