---
generated_at: 2026-02-05 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-アクティブプロジェクトコールバックエラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし -- すべての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `base/initdefs.jl` 383行目 -- `@error "active project callback $f failed" maxlog=1`
- E-02: `base/initdefs.jl` 377-386行目 -- `set_active_project` 関数の全体定義
- E-03: `base/initdefs.jl` 378行目 -- `ACTIVE_PROJECT[] = projfile`
- E-04: `base/initdefs.jl` 379行目 -- `for f in active_project_callbacks`
- E-05: `base/initdefs.jl` 381行目 -- `Base.invokelatest(f)`
- E-06: `base/initdefs.jl` 201行目 -- `const active_project_callbacks = []`
- E-07: `base/initdefs.jl` 197行目 -- `const ACTIVE_PROJECT = Ref{Union{String,Nothing}}(nothing)`
- E-08: `base/initdefs.jl` 263-272行目 -- `init_active_project` 関数

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コールバックエラー時に @error が発行される | E-01 | ○ |
| C-02 | 通知メッセージに失敗したコールバック関数名が含まれる | E-01 | ○ |
| C-03 | maxlog=1 により同一コールバックのエラーは最大1回出力 | E-01 | ○ |
| C-04 | set_active_project が ACTIVE_PROJECT を更新した後にコールバックを実行 | E-02, E-03, E-04 | ○ |
| C-05 | invokelatest でコールバックが実行される | E-05 | ○ |
| C-06 | active_project_callbacks は const 配列として定義 | E-06 | ○ |
| C-07 | ACTIVE_PROJECT は Ref{Union{String,Nothing}} | E-07 | ○ |
| C-08 | init_active_project が起動時に set_active_project を呼ぶ | E-08 | ○ |
| C-09 | base/initdefs.jl の383行目で発火する | E-01 | ○ |
| C-10 | コールバックエラーはプロジェクト切り替えを阻害しない | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `base/initdefs.jl` 383行目の @error メッセージが設計書と一致するか確認
- [ ] maxlog=1 の指定が正しいか確認
- [ ] コールバックエラー後も次のコールバックが実行されることを確認
