---
generated_at: 2026-02-05 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-Windowsスレッドプロファイル制限警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし -- すべての主張にソースコード根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Profile.jl` 294行目 -- `@warn "Profiling on windows is limited to the main thread. Other threads have not been sampled and will not show in the report"`
- E-02: `stdlib/Profile/src/Profile.jl` 271-361行目 -- `print` 関数の定義
- E-03: `stdlib/Profile/src/Profile.jl` 291行目 -- `!in(groupby, [:thread, :task, [:task, :thread], [:thread, :task]])`
- E-04: `stdlib/Profile/src/Profile.jl` 293行目 -- `Sys.iswindows() && in(groupby, [:thread, [:task, :thread], [:thread, :task]])`
- E-05: `stdlib/Profile/src/Profile.jl` 267-268行目 -- docstring 内の Windows 制限に関するノート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows でスレッド関連 groupby 使用時に @warn が発行される | E-01, E-04 | ○ |
| C-02 | 通知メッセージは固定文字列 | E-01 | ○ |
| C-03 | groupby が :thread, [:task, :thread], [:thread, :task] の場合に発火 | E-04 | ○ |
| C-04 | groupby が :none の場合は発火しない | E-02 | ○ |
| C-05 | groupby が :task のみの場合は発火しない | E-04 | ○ |
| C-06 | docstring にも同様の制限が記載されている | E-05 | ○ |
| C-07 | stdlib/Profile/src/Profile.jl の294行目で発火する | E-01 | ○ |
| C-08 | 警告後もプロファイル結果の表示は行われる | E-02 | ○ |
| C-09 | groupby の無効値に対しては ArgumentError がスローされる | E-03 | ○ |
| C-10 | Windows 以外では本通知は発生しない | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- すべての主張がソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `stdlib/Profile/src/Profile.jl` 293-294行目の条件分岐が設計書と一致するか確認
- [ ] groupby の有効値リストが正しいか確認
