---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-ヒープスナップショット書込先変更警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Profile.jl` 1453-1469行目 - `take_heap_snapshot(; dir)` メソッド
- E-02: `stdlib/Profile/src/Profile.jl` 1462行目 - `@warn` マクロ呼び出し
- E-03: `stdlib/Profile/src/Profile.jl` 1454行目 - ファイル名生成フォーマット
- E-04: `stdlib/Profile/src/Profile.jl` 1407-1419行目 - `take_heap_snapshot(filepath)` メソッド
- E-05: `stdlib/Profile/src/Profile.jl` 1428-1452行目 - `_stream_heap_snapshot` 関数
- E-06: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 80-213行目 - `assemble_snapshot` 関数
- E-07: `stdlib/Profile/src/Profile.jl` 1375-1406行目 - ドキュメント文字列

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カレントディレクトリへの書き込みテストに touch を使用 | E-01 (1459行目) | ○ |
| C-02 | 失敗時に tempdir() にフォールバック | E-01 (1463行目) | ○ |
| C-03 | @warn マクロで Warn レベルログを出力 | E-02 | ○ |
| C-04 | maxlog=1 と _id=Symbol(wd) で出力回数を制限 | E-02 | ○ |
| C-05 | ファイル名が getpid()_time_ns().heapsnapshot 形式 | E-03 | ○ |
| C-06 | dir 引数が nothing の場合にのみ本パスが実行される | E-01 (1455-1456行目) | ○ |
| C-07 | テスト成功時は rm で一時ファイルを削除 | E-01 (1460行目) | ○ |
| C-08 | ストリーミングモードでは4つの中間ファイルを生成 | E-05 | ○ |
| C-09 | assemble_snapshot でアセンブル処理を実行 | E-04 (1415行目), E-06 | ○ |
| C-10 | redact_data のデフォルトは true | E-07 | ○ |
| C-11 | pwd() と tempdir() がログメッセージに含まれる | E-02 | ○ |
| C-12 | catch ブロックで例外を捕捉してフォールバック | E-01 (1461行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `take_heap_snapshot` の引数なしメソッド（1453行目）の動作確認
- [ ] `maxlog=1` と `_id=Symbol(wd)` の組み合わせによるログ制御の妥当性確認
