---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-ヒープスナップショット再構成バグ警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 173-174行目 - `@warn` 呼び出し
- E-02: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 54行目 - `k_node_number_of_fields` 定数
- E-03: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 12-23行目 - `Edges` 構造体
- E-04: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 27-51行目 - `Nodes` 構造体
- E-05: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 131行目 - `to_pos` 計算
- E-06: `stdlib/Profile/src/heapsnapshot_reassemble.jl` 88-213行目 - `assemble_snapshot` 関数

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | to_pos が7の倍数でない場合に警告を発行 | E-01 | ○ |
| C-02 | k_node_number_of_fields は定数7 | E-02 | ○ |
| C-03 | SoA レイアウトでデータ構造を定義 | E-03, E-04 | ○ |
| C-04 | to_pos はノードインデックス * 7 で計算 | E-05 | ○ |
| C-05 | エッジのインデックス i とノード番号 n がログに含まれる | E-01 | ○ |
| C-06 | ノードは7フィールドで構成 | E-02, E-06 (156行目 "0,0") | ○ |
| C-07 | 中間ファイルからメタデータを解析してノード数・エッジ数を取得 | E-06 (89-96行目) | ○ |
| C-08 | エッジデータをC側で書き出しJulia側で変換 | E-05, E-06 (122-139行目) | ○ |
| C-09 | 警告は処理を中断せず続行 | E-01 (174行目は警告のみ) | ○ |
| C-10 | Orphan ノードの検出は assert で行う | E-06 (210行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `to_pos` の計算ロジック（131行目）とチェックロジック（173行目）の整合性確認
- [ ] `k_node_number_of_fields = 7` が Chrome DevTools のフォーマットと一致することの確認
