---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-アロケーションプロファイル停止警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/Profile/src/Allocs.jl` 225-231行目 - `warning_empty` 関数
- E-02: `stdlib/Profile/src/Allocs.jl` 321-333行目 - `flat` 関数
- E-03: `stdlib/Profile/src/Allocs.jl` 405-420行目 - `tree` 関数
- E-04: `stdlib/Profile/src/Allocs.jl` 72-77行目 - `@profile` マクロ
- E-05: `stdlib/Profile/src/Allocs.jl` 96-98行目 - `start` 関数
- E-06: `stdlib/Profile/src/Allocs.jl` 125-128行目 - `fetch` 関数
- E-07: `stdlib/Profile/src/Allocs.jl` 132-142行目 - `Alloc`, `AllocResults` 構造体
- E-08: `stdlib/Profile/src/Allocs.jl` 243-248行目 - `print` 関数群

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 結果が空の場合に warning_empty() を呼び出す | E-02 (326行目), E-03 (413行目) | ○ |
| C-02 | flat 関数で isempty(lilist) をチェック | E-02 (325行目) | ○ |
| C-03 | tree 関数で isempty(root.down) をチェック | E-03 (413行目) | ○ |
| C-04 | @warn マクロで固定メッセージを出力 | E-01 | ○ |
| C-05 | sample_rate=1.0 の推奨を含むメッセージ | E-01 | ○ |
| C-06 | fetch() で ccall を通じて C ランタイムからデータ取得 | E-06 | ○ |
| C-07 | Alloc 構造体に type, stacktrace, size, task, timestamp | E-07 | ○ |
| C-08 | print 関数が fetch() を内部で呼び出す | E-08 (243行目) | ○ |
| C-09 | Profile.Allocs は Julia 1.8 で追加 | E-04 (69-70行目 compat 注記) | ○ |
| C-10 | clear() 後に print() で警告が出る | E-01, E-02 (ロジックから推論可能) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `warning_empty()` の呼び出し箇所が `flat` と `tree` の2箇所であることの確認
- [ ] 通知一覧の「停止時の注意メッセージ」記述と実際の実装の整合性確認
