---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-ファイルシステム時刻ずれ警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/FileWatching/src/pidfile.jl` 198行目 - `@warn` 呼び出し
- E-02: `stdlib/FileWatching/src/pidfile.jl` 196-206行目 - `stale_pidfile` 関数
- E-03: `stdlib/FileWatching/src/pidfile.jl` 149-171行目 - `parse_pidfile` 関数
- E-04: `stdlib/FileWatching/src/pidfile.jl` 236-305行目 - `open_exclusive` 関数
- E-05: `stdlib/FileWatching/src/pidfile.jl` 178-189行目 - `isvalidpid` 関数
- E-06: `stdlib/FileWatching/src/pidfile.jl` 57-86行目 - `LockMonitor` 構造体
- E-07: `stdlib/FileWatching/src/pidfile.jl` 42-43行目 - `mkpidlock` ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | age < -stale_age の場合に @warn を発行 | E-01, E-02 (198行目) | ○ |
| C-02 | path がログメッセージに含まれる | E-01 | ○ |
| C-03 | parse_pidfile で pid, hostname, age を取得 | E-03 | ○ |
| C-04 | age は time() - mtime(io) で計算 | E-03 (155行目) | ○ |
| C-05 | stale_age のデフォルトは 0（無効化） | E-07 (34行目) | ○ |
| C-06 | refresh のデフォルトは stale_age/2 | E-07 (39行目) | ○ |
| C-07 | refresh == 0 の場合 longer_factor は 25 | E-02 (199行目) | ○ |
| C-08 | isvalidpid で PID の有効性を確認 | E-05 | ○ |
| C-09 | open_exclusive から stale_pidfile が呼ばれる | E-04 (247, 297行目) | ○ |
| C-10 | LockMonitor に path, fd, update フィールドがある | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 時刻スキュー検出条件 `age < -stale_age` の解釈が正しいことの確認
- [ ] NFS 環境での実際の動作確認
