---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-古いpidfile削除試行警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/FileWatching/src/pidfile.jl` 248行目 - `@warn` 呼び出し（wait=false）
- E-02: `stdlib/FileWatching/src/pidfile.jl` 301行目 - `@warn` 呼び出し（wait=true）
- E-03: `stdlib/FileWatching/src/pidfile.jl` 236-305行目 - `open_exclusive` 関数
- E-04: `stdlib/FileWatching/src/pidfile.jl` 196-206行目 - `stale_pidfile` 関数
- E-05: `stdlib/FileWatching/src/pidfile.jl` 316-342行目 - `tryrmopenfile` 関数
- E-06: `stdlib/FileWatching/src/pidfile.jl` 300行目 - `stale_age -= stale_age`
- E-07: `stdlib/FileWatching/src/pidfile.jl` 42-43行目 - mkpidlock ドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | stale_pidfile() が true を返した場合に @warn を発行 | E-01, E-02 | ○ |
| C-02 | path がログメッセージに含まれる | E-01, E-02 | ○ |
| C-03 | wait=false モードでの発行箇所（246-248行目） | E-01 | ○ |
| C-04 | wait=true モードでの発行箇所（297-301行目） | E-02 | ○ |
| C-05 | tryrmopenfile で削除を試行 | E-01 (249行目), E-02 (302行目) | ○ |
| C-06 | stale_age -= stale_age で2回目以降の削除を防止 | E-06 | ○ |
| C-07 | Windows 環境では rename してから削除 | E-05 (320-333行目) | ○ |
| C-08 | stale_age のデフォルトは 0 | E-07 | ○ |
| C-09 | stale_age の推奨値は処理完了時間の3-5倍 | E-07 | ○ |
| C-10 | poll_interval のデフォルトは10秒 | E-03 (238行目) | ○ |
| C-11 | 同一ロック取得処理内で最大1回の削除試行（wait=trueモード） | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `stale_age -= stale_age` が意図通り stale_age を0にリセットすることの確認
- [ ] wait=false モードと wait=true モードの両方で警告箇所を確認
