---
generated_at: 2026-02-05 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：51-非公開シンボル使用警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `stdlib/REPL/src/REPL.jl` 178-180行目 - `print_qualified_access_warning` 関数定義
- E-02: `stdlib/REPL/src/REPL.jl` 179行目 - `@warn` マクロ呼び出しと `maxlog = 1`、`_id` パラメータ
- E-03: `stdlib/REPL/src/REPL.jl` 224-279行目 - `collect_names_to_warn!` 関数定義
- E-04: `stdlib/REPL/src/REPL.jl` 281-289行目 - `collect_qualified_access_warnings` 関数定義
- E-05: `stdlib/REPL/src/REPL.jl` 291-298行目 - `warn_on_non_owning_accesses` 関数定義
- E-06: `stdlib/REPL/src/REPL.jl` 300行目 - `repl_ast_transforms` 配列への登録
- E-07: `stdlib/REPL/src/REPL.jl` 182-189行目 - `has_ancestor` 関数定義
- E-08: `stdlib/REPL/src/REPL.jl` 192-209行目 - `retrieve_modules` 関数群定義
- E-09: `stdlib/REPL/src/REPL.jl` 248行目 - `has_ancestor(owner, mod)` 判定
- E-10: `stdlib/REPL/src/REPL.jl` 250行目 - `Base.ispublic(mod, name)` 判定
- E-11: `stdlib/REPL/src/REPL.jl` 252行目 - `mod === Base && Base.ispublic(Core, name)` 判定
- E-12: `stdlib/REPL/src/precompile.jl` 158行目 - プリコンパイル時のトリガー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非公開シンボルの修飾アクセス時に @warn で警告が出力される | E-01, E-02 | ○ |
| C-02 | maxlog = 1 により同一シンボルへの警告は1回のみ表示される | E-02 | ○ |
| C-03 | AST変換パイプラインの一部として warn_on_non_owning_accesses が実行される | E-05, E-06 | ○ |
| C-04 | collect_qualified_access_warnings でAST走査し警告対象を収集する | E-03, E-04 | ○ |
| C-05 | has_ancestor で所有モジュールがサブモジュールかを判定し抑止する | E-07, E-09 | ○ |
| C-06 | Base.ispublic で公開状態をチェックし公開シンボルは警告抑止される | E-10 | ○ |
| C-07 | BaseからCoreの公開シンボルへのアクセスは警告抑止される | E-11 | ○ |
| C-08 | retrieve_modules でネストされたモジュールアクセスを解決する | E-08 | ○ |
| C-09 | which(mod, name) でシンボルの所有モジュールを特定する | E-03 (241-245行目) | ○ |
| C-10 | ローカル変数と同名モジュールのフィルタリングが行われる | E-04 (285-287行目) | ○ |
| C-11 | _id パラメータでモジュール・所有者・シンボルの組合せで一意に識別される | E-02 | ○ |
| C-12 | プリコンパイル時にstderrを抑制した状態で事前トリガーされる | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより直接裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `print_qualified_access_warning` の `@warn` メッセージフォーマットが設計書と一致するか確認
- [ ] 抑止条件（公開チェック、サブモジュールチェック、Core/Baseチェック）のロジックが正確か確認
- [ ] `maxlog = 1` と `_id` の組み合わせによる重複抑制の動作を確認
