---
generated_at: 2026-02-05 10:20:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-トランスポート検証拒否エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/LibGit2/src/callbacks.jl` 行423 - `@error("unexpected transport encountered, refusing to validate", cert_type)` の記述
- E-02: `stdlib/LibGit2/src/callbacks.jl` 行381-425 - `certificate_callback` 関数の実装
- E-03: `stdlib/LibGit2/src/callbacks.jl` 行389-391 - `cert_type` の判定ロジック
- E-04: `stdlib/LibGit2/src/callbacks.jl` 行424 - `CERT_REJECT` の返却
- E-05: `stdlib/LibGit2/src/callbacks.jl` 行387 - `valid != 0` チェック
- E-06: `stdlib/LibGit2/src/callbacks.jl` 行518 - `@cfunction` による C 関数ポインタ登録
- E-07: `stdlib/LibGit2/src/callbacks.jl` 行366-375 - `CertHostKey` 構造体定義
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行66 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `@error` で未知のトランスポートと cert_type の値が出力される | E-01 | ○ |
| C-02 | `certificate_callback` 関数内で発生する | E-02 | ○ |
| C-03 | cert_type が TLS でも SSH でもない場合に発生する | E-03 | ○ |
| C-04 | `CERT_REJECT` が返される | E-04 | ○ |
| C-05 | `valid != 0` の場合は早期リターンする | E-05 | ○ |
| C-06 | `@cfunction` で C 関数ポインタとして登録される | E-06 | ○ |
| C-07 | `CertHostKey` 構造体で証明書情報を受け取る | E-07 | ○ |
| C-08 | 通知一覧に登録されている（No.65） | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `callbacks.jl` 行423 の `@error` 文の内容が正しく記載されているか確認
- [ ] CERT_REJECT が返されることを確認
