---
generated_at: 2026-02-05 10:30:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-SSH既知ホストファイル検索エラー警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `stdlib/LibGit2/src/callbacks.jl` 行496 - `@warn("Error searching SSH known hosts file \`$file\`")` の記述
- E-02: `stdlib/LibGit2/src/callbacks.jl` 行444-504 - `ssh_knownhost_check` 関数の実装
- E-03: `stdlib/LibGit2/src/callbacks.jl` 行479-487 - `libssh2_knownhost_checkp` 呼び出し
- E-04: `stdlib/LibGit2/src/callbacks.jl` 行495 - `LIBSSH2_KNOWNHOST_CHECK_FAILURE` チェック
- E-05: `stdlib/LibGit2/src/callbacks.jl` 行488-492 - MATCH/MISMATCH の即時リターン
- E-06: `stdlib/LibGit2/src/callbacks.jl` 行494 - `knownhost_free` の呼び出し
- E-07: `stdlib/LibGit2/src/callbacks.jl` 行498 - `continue` による次のファイルへの進行
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行68 - 通知一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `@warn` でファイルパスを含む警告が出力される | E-01 | ○ |
| C-02 | `ssh_knownhost_check` 関数内で発生する | E-02 | ○ |
| C-03 | `libssh2_knownhost_checkp` が呼び出される | E-03 | ○ |
| C-04 | `FAILURE` の場合に警告が発生する | E-04 | ○ |
| C-05 | MATCH/MISMATCH の場合は即座にリターンする | E-05 | ○ |
| C-06 | リソースが解放される | E-06 | ○ |
| C-07 | 次のファイルの検査が継続される | E-07 | ○ |
| C-08 | 通知一覧に登録されている（No.67） | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードにより直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] `callbacks.jl` 行496 の `@warn` 文が正しく記載されているか確認
- [ ] FAILURE の場合のみ警告が出力されることを確認
