---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：71-非推奨関数使用警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Pkg.test()でのdepwarn有効化**：Pkg側の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `base/deprecated.jl` 177行目 - `@deprecate`マクロ定義
- E-02: `base/deprecated.jl` 215行目 - メッセージテンプレート生成
- E-03: `base/deprecated.jl` 252-258行目 - `depwarn()`関数定義
- E-04: `base/deprecated.jl` 259-288行目 - `_depwarn()`関数定義
- E-05: `base/deprecated.jl` 261-263行目 - `depwarn==2`でErrorException送出
- E-06: `base/deprecated.jl` 265行目 - ログレベル判定ロジック
- E-07: `base/deprecated.jl` 266-287行目 - `@logmsg`によるログ出力
- E-08: `base/deprecated.jl` 283行目 - `_group=:depwarn`設定
- E-09: `base/deprecated.jl` 285行目 - `maxlog=1`（funcsymがnothingでない場合）
- E-10: `base/deprecated.jl` 290-316行目 - `firstcaller()`関数
- E-11: `base/deprecated.jl` 127-176行目 - `@deprecate`のドキュメント
- E-12: `base/deprecated.jl` 232-251行目 - `depwarn()`のドキュメント
- E-13: `base/deprecated.jl` 199-201行目 - エクスポート制御

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @deprecateマクロが非推奨関数定義とdepwarn呼び出しコードを生成 | E-01, E-02 | ○ |
| C-02 | depwarn()が@invokelatestで_depwarnを呼び出す | E-03 | ○ |
| C-03 | --depwarn=errorでErrorExceptionを送出 | E-05 | ○ |
| C-04 | --depwarn=yesまたはforce=trueでWarnレベル、それ以外でBelowMinLevel | E-06 | ○ |
| C-05 | _group=:depwarnでログ出力される | E-08 | ○ |
| C-06 | maxlog=1で同一コールサイトから1回のみ通知 | E-09 | ○ |
| C-07 | funcsymがnothingの場合はmaxlog制限なし | E-09 | ○ |
| C-08 | firstcaller()がバックトレースから呼び出し元を特定 | E-10 | ○ |
| C-09 | メッセージフォーマットは「`old` is deprecated, use `new` instead.」 | E-02 | ○ |
| C-10 | Julia 1.5以降デフォルトで--depwarn=no | E-11 | ○ |
| C-11 | @deprecateは関数のエクスポートも行う | E-13 | ○ |
| C-12 | Julia 1.9以降キーワード引数転送対応 | E-11 | ○ |
| C-13 | @nospecializeinfer属性で型推論の特殊化を抑制 | E-03 | ○ |
| C-14 | _id=(frame,funcsym)で重複制御 | E-07 | ○ |
| C-15 | _module, _file, _lineがバックトレースから取得される | E-07 | ○ |
| C-16 | export_old引数でエクスポート制御可能 | E-01, E-13 | ○ |
| C-17 | @deprecate_binding, @deprecate_stdlib, @deprecate_movedの派生マクロが存在 | E-01 | ○ |
| C-18 | Pkg.test()実行時はデフォルトでdepwarn有効化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Pkg.test()側の`--depwarn=yes`設定の実装は`stdlib/Pkg`にあるが、今回の解析範囲外
  - 候補：`stdlib/Pkg/src/Operations.jl` / `stdlib/Pkg/src/API.jl`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非推奨警告の基本メカニズムはソースコードで完全に確認可能
- 1: 中リスク - Pkg.test()との連携部分は外部パッケージ依存

## 6) レビュアーチェックリスト（最小）
- [ ] `@deprecate`マクロの展開コードが正しく記述されているか確認
- [ ] `--depwarn`オプションの3状態（no/yes/error）の挙動が正確か確認
- [ ] `Pkg.test()`でのdepwarn有効化に関する記述の正確性を確認
