---
generated_at: 2026-02-05 10:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-モジュール置換警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `base/loading.jl` 2736-2755行目 - register_root_module関数
- E-02: `base/loading.jl` 2739行目 - @lock require_lock
- E-03: `base/loading.jl` 2740行目 - PkgId生成
- E-04: `base/loading.jl` 2741行目 - haskey(loaded_modules, key)チェック
- E-05: `base/loading.jl` 2743行目 - oldm !== m 判定
- E-06: `base/loading.jl` 2744-2745行目 - インクリメンタル時のerror
- E-07: `base/loading.jl` 2747行目 - @warnメッセージ
- E-08: `base/loading.jl` 2751行目 - loaded_modules_order追加
- E-09: `base/loading.jl` 2757-2759行目 - Core/Base/Main登録

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | register_root_moduleで既存モジュールの置換を検出する | E-01 | ○ |
| C-02 | require_lockの下で実行される | E-02 | ○ |
| C-03 | PkgIdをキーとしてloaded_modulesを検索する | E-03, E-04 | ○ |
| C-04 | oldm !== mで異なるオブジェクトか判定する | E-05 | ○ |
| C-05 | インクリメンタルプリコンパイル時はerrorを投げる | E-06 | ○ |
| C-06 | 通常時は@warnで警告を出力する | E-07 | ○ |
| C-07 | メッセージは"Replacing module `name`" | E-07 | ○ |
| C-08 | loaded_modules_orderにも追加される | E-08 | ○ |
| C-09 | Core/Base/Mainは起動時に登録される | E-09 | ○ |
| C-10 | @constprop :noneアノテーションが付与されている | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] register_root_moduleの行番号がソースコードと一致するか確認
- [ ] generating_output(true)の判定ロジックが正しいか確認
