---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **対応環境（OS・ターミナル）の具体的なバージョン要件**：ソースコードからの明示的な要件定義なし
  2. **サポート連絡先のURL情報**：外部サイト情報のため変更可能性あり
  3. **起動オプションの完全な一覧**：一部のオプションのみ記載、全量は未確認
  4. **startup.jlの詳細な影響**：スタートアップファイルの具体的な挙動は推定に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（11画面の定義）
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（モード間遷移の定義）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（150機能の定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係
- E-05: `docs/code-to-docs/画面設計書/1-起動バナー画面.md` - 起動バナー画面の設計仕様
- E-06: `docs/code-to-docs/画面設計書/2-Juliaプロンプト（julia>）.md` - Juliaプロンプトの設計仕様
- E-07: `docs/code-to-docs/画面設計書/3-ヘルプモード（help?>）.md` - ヘルプモードの設計仕様
- E-08: `docs/code-to-docs/画面設計書/4-シェルモード（shell>）.md` - シェルモードの設計仕様
- E-09: `docs/code-to-docs/画面設計書/5-Pkgモード（pkg>）.md` - Pkgモードの設計仕様
- E-10: `docs/code-to-docs/画面設計書/6-履歴検索モード.md` - 履歴検索モードの設計仕様
- E-11: `docs/code-to-docs/画面設計書/8-RadioMenu（単一選択メニュー）.md` - RadioMenuの設計仕様
- E-12: `docs/code-to-docs/画面設計書/9-MultiSelectMenu（複数選択メニュー）.md` - MultiSelectMenuの設計仕様
- E-13: `docs/code-to-docs/画面設計書/10-Pager（ページャ）.md` - Pagerの設計仕様
- E-14: `docs/code-to-docs/画面設計書/11-フォールバックREPL.md` - フォールバックREPLの設計仕様
- E-15: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知・警告メッセージ一覧（79件）
- E-16: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ処理一覧
- E-17: `stdlib/REPL/src/REPL.jl` - REPLモジュールのソースコード
- E-18: `base/client.jl` - クライアント起動処理のソースコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Julia REPLは対話的な開発環境である | E-01, E-06 | ○ |
| C-02 | 起動時にASCIIアートのバナーが表示される | E-05 | ○ |
| C-03 | バナーにバージョン番号・コミット情報・ドキュメントURLが含まれる | E-05 | ○ |
| C-04 | `--banner=no` でバナーを非表示にできる | E-05 | ○ |
| C-05 | `--banner=short` で短縮版バナーを表示できる | E-05 | ○ |
| C-06 | `Ctrl+D` でREPLを終了できる | E-02, E-06 | ○ |
| C-07 | `exit()` でREPLを終了できる | E-06 | ○ |
| C-08 | Juliaプロンプトのデフォルト表示は `julia>` である | E-01, E-06 | ○ |
| C-09 | アクティブモジュールがMain以外の場合プレフィックスが表示される | E-06 | ○ |
| C-10 | `?` キーでヘルプモードに遷移する | E-02, E-07 | ○ |
| C-11 | `;` キーでシェルモードに遷移する | E-02, E-08 | ○ |
| C-12 | `]` キーでPkgモードに遷移する | E-02, E-09 | ○ |
| C-13 | `Ctrl+R` で履歴検索モードに起動する | E-02, E-10 | ○ |
| C-14 | 各モードから `Backspace`（行頭）または `Ctrl+C` でJuliaプロンプトに戻る | E-02 | ○ |
| C-15 | Tab補完が関数名・変数名・パスに対応している | E-06 | ○ |
| C-16 | 構文ハイライトが入力中に自動適用される | E-06 | ○ |
| C-17 | 式末尾のセミコロンで結果表示が抑制される | E-06 | ○ |
| C-18 | エラー発生時もREPLは継続する | E-06, E-14 | ○ |
| C-19 | ヘルプモードでdocstringが見つからない場合apropos検索にフォールバックする | E-07 | ○ |
| C-20 | `??` プレフィックスで拡張ヘルプを取得できる | E-07 | ○ |
| C-21 | 履歴検索モードはインクリメンタルにフィルタリングする | E-10 | ○ |
| C-22 | 履歴検索でTabキーによる複数選択が可能 | E-10 | ○ |
| C-23 | プレフィックス検索は上下矢印キーで入力がある状態から起動する | E-02, E-01 | ○ |
| C-24 | Pkgモードの初回アクセス時にPkg.jlが遅延ロードされる | E-09 | ○ |
| C-25 | Pkgモードのプロンプトにプロジェクト環境名が表示される | E-09 | ○ |
| C-26 | Pkgモードのadd/rm/update/status等のコマンドが利用可能 | E-09, E-03 | ○ |
| C-27 | シェルモードのsticky=trueで連続実行が可能 | E-08 | ○ |
| C-28 | シェルモードのcdコマンドがJuliaプロセスの作業ディレクトリを変更する | E-08 | ○ |
| C-29 | 非WindowsではJULIA_SHELL/SHELL環境変数のシェルが使用される | E-08 | ○ |
| C-30 | RadioMenuは上下矢印/Enter/qで操作する | E-11 | ○ |
| C-31 | MultiSelectMenuはEnterでトグル、a=全選択、n=全解除、d=確定 | E-12 | ○ |
| C-32 | Pagerはヘッダに現在位置とパーセンテージを表示する | E-13 | ○ |
| C-33 | フォールバックREPLはREPL.jl読み込み失敗時に起動する | E-14 | ○ |
| C-34 | フォールバックREPLはTERM=dumbのダム端末で起動する | E-14 | ○ |
| C-35 | フォールバックREPLはJULIA_FALLBACK_REPL=trueで強制起動できる | E-14 | ○ |
| C-36 | REPLの入力履歴は ~/.julia/logs/repl_history.jl に保存される | E-06 | ○ |
| C-37 | 通知一覧の警告メッセージが79件定義されている | E-15 | ○ |
| C-38 | エラーメッセージ一覧のMethodError/UndefVarError/BoundsError等の説明 | E-15, E-06 | ○ |
| C-39 | 対応OSがmacOS/Linux/Windows | **根拠なし** | △ |
| C-40 | Julia公式サイトのURLが https://docs.julialang.org | E-05 | ○ |
| C-41 | `--project=@.` オプションでカレントディレクトリの環境を使用できる | **根拠なし** | △ |
| C-42 | サポート連絡先（Discourse/GitHub/Slack）のURL情報 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-39: 対応OSの具体的なバージョン要件はソースコードや設計書に明記されていない。一般的なJuliaの対応環境として記載したが、要確認。
  - 候補：Juliaの公式ダウンロードページ / README.md / CONTRIBUTING.md
- C-41: `--project` オプションの詳細はJuliaのコマンドラインオプション解析コード（`src/jloptions.c`）に含まれるが、今回の解析スコープ外。
  - 候補：`src/jloptions.c` / Julia公式ドキュメント
- C-42: サポート連絡先は外部情報であり、ソースコードには含まれない。URLの最新性の確認が必要。
  - 候補：Julia公式サイト / GitHub README

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面設計書に基づく操作手順は高い信頼性がある
- 0: 低リスク - モード遷移キーの記載は画面遷移図と完全に一致
- 1: 中リスク - 起動オプションは一部のみ記載。全量確認が必要な場合は `jloptions.c` を参照のこと
- 1: 中リスク - サポート連絡先URLは外部情報であり、定期的な更新確認が必要
- 0: 低リスク - エラーメッセージと対処法は通知一覧および画面設計書に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] 1章のシステム概要が正確であるか確認する
- [ ] 2章の起動・終了手順がJuliaの現在のバージョンと一致するか確認する
- [ ] 3章のモード切替キー一覧が画面遷移図と一致するか確認する
- [ ] 4章のコード入力・評価の操作手順が実環境で再現できるか確認する
- [ ] 5章のヘルプモード・履歴検索の操作手順が正確であるか確認する
- [ ] 6章のPkgコマンド一覧がPkg.jlの現行バージョンと一致するか確認する
- [ ] 7章のシェルモードの動作がOS別に正しく記載されているか確認する
- [ ] 12章のQ&Aの回答内容が実際の動作と一致するか確認する
- [ ] 13章のエラーメッセージ・対処法の内容が最新のソースコードと一致するか確認する
- [ ] C-39/C-41/C-42（根拠なし項目）の内容を実環境で検証する
