# Julia REPL 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [起動・終了手順](#2-起動終了手順)
3. [トップ画面（Juliaプロンプト）](#3-トップ画面juliaプロンプト)

**【業務フローに沿った機能】**
4. [【STEP1】コード入力・評価（式の入力と実行）](#4-step1コード入力評価式の入力と実行)
5. [【STEP2-3】ドキュメント参照・調査（ヘルプモード・履歴検索）](#5-step2-3ドキュメント参照調査ヘルプモード履歴検索)
6. [【STEP3-4】パッケージ管理・環境構築（Pkgモード）](#6-step3-4パッケージ管理環境構築pkgモード)
7. [【STEP4-5】OS操作・外部連携（シェルモード）](#7-step4-5os操作外部連携シェルモード)

**【サポート機能】**
8. [ターミナルメニュー（RadioMenu / MultiSelectMenu）](#8-ターミナルメニューradiomenu--multiselectmenu)
9. [ページャ（Pager）](#9-ページャpager)
10. [フォールバックREPL](#10-フォールバックrepl)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Julia REPLとは

Julia REPL（Read-Eval-Print Loop）は、Juliaプログラミング言語の対話的な開発環境です。ターミナル上で動作し、Julia式の入力・評価・結果表示をリアルタイムで行うことができます。構文ハイライト、自動補完、ドキュメント参照、パッケージ管理、OS操作など、開発に必要な機能を統合的に提供します。

主な特徴は以下の通りです:
- 式を入力して即座に評価結果を確認できる対話的環境
- 複数のモード（Julia、ヘルプ、シェル、Pkg）を切り替えて多様な操作が可能
- 構文ハイライト、タブ補完、括弧対応ハイライトなどの高度な編集機能
- 入力履歴の保存・検索による効率的な操作

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します:

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **コード開発** | Julia式の入力・評価、プロトタイピング、データ探索、デバッグ |
| **ドキュメント参照** | 関数・型・マクロのドキュメント検索、APIリファレンス参照 |
| **パッケージ管理** | パッケージの追加・削除・更新、プロジェクト環境の管理 |
| **OS操作** | ファイル操作、ディレクトリ移動、外部コマンド実行 |
| **履歴活用** | 過去の入力の検索・再利用、履歴のエクスポート |

### 1.3 業務フロー概要

本システムにおける典型的な作業は、以下の流れで進行します:

```
+------------------------------------------------------------------+
|                        業務フロー                                  |
+------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】Juliaプロンプトでコードを入力・評価する                  |
|      |                                                             |
|  【STEP 2】ヘルプモードで関数・型のドキュメントを参照する           |
|      |                                                             |
|  【STEP 3】Pkgモードで必要なパッケージを追加・管理する              |
|      |                                                             |
|  【STEP 4】シェルモードでファイル操作・外部コマンドを実行する       |
|      |                                                             |
|  【STEP 5】履歴検索で過去の入力を再利用し、作業を完了する          |
|                                                                    |
+------------------------------------------------------------------+
```

**役割別の業務概要:**

| 役割 | 主な業務 |
|------|---------|
| **開発者（一般ユーザー）** | コードの入力・評価、ドキュメント参照、パッケージ利用、ファイル操作 |
| **パッケージ開発者** | パッケージの開発・テスト、環境管理、プリコンパイル設定 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| Juliaプロンプト | Julia式の入力・評価・結果表示を行うメインの対話環境 | STEP 1 |
| ヘルプモード | 関数・型・マクロのドキュメントを検索・表示する | STEP 2 |
| Pkgモード | パッケージの追加・削除・更新などの管理コマンドを実行する | STEP 3 |
| シェルモード | OSシェルコマンドを実行し、ファイル操作や外部ツールを利用する | STEP 4 |
| 履歴検索モード | 過去の入力をインクリメンタルに検索・再利用する | STEP 5（随時） |
| プレフィックス検索 | 現在の入力をプレフィックスとして履歴を前方/後方検索する | 随時利用 |
| TerminalMenus | プログラムから呼び出す単一選択・複数選択のUIコンポーネント | 随時利用 |
| ページャ | 長いテキスト出力をページ単位でスクロール表示する | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります:

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者（一般ユーザー） | Juliaを使ってプログラミング・データ分析・研究を行うユーザー |
| パッケージ開発者 | Juliaパッケージの開発・テスト・公開を行うユーザー |
| システム管理者 | Juliaのインストール・ビルド・環境設定を管理するユーザー |

注: 本システムにはログイン認証やロールベースの権限管理は存在しません。すべてのユーザーがOSの実行ユーザー権限で同一の機能を利用できます。

### 1.6 対応環境

推奨環境:
- macOS（最新版）
- Linux（主要ディストリビューション）
- Windows 10/11

対応ターミナル:
- カラー対応ターミナル（構文ハイライト、色付きプロンプトが有効）
- ダム端末（フォールバックREPLで最小限の機能を提供）

---

## 2. 起動・終了手順

### 2.1 Juliaの起動方法

1. ターミナル（コマンドプロンプト）を開きます
2. 以下のコマンドを入力してJuliaを起動します

```
julia
```

3. 起動バナー画面が表示されます。バナーにはJuliaのASCIIアートロゴ、バージョン番号、コミット情報、ドキュメントURLが含まれます

```
               _
   _       _ _(_)_     |  Documentation: https://docs.julialang.org
  (_)     | (_) (_)    |
   _ _   _| |_  __ _   |  Type "?" for help, "]?" for Pkg help.
  | | | | | | |/ _` |  |
  | | |_| | | | (_| |  |  Version X.Y.Z (YYYY-MM-DD)
 _/ |\__'_|_|_|\__'_|  |  Official https://julialang.org/ release
|__/                    |

julia>
```

4. 「julia>」プロンプトが表示されれば起動完了です

**起動オプション:**

| オプション | 説明 |
|-----------|------|
| `--banner=no` | バナーを非表示にして起動する |
| `--banner=short` | 短縮版バナーで起動する |
| `--project=@.` | カレントディレクトリのプロジェクト環境を使用する |
| `-t N` / `--threads=N` | N個のスレッドで起動する |

### 2.2 Juliaの終了方法

1. 「julia>」プロンプトが表示されている状態で、以下のいずれかを行います
2. `Ctrl+D` を押下します（推奨）
3. または `exit()` と入力してEnterを押下します

> **注意**: 未保存のデータがある場合は、終了前に必ず保存してください。Juliaプロセスの終了とともにメモリ上のデータはすべて失われます。

### 2.3 起動時のトラブル

**バナーが表示されず「julia>」のみ表示される場合:**

フォールバックREPLが起動しています。REPLモジュールの読み込みに失敗した可能性があります。以下を確認してください:
- Juliaのインストールが正しく完了しているか
- 環境変数 `JULIA_LOAD_PATH` が正しく設定されているか
- 環境変数 `JULIA_FALLBACK_REPL` が `true` に設定されていないか

---

## 3. トップ画面（Juliaプロンプト）

### 3.1 Juliaプロンプトの画面構成

Juliaプロンプト（`julia>`）は、Julia REPLのデフォルトモードであり、最も頻繁に使用する画面です。

**表示要素:**

| 要素 | 表示内容 | 条件 |
|------|----------|------|
| プロンプト | `julia>` | Mainモジュールが有効な場合（通常） |
| モジュールプレフィックス付きプロンプト | `(ModuleName) julia>` | アクティブモジュールがMain以外の場合 |
| 入力テキスト | 構文ハイライト付きのJulia式 | LineEditREPL使用時 |
| 評価結果 | 式の評価結果 | 式がセミコロンで終了しない場合 |
| エラーメッセージ | 赤色のエラー表示 | 評価エラー発生時 |

### 3.2 基本的な使い方

1. 「julia>」プロンプトにJulia式を入力します
2. Enterキーを押下して式を評価します
3. 評価結果が表示されます

```
julia> 1 + 2
3

julia> println("Hello, World!")
Hello, World!
```

### 3.3 モード切替一覧

Juliaプロンプトから各モードへの切り替えは、行頭で特定のキーを入力することで行います。

| キー操作 | 遷移先 | プロンプト表示 | 戻り方 |
|---------|--------|--------------|--------|
| `?` （行頭） | ヘルプモード | `help?>` | `Backspace`（行頭）または `Ctrl+C` |
| `;` （行頭） | シェルモード | `shell>` | `Backspace`（行頭）または `Ctrl+C` |
| `]` （行頭） | Pkgモード | `(EnvName) pkg>` | `Backspace`（行頭）または `Ctrl+C` |
| `Ctrl+R` | 履歴検索モード | 検索プロンプト | `Ctrl+C` または `Ctrl+D` |
| 上下矢印（入力あり） | プレフィックス検索 | - | 検索終了 |

### 3.4 便利な操作

| 操作 | キー | 説明 |
|------|------|------|
| タブ補完 | `Tab` | 入力中の関数名・変数名・パスを自動補完する |
| 評価中断 | `Ctrl+C` | 実行中の処理を中断し、新しいプロンプトを表示する |
| 履歴ナビゲーション | 上下矢印 | 過去の入力を順に表示する |
| 結果の非表示 | 式末尾に `;` | 評価結果を表示しない（式は実行される） |

---

## 4. 【STEP1】コード入力・評価（式の入力と実行）

> **業務フローでの位置**: Julia REPLの最も基本的な操作であり、ユーザーがJulia式を入力・評価し、結果を確認するステップです。

### 4.1 式の入力と評価

**やるべきこと:** Julia式を入力し、評価結果を確認する

**操作手順:**

1. 「julia>」プロンプトに式を入力します
2. Enterキーを押下します
3. 入力式が完全（括弧が閉じている等）であれば、即座に評価が行われます
4. 評価結果がプロンプトの下に表示されます

```
julia> x = [1, 2, 3, 4, 5]
5-element Vector{Int64}:
 1
 2
 3
 4
 5

julia> sum(x)
15
```

### 4.2 複数行入力

括弧や `begin`/`end` ブロックが閉じていない場合、自動的に複数行入力モードになります。

```
julia> function greet(name)
           println("Hello, $name!")
       end
greet (generic function with 1 method)

julia> greet("Julia")
Hello, Julia!
```

### 4.3 構文ハイライトと自動補完

**構文ハイライト:** 入力中のコードは自動的に色付けされ、キーワード、文字列、数値、コメントが視覚的に区別されます。

**タブ補完の使い方:**

1. 関数名や変数名の一部を入力します
2. `Tab` キーを押下します
3. 候補が1つの場合は自動補完されます
4. 候補が複数の場合は候補一覧が表示されます

```
julia> pri[Tab]
print     println   printstyled   primitive
```

### 4.4 評価結果の管理

- 最後の評価結果は変数 `ans` に自動的に格納されます
- 式末尾にセミコロン（`;`）を付けると、評価結果の表示が抑制されます（式は実行されます）
- ロギングマクロ（`@info`、`@warn`、`@error`、`@debug`）の出力はプロンプトに表示されます

### 4.5 エラー発生時の対応

評価中にエラーが発生した場合:
1. 赤色のエラーメッセージとスタックトレースが表示されます
2. REPLは継続します（エラーでREPLが終了することはありません）
3. エラー内容を確認し、式を修正して再入力してください

```
julia> 1 / 0
Inf

julia> "abc" + 1
ERROR: MethodError: no method matching +(::String, ::Int64)
```

**注意点・Tips:**
- `Ctrl+C` を押下すると、実行中の処理を中断できます
- `InterruptException` が発生し、新しいプロンプトが表示されます
- 長時間実行される処理を中断したい場合に使用してください

---

## 5. 【STEP2-3】ドキュメント参照・調査（ヘルプモード・履歴検索）

> **業務フローでの位置**: コード開発中に関数や型のドキュメントを参照し、過去の入力を検索・再利用するステップです。

### 5.1 ヘルプモードの使い方

**やるべきこと:** 関数・型・マクロのドキュメントを検索する

**操作手順:**

1. 「julia>」プロンプトで `?` キーを行頭で入力します
2. プロンプトが「help?>」に変わります
3. 調べたい関数名・型名・マクロ名を入力してEnterを押下します
4. ドキュメント（docstring）がMarkdown形式でターミナルにレンダリングされて表示されます
5. `Backspace`（行頭）または `Ctrl+C` でJuliaプロンプトに戻ります

```
help?> sum
search: sum sum! summary cumsum cumsum!

  sum(itr)

  Returns the sum of all elements in a collection.
  ...
```

**ヘルプモードの詳細機能:**

| 操作 | 説明 |
|------|------|
| `?関数名` | 関数のドキュメントを表示 |
| `??関数名` | 拡張ヘルプ（ソースコード情報等）を表示 |
| `?キーワード` | Juliaキーワードの説明を表示 |
| `?@マクロ名` | マクロのドキュメントを表示 |
| `?演算子` | 演算子のドキュメントを表示 |

**docstringが見つからない場合:** 入力に対応するドキュメントが存在しない場合は、自動的にapropos検索（全文検索）にフォールバックし、関連する識別子の一覧が表示されます。

### 5.2 履歴検索モードの使い方

**やるべきこと:** 過去のREPL入力をインクリメンタルに検索・再利用する

**操作手順:**

1. 「julia>」プロンプトで `Ctrl+R` を押下します
2. 履歴検索モードが起動し、検索プロンプトが表示されます
3. 検索クエリを入力すると、リアルタイムで候補がフィルタリングされます
4. 上下キーまたは `PageUp`/`PageDown` でカーソルを移動します
5. `Tab` キーで候補の選択/解除をトグルします（複数選択可能）
6. `Enter` で確定し、選択した履歴エントリがREPLバッファに挿入されます
7. `Ctrl+C` / `Ctrl+D` で中断し、Juliaプロンプトに戻ります

**履歴検索モードのキー操作:**

| キー | 説明 |
|------|------|
| 上下矢印 | カーソル移動 |
| `PageUp` / `PageDown` | ページ単位の移動 |
| `Tab` | 候補の選択/解除をトグル |
| `Enter` | 確定（選択した履歴をバッファに挿入） |
| `Ctrl+C` / `Ctrl+D` | 中断（Juliaプロンプトに戻る） |

### 5.3 プレフィックス検索の使い方

**やるべきこと:** 現在の入力をプレフィックスとして履歴を検索する

**操作手順:**

1. 「julia>」プロンプトに検索したい文字列の先頭を入力します
2. 入力がある状態で上矢印キーを押下します
3. 入力した文字列で始まる過去の入力が順に表示されます
4. 下矢印キーで逆方向に検索できます

```
julia> pri[上矢印キー]
julia> println("Hello, World!")  # 過去に入力した式が表示される
```

---

## 6. 【STEP3-4】パッケージ管理・環境構築（Pkgモード）

> **業務フローでの位置**: 開発に必要なパッケージの追加・管理とプロジェクト環境の構築を行うステップです。

### 6.1 Pkgモードの基本操作

**やるべきこと:** パッケージの追加・削除・更新などの管理操作を行う

**操作手順:**

1. 「julia>」プロンプトで `]` キーを行頭で入力します
2. プロンプトが「(@v1.x) pkg>」のように、現在のプロジェクト環境名付きで変わります
3. パッケージ管理コマンドを入力してEnterを押下します
4. `Backspace`（行頭）または `Ctrl+C` でJuliaプロンプトに戻ります

> **注意**: 初回アクセス時は `Pkg.jl` モジュールの遅延ロードが行われるため、最初のコマンド実行までに数秒かかることがあります。

### 6.2 主要なPkgコマンド

| コマンド | 説明 | 使用例 |
|---------|------|--------|
| `add パッケージ名` | パッケージをインストールする | `add DataFrames` |
| `rm パッケージ名` | パッケージを削除する | `rm DataFrames` |
| `update` | すべてのパッケージを更新する | `update` |
| `update パッケージ名` | 特定のパッケージを更新する | `update DataFrames` |
| `status` / `st` | インストール済みパッケージの一覧を表示する | `st` |
| `resolve` | パッケージの依存関係を解決する | `resolve` |
| `instantiate` | Manifest.tomlに基づきパッケージを再インストールする | `instantiate` |
| `activate .` | カレントディレクトリのプロジェクト環境を有効にする | `activate .` |
| `activate` | デフォルト環境に戻る | `activate` |

### 6.3 プロジェクト環境の管理

**やるべきこと:** プロジェクト固有の環境を作成・管理する

1. Pkgモードで `activate .` と入力してカレントディレクトリの環境を有効にします
2. プロンプトがプロジェクト名に変わります
3. この環境で `add` したパッケージは `Project.toml` と `Manifest.toml` に記録されます
4. `activate`（引数なし）でデフォルト環境に戻ります

**注意点・Tips:**
- `Project.toml` と `Manifest.toml` はバージョン管理システムにコミットすることで、環境を再現できます
- `instantiate` コマンドで `Manifest.toml` に記録された環境を再現できます

---

## 7. 【STEP4-5】OS操作・外部連携（シェルモード）

> **業務フローでの位置**: ファイル操作やディレクトリ移動、外部コマンドの実行を行い、開発作業を完了させるステップです。

### 7.1 シェルモードの基本操作

**やるべきこと:** OSのシェルコマンドをREPL内から実行する

**操作手順:**

1. 「julia>」プロンプトで `;` キーを行頭で入力します
2. プロンプトが「shell>」に変わります
3. OSコマンドを入力してEnterを押下します
4. コマンドの実行結果が表示されます
5. `Backspace`（行頭）または `Ctrl+C` でJuliaプロンプトに戻ります

> **注意**: シェルモードは `sticky=true` が設定されており、コマンド実行後もシェルモードが維持されます。連続してコマンドを実行できます。

### 7.2 主な操作例

```
shell> ls
file1.jl  file2.jl  Project.toml

shell> pwd
/home/user/myproject

shell> cd src
/home/user/myproject/src

shell> cat file1.jl
```

### 7.3 cdコマンドの特別な動作

`cd` コマンドはシェルモードで特別な処理を持ちます:
- Juliaプロセス自体の作業ディレクトリを変更します（通常のシェルコマンドとは異なります）
- `~` はホームディレクトリに展開されます（`expanduser` 関数による処理）
- 変更後のディレクトリパスが表示されます

### 7.4 使用されるシェル

| プラットフォーム | シェル選択の優先順位 |
|-----------------|-------------------|
| macOS / Linux | 1. `JULIA_SHELL` 環境変数、2. `SHELL` 環境変数、3. `/bin/sh` |
| Windows | システムのコマンドプロセッサ |

**注意点・Tips:**
- OSレベルの権限によりコマンドの実行可否が決まります
- コマンド実行失敗時はエラーメッセージが表示されますが、REPLは継続します
- パイプライン（`|`）やリダイレクトも使用できます

---

## 8. ターミナルメニュー（RadioMenu / MultiSelectMenu）

### 8.1 RadioMenu（単一選択メニュー）

RadioMenuは、選択肢リストから1つの項目を選択するUIコンポーネントです。プログラムから `request(RadioMenu(options))` で呼び出します。

**キー操作:**

| キー | 説明 |
|------|------|
| 上下矢印 | 選択候補を移動 |
| `PageUp` / `PageDown` | ページ単位の移動 |
| `Home` / `End` | 先頭/末尾にジャンプ |
| `Enter` | 現在のカーソル位置の項目を選択（確定） |
| `q` / `Ctrl+C` | キャンセル |

### 8.2 MultiSelectMenu（複数選択メニュー）

MultiSelectMenuは、選択肢リストから複数の項目を選択するUIコンポーネントです。プログラムから `request(MultiSelectMenu(options))` で呼び出します。

**キー操作:**

| キー | 説明 |
|------|------|
| 上下矢印 | 選択候補を移動 |
| `Enter` | 現在のカーソル位置の項目の選択をトグル（選択/解除） |
| `a` / `A` | 全選択 |
| `n` / `N` | 全解除 |
| `d` / `D` | 確定（選択結果を返す） |
| `q` / `Ctrl+C` | キャンセル |

---

## 9. ページャ（Pager）

ページャは、長いテキスト出力をページ単位でスクロール表示するUIコンポーネントです。

**起動方法:** プログラムから `pager(object)` で呼び出します。

**キー操作:**

| キー | 説明 |
|------|------|
| 上下矢印 | 行単位のスクロール |
| `PageUp` / `PageDown` | ページ単位のスクロール |
| `Enter` / `q` | 終了 |

**表示情報:** ヘッダに `(現在行 / 総行数) パーセンテージ%` が表示されます。

---

## 10. フォールバックREPL

### 10.1 フォールバックREPLとは

フォールバックREPLは、標準のREPLモジュール（`REPL.jl`）の読み込みに失敗した場合やダム端末環境で自動的に起動される、最小限の対話環境です。

**起動条件:**
- `REPL.jl` モジュールの読み込みが失敗した場合
- 端末が `TERM=dumb` のダム端末として認識された場合
- 環境変数 `JULIA_FALLBACK_REPL` が `true` に設定されている場合

**制限事項:**
- 行編集機能なし（カーソル移動、削除等の編集操作が制限される）
- タブ補完なし
- 構文ハイライトなし
- 履歴検索なし
- モード切替なし（ヘルプ、シェル、Pkgモードは使用不可）

### 10.2 基本操作

1. 「julia>」プロンプトにJulia式を入力します
2. Enterキーで評価します
3. `Ctrl+D` またはEOFで終了します

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
====================================================================
【STEP 1】Juliaプロンプトでコードを入力・評価する           --> 4章参照
    |
【STEP 2】ヘルプモードで関数・型のドキュメントを参照する     --> 5章参照
    |
【STEP 3】Pkgモードで必要なパッケージを追加・管理する        --> 6章参照
    |
【STEP 4】シェルモードでファイル操作・外部コマンドを実行する --> 7章参照
    |
【STEP 5】履歴検索で過去の入力を再利用し、作業を完了する    --> 5章参照
====================================================================
```

### 11.1 【開発者】STEP1: コードの入力・評価

開発作業の開始時は、まずJuliaを起動してJuliaプロンプトでコードを入力・評価します。

**操作手順:**
1. ターミナルで `julia` コマンドを実行してJuliaを起動します
2. 起動バナーが表示され、「julia>」プロンプトが表示されます
3. プロジェクトの環境を使用する場合は `julia --project=@.` で起動するか、Pkgモードで `activate .` を実行します
4. Julia式を入力し、Enterで評価します
5. 評価結果を確認し、必要に応じてコードを修正します

### 11.2 【開発者】STEP2: ドキュメントの参照

コード開発中に関数の使い方や引数の仕様を確認する場合は、ヘルプモードを使用します。

**操作手順:**
1. 「julia>」プロンプトで `?` キーを行頭で入力します
2. 「help?>」プロンプトで関数名を入力してEnterを押下します
3. ドキュメントを確認したら `Backspace`（行頭）でJuliaプロンプトに戻ります

### 11.3 【開発者】STEP3: パッケージの管理

必要なパッケージの追加や環境の構築を行います。

**操作手順:**
1. 「julia>」プロンプトで `]` キーを行頭で入力します
2. `add パッケージ名` でパッケージをインストールします
3. `st` でインストール済みパッケージの状態を確認します
4. `Backspace`（行頭）でJuliaプロンプトに戻ります
5. `using パッケージ名` でパッケージを読み込みます

### 11.4 【開発者】STEP4-5: ファイル操作と履歴活用

ファイルの確認や外部コマンドの実行、過去の入力の再利用を行います。

**操作手順:**
1. `;` キーでシェルモードに入り、ファイル操作を行います
2. `Ctrl+R` で履歴検索モードに入り、過去の入力を検索・再利用します
3. 作業が完了したら `Ctrl+D` または `exit()` でJuliaを終了します

---

## 12. よくある質問と対処法

### 12.1 起動に関するQ&A

**Q: Juliaの起動に時間がかかります**

A: 初回起動時はプリコンパイル処理のため時間がかかることがあります。2回目以降はキャッシュが利用されるため高速になります。起動時間を短縮するには:
- `--banner=no` オプションでバナー表示を省略する
- 不要なスタートアップファイル（`~/.julia/config/startup.jl`）の処理を見直す
- `--startup-file=no` オプションでスタートアップファイルの読み込みを省略する

**Q: 起動時に「REPL provider not available: using basic fallback」と警告が表示されます**

A: REPLモジュールの読み込みに失敗し、フォールバックREPLが使用されています。Juliaのインストールが正しく完了しているか確認してください。

### 12.2 コード入力に関するQ&A

**Q: 入力中に構文ハイライトが表示されません**

A: ターミナルがカラー出力に対応していない可能性があります。環境変数 `TERM` の設定を確認してください。`TERM=dumb` の場合はカラー表示が無効になります。

**Q: タブ補完が動作しません**

A: フォールバックREPLでは補完機能が利用できません。通常のLineEditREPLが起動していることを確認してください。

**Q: 入力を間違えた場合、どうすれば戻れますか**

A: `Ctrl+C` を押下すると、現在の入力がキャンセルされ、新しいプロンプトが表示されます。

### 12.3 パッケージ管理に関するQ&A

**Q: Pkgモードで最初のコマンドが遅いです**

A: Pkg.jlは遅延ロード方式を採用しているため、初回アクセス時にモジュールのロードが行われます。2回目以降のコマンドは通常の速度で動作します。

**Q: パッケージの依存関係エラーが発生します**

A: Pkgモードで `resolve` コマンドを実行し、依存関係を再解決してください。問題が解決しない場合は `instantiate` コマンドを試してください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| 症状 | 原因 | 対処法 |
|------|------|--------|
| `ERROR: MethodError: no method matching ...` | 引数の型が関数のメソッド定義に一致しない | ヘルプモードで関数の正しい使い方を確認する |
| `ERROR: UndefVarError: x not defined` | 未定義の変数を参照している | 変数が正しく定義されているか確認する |
| `ERROR: BoundsError: attempt to access ...` | 配列の範囲外にアクセスしている | インデックスが配列のサイズ内であるか確認する |
| `ERROR: ArgumentError: ...` | 関数に不正な引数が渡されている | 引数の値や型を確認し、正しい値を指定する |
| `ERROR: DomainError with ...` | 数学関数の定義域外の値が渡されている | 入力値の範囲を確認する |
| 処理が長時間応答しない | 無限ループや長時間計算 | `Ctrl+C` で処理を中断する |
| 「Terminal not fully functional」警告 | ターミナルの機能が制限されている | ターミナルの設定や `TERM` 環境変数を確認する |
| 「Error in the keymap」エラー | REPLのキーマップ処理にエラーが発生 | Juliaを再起動する。問題が続く場合はスタートアップファイルを確認する |
| 「Error in SyntaxHighlightPass」エラー | 構文ハイライト処理にエラーが発生 | 入力を完了させるか、`Ctrl+C` でキャンセルする。問題が続く場合はJuliaを再起動する |
| 「Malformed history entry」警告 | REPL履歴ファイルに不正なエントリがある | `~/.julia/logs/repl_history.jl` ファイルの内容を確認し、不正行を削除する |

### 13.2 よくあるトラブルと解決方法

**トラブル: REPLがフリーズした**

1. `Ctrl+C` を押下して実行中の処理を中断します
2. それでも応答しない場合は `Ctrl+\` でシグナルを送信します
3. 最終手段としてターミナルから `kill` コマンドでプロセスを終了します

**トラブル: パッケージのプリコンパイルに失敗する**

1. Pkgモードで `update` を実行してパッケージを最新版に更新します
2. `resolve` コマンドで依存関係を再解決します
3. 問題が続く場合は `~/.julia/compiled/` ディレクトリのキャッシュを削除し、再プリコンパイルします

**トラブル: 文字化けが発生する**

1. ターミナルの文字エンコーディングがUTF-8に設定されているか確認します
2. 環境変数 `LANG` が適切に設定されているか確認します（例: `en_US.UTF-8`）

**トラブル: シェルモードでコマンドが実行できない**

1. 使用するシェルが正しく設定されているか確認します
2. 環境変数 `JULIA_SHELL` または `SHELL` の設定を確認します
3. コマンドのパスが通っているか確認します

### 13.3 サポートへの連絡方法

- **公式ドキュメント**: https://docs.julialang.org
- **Juliaフォーラム（Discourse）**: https://discourse.julialang.org
- **GitHub Issues**: https://github.com/JuliaLang/julia/issues
- **Slack**: julialang.slack.com

バグ報告の際は、以下の情報を含めてください:
1. Juliaのバージョン（起動バナーに表示されるバージョン番号）
2. OS情報（`versioninfo()` の出力）
3. エラーメッセージの全文
4. 再現手順

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-05 | 初版作成 |

---

*本マニュアルは、Julia REPL のエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
