---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **NFT-047（配列キャッシュアライメント閾値テスト）**：合格基準の具体的検証方法が不明確
  2. **NFT-048（インライン配列サイズ閾値テスト）**：実際の検証コードが特定できていない
  3. **NFT-040（タスクメトリクス有効化テスト）**：具体的なテスト手順の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/gc/binarytree.jl` - GCバイナリツリーベンチマーク
- E-02: `test/gc/linkedlist.jl` - GCリンクリストベンチマーク
- E-03: `test/gc/objarray.jl` - GCオブジェクト配列ベンチマーク
- E-04: `test/gc/chunks.jl` - GCチャンクベンチマーク
- E-05: `test/gc.jl` - GCテストスイート（issue_54275_test, run_nonzero_page_utilization_test, run_pg_size_test, full_sweep_reasons_test）
- E-06: `test/threadpool_latency.jl` - インタラクティブスレッドプールレイテンシテスト
- E-07: `test/threads.jl` - スレッドテストエントリポイント
- E-08: `test/threads_exec.jl` - マルチスレッド実行テスト（SpinLock、並行処理）
- E-09: `test/atomics.jl` - アトミック操作テスト
- E-10: `test/stress.jl` - ストレステスト（FD枯渇、FIFO、SIGINT）
- E-11: `test/secretbuffer.jl` - SecretBufferセキュリティテスト
- E-12: `base/secretbuffer.jl` - SecretBuffer実装
- E-13: `src/safepoint.c` - GCセーフポイント実装
- E-14: `test/stack_overflow.jl` - スタックオーバーフローテスト
- E-15: `src/jloptions.c` - コマンドラインオプションパーサ（parse_heap_size_option）
- E-16: `src/dlload.c` - 動的ライブラリロード実装
- E-17: `src/processor.h` - CPUプロセッサ機能検出定義
- E-18: `src/abi_x86.cpp`, `src/abi_x86_64.cpp`, `src/abi_aarch64.cpp`, `src/abi_arm.cpp`, `src/abi_ppc64le.cpp`, `src/abi_riscv.cpp`, `src/abi_win32.cpp`, `src/abi_win64.cpp` - ABI実装
- E-19: `test/embedding/embedding.c` - C API組み込みテスト
- E-20: `src/gc-stock.c` - GCストック実装（max_mem_32bit_systems、並列マーキング/スイープ変数）
- E-21: `src/threading.c` - スレッディング実装（ELF TLS、コンパイル時間計測、タスクメトリクス）
- E-22: `src/options.h` - ビルドオプション（GC_VERIFY、MEMDEBUG、ARRAY_CACHE_ALIGN_THRESHOLD等）
- E-23: `src/signal-handling.c` - プロファイラ・シグナルハンドリング実装
- E-24: `src/timing.h` - タイミングサブシステム定義
- E-25: `src/scheduler.c` - スレッドスケジューラ（sleep_threshold）
- E-26: `contrib/pgo-lto/Makefile` - PGO+LTOビルドシステム
- E-27: `test/cmdlineargs.jl` - コマンドラインテスト（SIGQUITテスト含む）
- E-28: `test/file.jl` - ファイルシステムテスト（Windows互換性含む）
- E-29: `test/choosetests.jl` - テスト選択システム（--seed、--exit-on-error）
- E-30: `AGENTS.md` - エージェント開発ガイド（JULIA_TEST_FAILFAST）
- E-31: `Make.inc` - ビルドシステム設定（JULIA_THREADS等）
- E-32: `base/timing.jl` - GC_Num構造体、GC統計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: GCバイナリツリー割り当て・回収テスト | E-01, E-05 | ○ |
| C-02 | NFT-002: GCリンクリスト割り当て・回収テスト | E-02, E-05 | ○ |
| C-03 | NFT-003: GCオブジェクト配列割り当て・回収テスト | E-03, E-05 | ○ |
| C-04 | NFT-004: GCチャンク割り当て・回収テスト | E-04, E-05 | ○ |
| C-05 | NFT-005: GCライブバイト増加抑制テスト | E-05 | ○ |
| C-06 | NFT-006: GCページ利用率テスト | E-05 | ○ |
| C-07 | NFT-007: GCページサイズ検証テスト | E-05 | ○ |
| C-08 | NFT-008: GCフルスイープ理由記録テスト | E-05 | ○ |
| C-09 | NFT-009: インタラクティブスレッドプールレイテンシテスト | E-06 | ○ |
| C-10 | NFT-010: マルチスレッド並行実行正当性テスト | E-07, E-08 | ○ |
| C-11 | NFT-011: アトミック操作正当性テスト | E-09 | ○ |
| C-12 | NFT-012: SpinLockマルチスレッド排他制御テスト | E-08 | ○ |
| C-13 | NFT-013: ReentrantLock協調的並行アクセステスト | E-07 | ○ |
| C-14 | NFT-014: PGO+LTOビルド最適化テスト | E-26 | ○ |
| C-15 | NFT-015: ファイルディスクリプタ枯渇テスト | E-10 | ○ |
| C-16 | NFT-016: FIFO繰り返し開閉ストレステスト | E-10 | ○ |
| C-17 | NFT-017: SecretBufferシュレッド機能テスト | E-11, E-12 | ○ |
| C-18 | NFT-018: SecretBufferファイナライザテスト | E-11, E-12 | ○ |
| C-19 | NFT-019: SecretBuffer!元データゼロクリアテスト | E-11, E-12 | ○ |
| C-20 | NFT-020: SecretBuffer表示マスキングテスト | E-11, E-12 | ○ |
| C-21 | NFT-021: SIGINTハンドリングテスト | E-10 | ○ |
| C-22 | NFT-022: GCセーフポイントmprotectテスト | E-13 | ○ |
| C-23 | NFT-023: スタックオーバーフローハンドリングテスト | E-14 | ○ |
| C-24 | NFT-024: Channelクローズ時スタックオーバーフローテスト | E-14 | ○ |
| C-25 | NFT-025: スレッドテストウォッチドッグ | E-08 | ○ |
| C-26 | NFT-026: ヒープサイズヒント環境変数テスト | E-15 | ○ |
| C-27 | NFT-027: クロスプラットフォーム共有ライブラリロードテスト | E-16 | ○ |
| C-28 | NFT-028: マルチCPUアーキテクチャ対応テスト | E-17 | ○ |
| C-29 | NFT-029: C ABI互換性テスト | E-18 | ○ |
| C-30 | NFT-030: C API組み込みテスト | E-19 | ○ |
| C-31 | NFT-031: 32ビットシステムメモリ制限テスト | E-20 | ○ |
| C-32 | NFT-032: ELF TLSバリアント互換テスト | E-21 | ○ |
| C-33 | NFT-033: ASANビルドテスト | E-21 | ○ |
| C-34 | NFT-034: TSANビルドテスト | E-21 | ○ |
| C-35 | NFT-035: GC検証モードテスト | E-22 | ○ |
| C-36 | NFT-036: MEMDEBUGモードテスト | E-22 | ○ |
| C-37 | NFT-037: ランタイムプロファイラ初期化テスト | E-23 | ○ |
| C-38 | NFT-038: タイミングサブシステム制御テスト | E-24 | ○ |
| C-39 | NFT-039: コンパイル時間計測テスト | E-21 | ○ |
| C-40 | NFT-040: タスクメトリクス有効化テスト | E-21 | △ |
| C-41 | NFT-041: GC並列マーキングスレッドテスト | E-20 | ○ |
| C-42 | NFT-042: GC並行スイープテスト | E-20 | ○ |
| C-43 | NFT-043: スレッドスリープ閾値テスト | E-25 | ○ |
| C-44 | NFT-044: GCヒープ上限ソフトリミットテスト | E-20 | ○ |
| C-45 | NFT-045: SIGQUITバックトレース出力テスト | E-27 | ○ |
| C-46 | NFT-046: Windows Vista以降互換性テスト | E-28 | ○ |
| C-47 | NFT-047: 配列キャッシュアライメント閾値テスト | E-22 | △ |
| C-48 | NFT-048: インライン配列サイズ閾値テスト | E-22 | △ |
| C-49 | NFT-049: テストシード指定再現性テスト | E-29 | ○ |
| C-50 | NFT-050: テストフェイルファスト動作テスト | E-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-040（タスクメトリクス有効化テスト）**: `jl_task_metrics_enabled`の変数定義は確認できたが、具体的なテストコードやメトリクス収集の詳細な仕様書が見つからなかった
  - 候補：タスクメトリクスのドキュメント / テスト実装 / メトリクス仕様
- **NFT-047（配列キャッシュアライメント閾値テスト）**: `ARRAY_CACHE_ALIGN_THRESHOLD`定数は`src/options.h`で定義されているが、この閾値を検証する専用テストが特定できなかった
  - 候補：配列アロケーションのユニットテスト / メモリアライメント検証テスト
- **NFT-048（インライン配列サイズ閾値テスト）**: `ARRAY_INLINE_NBYTES`定数は`src/options.h`で定義されているが、インライン配列のメモリレイアウトを直接検証するテストが特定できなかった
  - 候補：配列メモリレイアウトテスト / インライン最適化テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコード中の既存テストまたは実装コードに直接的な根拠がある
- 1: 中リスク - NFT-047, NFT-048はソースコードの定数定義に基づくが、専用テストの存在は未確認。合格基準の具体的な検証方法の確認が必要
- 1: 中リスク - NFT-040はタスクメトリクス機能の利用方法・テスト手順の詳細が不十分。機能の成熟度を確認する必要がある
- 0: 低リスク - セキュリティテスト（NFT-017~021）はSecretBufferの既存テストに強い根拠がある
- 0: 低リスク - 互換性テスト（NFT-027~032）はCランタイムのソースコードに直接的な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-040: タスクメトリクスの具体的なテスト手順と期待結果が妥当か確認
- [ ] NFT-047, NFT-048: 配列メモリレイアウトの合格基準が検証可能か確認
- [ ] 各テストケースの「合格基準」が具体的かつ測定可能であるか通読確認
- [ ] GCテスト（NFT-001~008, NFT-041~044）のスレッド構成パラメータが網羅的か確認
- [ ] セキュリティテスト（NFT-017~021）がSecretBufferの全機能をカバーしているか確認
- [ ] 互換性テスト（NFT-027~032）が全ターゲットプラットフォームをカバーしているか確認
- [ ] ストレステスト（NFT-015~016）の条件がCI環境で再現可能か確認
