---
generated_at: 2026-02-05 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 39
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：39 / 42、根拠なし：3
- 優先レビュー（高）
  1. **可用性要件 - サービスとしての稼働率定義なし**：ランタイム特性として妥当だが、組込利用時の要件が別途存在する可能性あり
  2. **拡張性 - ワーカー認証Cookieのセキュリティ特性**：Cookie機構の詳細な暗号学的特性が未確認
  3. **CI連携 - CIデバッグ変数自動検出の対象変数**：具体的にどのCI環境変数が検出対象かの詳細がコード上で特定しきれていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `base/asyncevent.jl` - Timer、sleep、timedwait関数の実装
- E-02: `src/jloptions.c` - コマンドラインオプション解析と初期値設定
- E-03: `src/jloptions.h` - JLOptions構造体定義
- E-04: `base/options.jl` - Julia側のJLOptions構造体定義
- E-05: `base/error.jl` - retry関数とExponentialBackOff実装
- E-06: `base/loading.jl` - 拡張機能ロードとretry_load_extensions
- E-07: `src/gc-stock.c` - GCヒープ統計、メモリ上限、収集間隔
- E-08: `src/safepoint.c` - セーフポイント同期機構
- E-09: `base/logging/logging.jl` - CoreLoggingモジュール（AbstractLogger、ログレベル等）
- E-10: `doc/src/manual/environment-variables.md` - 環境変数ドキュメント
- E-11: `base/experimental.jl` - task_metrics、wait_with_timeout等の実験的API
- E-12: `base/threadingconstructs.jl` - スレッドプール、nthreads等
- E-13: `base/stream.jl` - LibuvStream/LibuvServer抽象型

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Timer最小精度は1ミリ秒、libuv +1ms補正あり | E-01 | ○ |
| C-02 | timedwaitポーリング間隔は最小1ミリ秒、デフォルト0.1秒 | E-01 | ○ |
| C-03 | 分散ワーカー接続タイムアウトはデフォルト60秒 | E-10 | ○ |
| C-04 | セーフポイントタイムアウトは1秒〜INT16_MAX秒で設定可能 | E-02 | ○ |
| C-05 | wait_with_timeout最小タイムアウトは0.001秒 | E-11 | ○ |
| C-06 | スレッド数は1〜INT16_MAXで設定可能 | E-02 | ○ |
| C-07 | GCスレッドはマークN本・スイープM本（0or1）構成 | E-02, E-07 | ○ |
| C-08 | 並列プロセスは-pオプションで1〜INT16_MAX | E-02 | ○ |
| C-09 | プリコンパイルキャッシュ上限はデフォルト10 | E-10 | ○ |
| C-10 | ヒープサイズヒントはB/K/M/G/T/%単位で指定可能 | E-02 | ○ |
| C-11 | ハードヒープ上限超過時にプロセスアボート | E-02 | ○ |
| C-12 | 32bitシステムメモリ上限は1.5GiB | E-07 | ○ |
| C-13 | 64bitシステムメモリソフトリミットは2PiB | E-07 | ○ |
| C-14 | デフォルトGC収集間隔は64bit:約45MiB / 32bit:約12MiB | E-07 | ○ |
| C-15 | サービスとしての稼働率要件はコードに定義なし | **根拠なし** | △ |
| C-16 | retry関数はExponentialBackOff付きで提供 | E-05 | ○ |
| C-17 | ExponentialBackOffデフォルト: n=1, first_delay=0.05s, max_delay=10.0s | E-05 | ○ |
| C-18 | retry_load_extensionsで失敗した拡張機能の手動再試行が可能 | E-06 | ○ |
| C-19 | シグナルハンドリングはデフォルトyes | E-02 | ○ |
| C-20 | GC同期はセーフポイントベースでuv_mutex/uv_condによる同期 | E-08, E-07 | ○ |
| C-21 | ホスト検証は4つの環境変数で制御 | E-10 | ○ |
| C-22 | SSL証明書ルートはJULIA_SSL_CA_ROOTS_PATHで指定 | E-10 | ○ |
| C-23 | パッケージサーバデフォルトはhttps://pkg.julialang.org | E-10 | ○ |
| C-24 | 境界チェックはデフォルトauto | E-02 | ○ |
| C-25 | 実験的機能は--experimentalフラグで有効化が必要 | E-02 | ○ |
| C-26 | 3種のサニタイザ（Memory/Thread/Address）に対応 | E-02 | ○ |
| C-27 | 2つのスレッドプール（default/interactive）構成 | E-02, E-12 | ○ |
| C-28 | autoはCPUアフィニティに基づきスレッド数を自動推定 | E-02 | ○ |
| C-29 | ワーカー認証用Cookie設定が存在 | E-02 | ○ |
| C-30 | ワーカーCookieの暗号学的安全性 | **根拠なし** | △ |
| C-31 | compiled-modulesは4段階（yes/no/existing/strict）で制御 | E-02 | ○ |
| C-32 | デバッグ情報レベルはリリース1/デバッグ2がデフォルト | E-02 | ○ |
| C-33 | CoreLoggingは4段階ログレベルを提供 | E-09 | ○ |
| C-34 | ログ生成中の例外をデフォルトでキャッチ | E-09 | ○ |
| C-35 | JULIA_DEBUG環境変数でデバッグロギングを有効化 | E-10 | ○ |
| C-36 | task-metricsオプションでタスクメトリクス収集を制御 | E-11, E-04 | ○ |
| C-37 | jl_full_sweep_reasonsでフルGC理由を記録 | E-07 | ○ |
| C-38 | ヒープスナップショットはJULIA_PROFILE_PEEK_HEAP_SNAPSHOTで有効化 | E-10 | ○ |
| C-39 | JITプロファイリングはENABLE_JITPROFILINGで制御 | E-10 | ○ |
| C-40 | JULIA_TIMING_SUBSYSTEMSでゾーンごとの有効/無効を制御 | E-10 | ○ |
| C-41 | CIデバッグ環境変数自動検出で--trace-evalとJULIA_TEST_VERBOSE=trueを自動有効化 | E-10 | ○ |
| C-42 | CIデバッグ変数自動検出の対象変数の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15（稼働率要件の定義なし）: Juliaがランタイムであるため妥当だが、Julia Hubや長時間バッチ処理等の運用コンテキストでは別途要件が存在する可能性がある
  - 候補：運用ドキュメント / デプロイガイド / Julia Hub設計書
- C-30（ワーカーCookieの暗号学的安全性）: `--worker`オプションで設定されるCookieの生成方法・暗号強度についてはコードの解析範囲外（Distributed.jl側の実装）
  - 候補：`stdlib/Distributed/` / ワーカー認証設計文書
- C-42（CIデバッグ変数の対象変数）: `doc/src/manual/environment-variables.md`に記載はあるが、具体的にどのCI環境変数（GITHUB_ACTIONS等）をトリガーとするかの完全な一覧がbase/コード内で特定できなかった
  - 候補：`base/client.jl` / CI設定ファイル / `.github/workflows/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 性能要件（C-01〜C-14）: ソースコードから直接的に数値が確認可能
- 0: 低リスク - セキュリティ要件（C-21〜C-26）: 環境変数ドキュメントおよびオプション解析コードに明記
- 1: 中リスク - 可用性要件（C-15〜C-20）: ランタイム特性としての妥当性は高いが、運用コンテキスト依存の要件が漏れている可能性
- 1: 中リスク - ワーカーCookieセキュリティ（C-30）: 認証機構の暗号学的強度が未確認
- 0: 低リスク - 保守性・監視要件（C-32〜C-42）: コードおよびドキュメントに直接的な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件の数値（タイムアウト、メモリ上限等）がソースコードの値と一致しているか
- [ ] GCパラメータ（収集間隔、メモリ上限）の記述が`src/gc-stock.c`の実装と整合しているか
- [ ] セキュリティ要件の環境変数一覧が`doc/src/manual/environment-variables.md`と一致しているか
- [ ] スレッドプールアーキテクチャの説明が`src/jloptions.c`のオプション解析と整合しているか
- [ ] ExponentialBackOffのデフォルトパラメータが`base/error.jl`の値と一致しているか
- [ ] 分散ワーカーCookieのセキュリティ特性について、Distributed.jl側の実装を別途確認する必要があるか判断
- [ ] CIデバッグ自動検出の対象環境変数が正確かを`base/client.jl`等で確認
