---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **etcd v3 の具体的バージョン要件**：go.mod には etcd クライアントの依存はあるが、推奨 etcd サーバーバージョンの明示的な定義はコード内に見当たらない
  2. **Container Runtime の具体的対応バージョン**：CRI インターフェース定義は存在するが、対応ランタイムのバージョン一覧はコードから特定困難
  3. **Cloud Provider 対応一覧の網羅性**：cloud-provider インターフェースは確認できるが、具体的な対応クラウドプロバイダーの一覧はコードからは限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `go.mod` - Go モジュール定義、依存ライブラリとバージョン
- E-02: `cmd/kube-apiserver/app/server.go` - kube-apiserver のエントリーポイント、import による依存関係
- E-03: `cmd/kube-controller-manager/app/controllermanager.go` - controller-manager のエントリーポイント
- E-04: `pkg/scheduler/scheduler.go` - スケジューラの実装、import による依存関係
- E-05: `cmd/` ディレクトリ構成 - 全コンポーネントのエントリーポイント一覧
- E-06: `pkg/` ディレクトリ構成 - コア実装パッケージ一覧
- E-07: `staging/src/k8s.io/` ディレクトリ構成 - 共有ライブラリパッケージ一覧
- E-08: `staging/src/k8s.io/apiserver/pkg/storage/` - ストレージレイヤー実装（etcd3 含む）
- E-09: `staging/src/k8s.io/apiserver/pkg/authentication/` - 認証実装パッケージ
- E-10: `staging/src/k8s.io/apiserver/pkg/authorization/` - 認可実装パッケージ
- E-11: `staging/src/k8s.io/apiserver/pkg/admission/` - Admission Control 実装
- E-12: `staging/src/k8s.io/apiserver/pkg/endpoints/` - API エンドポイント実装
- E-13: `staging/src/k8s.io/client-go/` - クライアントライブラリ（informers, listers 等）
- E-14: `pkg/controller/` ディレクトリ構成 - 組み込みコントローラー一覧
- E-15: `pkg/registry/` ディレクトリ構成 - API リソース Registry 一覧
- E-16: `pkg/kubelet/` ディレクトリ構成 - kubelet 実装パッケージ
- E-17: `pkg/proxy/` ディレクトリ構成 - kube-proxy 実装（iptables, ipvs, nftables）
- E-18: `pkg/volume/` ディレクトリ構成 - ボリュームプラグイン実装
- E-19: `pkg/auth/` ディレクトリ構成 - 認可ヘルパー
- E-20: `staging/src/k8s.io/apiserver/pkg/server/` - API Server フレームワーク
- E-21: `api/` ディレクトリ - OpenAPI 仕様、API ルール
- E-22: `plugin/` ディレクトリ - プラグインパッケージ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Kubernetes は Go 言語で実装されている | E-01 (go.mod: module k8s.io/kubernetes, go 1.25.0) | ○ |
| C-02 | 主要コンポーネントは kube-apiserver, kube-controller-manager, kube-scheduler, kubelet, kube-proxy | E-05 (cmd/ ディレクトリに各コンポーネントが存在) | ○ |
| C-03 | kube-apiserver は REST API を提供し認証・認可・Admission を処理する | E-02, E-09, E-10, E-11, E-12 | ○ |
| C-04 | etcd が永続化ストレージとして使用される | E-08 (apiserver/pkg/storage/etcd3/ の存在) | ○ |
| C-05 | CRI (Container Runtime Interface) で Container Runtime と通信 | E-07 (staging/src/k8s.io/cri-api/ の存在), E-16 | ○ |
| C-06 | CSI (Container Storage Interface) でボリュームを管理 | E-18 (pkg/volume/csi/ の存在) | ○ |
| C-07 | Prometheus client_golang v1.23.2 でメトリクスを公開 | E-01 (go.mod に github.com/prometheus/client_golang v1.23.2) | ○ |
| C-08 | go-restful/v3 v3.13.0 を API フレームワークとして使用 | E-01 (go.mod に github.com/emicklei/go-restful/v3 v3.13.0) | ○ |
| C-09 | CEL (cel-go) v0.26.0 を Admission Policy に使用 | E-01 (go.mod に github.com/google/cel-go v0.26.0) | ○ |
| C-10 | cobra を CLI フレームワークとして使用 | E-02 (import github.com/spf13/cobra) | ○ |
| C-11 | klog/v2 を構造化ロギングに使用 | E-02 (import k8s.io/klog/v2) | ○ |
| C-12 | client-go の Informer/WorkQueue パターンでコントロールループを実現 | E-03, E-04, E-13 (client-go/informers, leaderelection 等の import) | ○ |
| C-13 | pkg/controller/ に組み込みコントローラーが配置 (deployment, job, replicaset 等) | E-14 (ディレクトリ一覧で確認) | ○ |
| C-14 | pkg/registry/ に API リソースの Registry (Strategy パターン) が配置 | E-15 (ディレクトリ一覧: core, apps, batch, rbac 等) | ○ |
| C-15 | staging/ パッケージは独立した Go モジュールとして公開される | E-07, E-13 (staging/src/k8s.io/ に go.mod が各パッケージに存在) | ○ |
| C-16 | kube-proxy は iptables, ipvs, nftables をサポート | E-17 (pkg/proxy/ に iptables/, ipvs/, nftables/ ディレクトリ) | ○ |
| C-17 | Scheduler は Plugin Framework で拡張可能 | E-04 (scheduler/framework/, scheduler/framework/plugins/ の import) | ○ |
| C-18 | Leader Election は client-go/tools/leaderelection を使用 | E-03 (import k8s.io/client-go/tools/leaderelection) | ○ |
| C-19 | Feature Gate 機構で新機能を段階的に有効化 | E-02 (import utilfeature, featuregate), E-04 (import features) | ○ |
| C-20 | API バージョニングで Alpha/Beta/GA の成熟プロセスを持つ | E-15 (registry 配下に各バージョンのディレクトリ), E-21 | ○ |
| C-21 | OWNERS ファイルでコードレビュー責任範囲を管理 | E-06, E-14 (各ディレクトリに OWNERS ファイル) | ○ |
| C-22 | vendor/ による依存管理を採用 | E-01 (go.mod), vendor/ ディレクトリの存在 | ○ |
| C-23 | go.work による Go Workspace 機能を使用 | go.work ファイルの存在（トップレベルディレクトリ一覧で確認） | ○ |
| C-24 | 認証方式: X.509, Bearer Token, OIDC, ServiceAccount Token | E-09 (authentication/ 配下: authenticator, token, serviceaccount) | ○ |
| C-25 | 認可方式: RBAC, Node, Webhook | E-10 (authorization/ 配下: authorizer, authorizerfactory, path, union) | ○ |
| C-26 | Audit ログ機能が存在 | E-11, E-20 (apiserver/pkg/admission/audit.go, endpoints/audit_test.go) | ○ |
| C-27 | 楽観的並行制御 (ResourceVersion) による競合制御 | E-08 (storage/api_object_versioner.go の存在) | ○ |
| C-28 | etcd の推奨サーバーバージョンは v3 系 | **根拠なし** (etcd3 クライアントの使用は確認できるが、具体的な推奨サーバーバージョンはコードに明示されていない) | △ |
| C-29 | 対応 Container Runtime は containerd, CRI-O 等 | **根拠なし** (CRI インターフェース定義は確認できるが、具体的対応ランタイム一覧はコードから特定困難) | △ |
| C-30 | Cloud Provider として主要クラウドに対応 | **根拠なし** (cloud-provider インターフェースは確認できるが、具体的対応クラウド一覧はコードから限定的) | △ |

## 4) 不足情報（Unknown / Missing）
- etcd サーバーの推奨バージョン情報がコード内に明示されていない
  - 候補：公式ドキュメント / CHANGELOG.md / リリースノート
- 対応 Container Runtime の具体的バージョン一覧がコードから特定できない
  - 候補：公式ドキュメント / CRI バージョン互換性マトリクス / リリースノート
- Cloud Provider の対応一覧が in-tree コードからは確認困難（out-of-tree 化が進行中）
  - 候補：公式ドキュメント / cloud-provider リポジトリ / SIG Cloud Provider 資料

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アーキテクチャスタイル、レイヤー構成、モジュール構成はコード構造から直接確認可能
- 0: 低リスク - 依存ライブラリとバージョンは go.mod から正確に取得
- 1: 中リスク - etcd/CRI/Cloud Provider の具体的バージョン・対応一覧は公式ドキュメントとの照合が必要
- 0: 低リスク - 認証・認可方式はコードのパッケージ構成から確認可能
- 1: 中リスク - データフローの記述は概念的な部分を含むため、実装詳細との差異がありうる

## 6) レビュアーチェックリスト（最小）
- [ ] 主要コンポーネント（apiserver, controller-manager, scheduler, kubelet, proxy）の責務記述が正確か
- [ ] レイヤー構成とパッケージの対応が実際のコード構造と一致するか
- [ ] 外部連携（etcd, CRI, CSI, CNI, Cloud Provider）のインターフェース記述が正確か
- [ ] 認証・認可方式の記述がプロジェクトの最新状態と合致するか
- [ ] 依存ライブラリのバージョンが go.mod の内容と一致するか
- [ ] データフローの記述が実際のリクエスト処理パスと整合するか
- [ ] Mermaid 構成図の各コンポーネント間の矢印（通信方向・プロトコル）が正確か
