# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "Control Plane"
        APISERVER["kube-apiserver<br/>(REST API / Admission / AuthN・AuthZ)"]
        ETCD["etcd<br/>(分散KVS)"]
        CM["kube-controller-manager<br/>(Reconciliation Controllers)"]
        SCHED["kube-scheduler<br/>(Pod Scheduling)"]
        CCM["cloud-controller-manager<br/>(Cloud Provider Integration)"]
    end

    subgraph "Node"
        KUBELET["kubelet<br/>(Node Agent)"]
        PROXY["kube-proxy<br/>(Service Proxy)"]
        CRT["Container Runtime<br/>(containerd / CRI-O)"]
        POD["Pods / Containers"]
    end

    subgraph "External"
        USER["kubectl / Client"]
        CLOUD["Cloud Provider API"]
        OIDC["OIDC Provider"]
        WEBHOOK["Admission Webhook"]
        PROM["Prometheus"]
        AGGAPI["Aggregated API Server"]
    end

    USER -->|"REST API (HTTPS)"| APISERVER
    APISERVER -->|"gRPC"| ETCD
    CM -->|"client-go (Watch/Update)"| APISERVER
    SCHED -->|"client-go (Watch/Bind)"| APISERVER
    CCM -->|"client-go"| APISERVER
    CCM -->|"Cloud API"| CLOUD
    KUBELET -->|"client-go (Watch/Status)"| APISERVER
    KUBELET -->|"CRI (gRPC)"| CRT
    CRT --> POD
    PROXY -->|"client-go (Watch)"| APISERVER
    APISERVER -->|"HTTPS"| WEBHOOK
    APISERVER -->|"OIDC"| OIDC
    APISERVER -->|"API Aggregation"| AGGAPI
    PROM -->|"HTTP /metrics"| APISERVER
    PROM -->|"HTTP /metrics"| CM
    PROM -->|"HTTP /metrics"| SCHED
    PROM -->|"HTTP /metrics"| KUBELET
```

## kube-apiserver 内部構成図

```mermaid
graph TB
    subgraph "kube-apiserver"
        REQ["HTTP Request"]

        subgraph "Filter Chain"
            AUTHN["Authentication<br/>(X.509, Token, OIDC)"]
            AUTHZ["Authorization<br/>(RBAC, Node, Webhook)"]
            AUDIT["Audit Logging"]
        end

        subgraph "Admission Control"
            MUTATE["Mutating Admission<br/>(Webhook, Defaults)"]
            VALIDATE_OBJ["Object Validation"]
            VALIDATING["Validating Admission<br/>(Webhook, CEL Policy)"]
        end

        subgraph "Registry Layer"
            REG["Registry / Strategy<br/>(pkg/registry/)"]
        end

        subgraph "Storage Layer"
            CACHER["Cacher<br/>(In-memory Watch Cache)"]
            STORAGE["Storage Backend<br/>(etcd3 client)"]
        end

        RESP["HTTP Response"]
    end

    ETCD_EXT["etcd"]

    REQ --> AUTHN --> AUTHZ --> AUDIT --> MUTATE --> VALIDATE_OBJ --> VALIDATING --> REG --> CACHER --> STORAGE --> ETCD_EXT
    STORAGE --> RESP
```

## Controller Reconciliation Loop

```mermaid
graph LR
    subgraph "kube-apiserver"
        API["API Server<br/>(Watch API)"]
    end

    subgraph "Controller (e.g. Deployment Controller)"
        INF["SharedInformer<br/>(client-go)"]
        CACHE["Local Cache<br/>(Indexer)"]
        HANDLER["Event Handler<br/>(Add/Update/Delete)"]
        WQ["Work Queue<br/>(Rate Limited)"]
        WORKER["Worker Goroutine"]
        RECONCILE["Reconcile Logic"]
    end

    API -->|"Watch Stream"| INF
    INF -->|"Update"| CACHE
    INF -->|"Event"| HANDLER
    HANDLER -->|"Enqueue Key"| WQ
    WQ -->|"Dequeue"| WORKER
    WORKER --> RECONCILE
    RECONCILE -->|"API Call (Create/Update/Delete)"| API
    RECONCILE -->|"Read from"| CACHE
    RECONCILE -->|"Requeue on Error"| WQ
```

## パッケージ依存関係図

```mermaid
graph TB
    subgraph "cmd/ (Entrypoints)"
        CMD_API["cmd/kube-apiserver"]
        CMD_CM["cmd/kube-controller-manager"]
        CMD_SCHED["cmd/kube-scheduler"]
        CMD_KUBELET["cmd/kubelet"]
        CMD_PROXY["cmd/kube-proxy"]
        CMD_KUBECTL["cmd/kubectl"]
    end

    subgraph "pkg/ (Core Implementation)"
        PKG_CP["pkg/controlplane"]
        PKG_REG["pkg/registry"]
        PKG_CTRL["pkg/controller"]
        PKG_SCHED["pkg/scheduler"]
        PKG_KUBELET["pkg/kubelet"]
        PKG_PROXY["pkg/proxy"]
        PKG_VOL["pkg/volume"]
    end

    subgraph "staging/src/k8s.io/ (Shared Libraries)"
        STG_API["api<br/>(API Types)"]
        STG_MACH["apimachinery<br/>(Schema, Serialization)"]
        STG_APISRV["apiserver<br/>(Generic API Server)"]
        STG_CLIENT["client-go<br/>(Informer, REST Client)"]
        STG_COMPBASE["component-base<br/>(CLI, Feature Gates, Metrics)"]
        STG_CRI["cri-api<br/>(Container Runtime Interface)"]
    end

    CMD_API --> PKG_CP
    CMD_API --> PKG_REG
    CMD_CM --> PKG_CTRL
    CMD_SCHED --> PKG_SCHED
    CMD_KUBELET --> PKG_KUBELET
    CMD_PROXY --> PKG_PROXY
    CMD_KUBECTL --> STG_CLIENT

    PKG_CP --> STG_APISRV
    PKG_REG --> STG_APISRV
    PKG_CTRL --> STG_CLIENT
    PKG_SCHED --> STG_CLIENT
    PKG_KUBELET --> STG_CLIENT
    PKG_KUBELET --> STG_CRI
    PKG_KUBELET --> PKG_VOL
    PKG_PROXY --> STG_CLIENT

    STG_APISRV --> STG_MACH
    STG_APISRV --> STG_API
    STG_CLIENT --> STG_MACH
    STG_CLIENT --> STG_API
    STG_MACH --> STG_API

    PKG_CP --> STG_COMPBASE
    PKG_CTRL --> STG_COMPBASE
    PKG_SCHED --> STG_COMPBASE
    PKG_KUBELET --> STG_COMPBASE
```

## Scheduler 内部構成図

```mermaid
graph TB
    subgraph "kube-scheduler"
        subgraph "Backend"
            QUEUE["Scheduling Queue<br/>(ActiveQ / BackoffQ / UnschedulableQ)"]
            SCACHE["Scheduler Cache<br/>(Node/Pod Snapshot)"]
        end

        subgraph "Framework"
            PROFILE["Scheduling Profile"]
            subgraph "Extension Points"
                PREFILTER["PreFilter"]
                FILTER["Filter"]
                PRESCORE["PreScore"]
                SCORE["Score"]
                RESERVE["Reserve"]
                BIND["Bind"]
            end
            PLUGINS["Plugins<br/>(NodeResources, NodeAffinity,<br/>PodTopologySpread, etc.)"]
        end

        SCHEDONE["schedule_one.go<br/>(Main Scheduling Loop)"]
    end

    APISVR["kube-apiserver"]

    APISVR -->|"Watch Pods/Nodes"| QUEUE
    APISVR -->|"Watch"| SCACHE
    QUEUE -->|"Pop Pod"| SCHEDONE
    SCHEDONE --> PREFILTER --> FILTER --> PRESCORE --> SCORE --> RESERVE --> BIND
    PLUGINS -.->|"implements"| PREFILTER
    PLUGINS -.->|"implements"| FILTER
    PLUGINS -.->|"implements"| SCORE
    PLUGINS -.->|"implements"| BIND
    BIND -->|"Bind API Call"| APISVR
    SCHEDONE -->|"Read Snapshot"| SCACHE
```
