---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **バックアップ設計の頻度・保持期間**：運用ポリシーに依存しコードから特定不可
  2. **Cluster Autoscalerの具体的パラメータ**：manifestテンプレートのみ存在し詳細設定が不明
  3. **OIDC連携の具体的接続方式**：go.modの依存関係から推定のみ
  4. **Fluentd GPCの具体バージョン**：テンプレート変数のため実値が不明
  5. **マスターノードの具体的マシンタイプ**：関数による動的算出のため固定値不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cluster/gce/config-default.sh` - GCEクラスタのデフォルト構成定義
- E-02: `cluster/gce/manifests/kube-apiserver.manifest` - kube-apiserver Static Podマニフェスト
- E-03: `cluster/gce/manifests/etcd.manifest` - etcd Static Podマニフェスト
- E-04: `cluster/gce/manifests/kube-controller-manager.manifest` - kube-controller-managerマニフェスト
- E-05: `cluster/gce/manifests/kube-scheduler.manifest` - kube-schedulerマニフェスト
- E-06: `cluster/gce/manifests/kube-proxy.manifest` - kube-proxyマニフェスト
- E-07: `cluster/gce/manifests/konnectivity-server.yaml` - Konnectivity Serverマニフェスト
- E-08: `cluster/addons/calico-policy-controller/calico-node-daemonset.yaml` - Calico Node DaemonSet
- E-09: `cluster/addons/dns/nodelocaldns/nodelocaldns.yaml` - NodeLocal DNS DaemonSet
- E-10: `cluster/addons/metrics-server/metrics-server-deployment.yaml` - Metrics Server Deployment
- E-11: `cluster/addons/fluentd-gcp/fluentd-gcp-ds.yaml` - Fluentd GCP DaemonSet
- E-12: `cluster/addons/storage-class/gce/default.yaml` - GCE StorageClass定義
- E-13: `cluster/images/etcd-version-monitor/etcd-version-monitor.yaml` - etcd監視Pod
- E-14: `build/server-image/Dockerfile` - サーバーイメージビルド定義
- E-15: `build/server-image/kube-apiserver/Dockerfile` - kube-apiserver固有Dockerfile
- E-16: `build/pause/Dockerfile` - pauseコンテナDockerfile
- E-17: `go.mod` - Goモジュール定義（依存関係）
- E-18: `cluster/addons/calico-policy-controller/typha-deployment.yaml` - Calico Typha定義
- E-19: `cluster/addons/calico-policy-controller/typha-horizontal-autoscaler-deployment.yaml` - Typha HPA
- E-20: `cluster/addons/dns-horizontal-autoscaler/dns-horizontal-autoscaler.yaml` - DNS HPA
- E-21: `cluster/addons/ip-masq-agent/ip-masq-agent.yaml` - IP Masquerade Agent
- E-22: `cluster/addons/fluentd-gcp/event-exporter.yaml` - Event Exporter
- E-23: `cluster/gce/manifests/cluster-autoscaler.manifest` - Cluster Autoscaler

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトノード数は3台（NUM_NODES=3） | E-01 | ○ |
| C-02 | ワーカーノードのマシンタイプはe2-standard-2 | E-01 | ○ |
| C-03 | マスターノードのディスクタイプはpd-ssd | E-01 | ○ |
| C-04 | ワーカーノードのディスクタイプはpd-standard 100GB | E-01 | ○ |
| C-05 | Windowsノードのデフォルト数は0 | E-01 | ○ |
| C-06 | SERVICE_CLUSTER_IP_RANGEは10.0.0.0/16 | E-01 | ○ |
| C-07 | MASTER_IP_RANGEは10.246.0.0/24 | E-01 | ○ |
| C-08 | etcdバージョンは3.6.7 | E-03 | ○ |
| C-09 | containerdバージョンはv2.1.4（Ubuntu） | E-01 | ○ |
| C-10 | runcバージョンはv1.3.2（Ubuntu） | E-01 | ○ |
| C-11 | Calicoバージョンはv3.19.1 | E-08 | ○ |
| C-12 | NodeLocal DNSバージョンは1.26.7 | E-09 | ○ |
| C-13 | Metrics Serverバージョンはv0.8.0 | E-10 | ○ |
| C-14 | addon-resizerバージョンは1.8.20 | E-10 | ○ |
| C-15 | Konnectivity Serverバージョンはv0.34.0 | E-07 | ○ |
| C-16 | Go言語バージョンは1.25.0 | E-17 | ○ |
| C-17 | kube-apiserverはcap_net_bind_serviceを付与 | E-15 | ○ |
| C-18 | pauseコンテナはUID:65535で実行 | E-16 | ○ |
| C-19 | 全Control PlaneコンポーネントでseccompProfile: RuntimeDefault | E-02, E-03, E-04, E-05 | ○ |
| C-20 | kube-controller-managerのprivilegeEscalation: false | E-04 | ○ |
| C-21 | kube-schedulerのprivilegeEscalation: false | E-05 | ○ |
| C-22 | Metrics Serverのメトリクス解像度は15秒 | E-10 | ○ |
| C-23 | Calico NodeでPrometheusメトリクスが有効 | E-08 | ○ |
| C-24 | NodeLocal DNSのPrometheusポートは9253 | E-09 | ○ |
| C-25 | etcd SNAPSHOT_COUNTは10000 | E-03 | ○ |
| C-26 | GCEデフォルトStorageClassはpd-standard | E-12 | ○ |
| C-27 | L7ロードバランシングはglbc | E-01 | ○ |
| C-28 | OSイメージファミリーはcos-125-lts | E-01 | ○ |
| C-29 | Calico CNI設定名は10-calico.conflist | E-08 | ○ |
| C-30 | etcd-version-monitorのバージョンは0.1.3 | E-13 | ○ |
| C-31 | マスターノードの具体的マシンタイプ（e2-standard-N） | E-01 | △ |
| C-32 | バックアップの頻度と保持期間 | **根拠なし** | △ |
| C-33 | Cluster Autoscalerの具体的パラメータ | E-23 | △ |
| C-34 | FluentdのStackdriver連携バージョン | E-11 | △ |
| C-35 | OIDC Providerの具体的接続方式 | E-17 | △ |

## 4) 不足情報（Unknown / Missing）
- **バックアップ設計の運用パラメータ**: etcdスナップショットの定期的なバックアップ頻度・保持期間はコードからは特定できない。運用マニュアルや別途の設定ドキュメントが必要。
  - 候補：運用手順書 / Helmチャートのvalues.yaml / 外部バックアップツール設定
- **Cluster Autoscalerの詳細設定**: manifestファイルはテンプレート形式であり、最小/最大ノード数等の具体的パラメータが不明。
  - 候補：デプロイ時の環境変数設定 / GKE設定 / Terraform変数
- **OIDC Provider設定**: go.modにcoreos/go-oidc依存が存在するが、具体的なIdP接続設定はコードからは不明。
  - 候補：kube-apiserver起動パラメータ / 認証設定ファイル
- **Fluentdバージョン**: テンプレート変数（`{{ fluentd_gcp_version }}`）のため実値が不明。
  - 候補：デプロイスクリプト / 環境変数定義
- **マスターノードのマシンサイズ**: `get-master-size` 関数による動的算出のため、ノード数に依存した可変値。
  - 候補：config-common.sh内の関数定義

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: バックアップ設計が「運用ポリシーによる」となっており、障害復旧計画の具体性が不足している。etcdデータの定期バックアップ方式を明確にすべき。
- **リスク1（中）**: テンプレート変数（Jinja2 / Pillar）が多く含まれるため、実際のデプロイ時のパラメータ値が設計書と乖離する可能性がある。
- **リスク1（中）**: Calico v3.19.1は比較的古いバージョンである可能性があり、セキュリティパッチの適用状況を確認すべき。
- **リスク0（低）**: GCE固有の構成が中心であり、他のクラウドプロバイダーやオンプレミス環境向けの設計は本書の範囲外としている。

## 6) レビュアーチェックリスト（最小）
- [ ] etcdのバックアップ方式・頻度・保持期間が運用要件を満たしているか確認
- [ ] テンプレート変数（`{{ }}`、`__PILLAR__`）の実際の展開値を確認
- [ ] Cluster Autoscalerの最小/最大ノード数が要件に合致しているか確認
- [ ] Calicoバージョン（v3.19.1）のセキュリティアドバイザリを確認
- [ ] マスターノードのマシンサイズがワークロード規模に適切か確認
- [ ] Fluentd / Stackdriver連携の実バージョンおよびログ保持期間を確認
- [ ] OIDC Provider設定が認証要件を満たしているか確認
- [ ] Windows Nodeサポートが必要な場合、その構成が適切か確認
