# インフラ構成図

## クラスタ全体構成図

```mermaid
graph TB
    subgraph "External Services"
        GCE["Google Compute Engine<br/>(IaaS)"]
        GCS["Google Cloud Storage"]
        STACKDRIVER_LOG["Stackdriver Logging"]
        STACKDRIVER_MON["Stackdriver Monitoring"]
        REGISTRY["Container Registry<br/>(registry.k8s.io / gcr.io)"]
        KMS["KMS Provider"]
    end

    subgraph "Kubernetes Cluster"
        subgraph "Control Plane (Master Node)"
            direction TB
            APISERVER["kube-apiserver<br/>:443 (HTTPS)"]
            ETCD["etcd<br/>v3.6.7<br/>(pd-ssd)"]
            CONTROLLER["kube-controller-manager<br/>:10257"]
            SCHEDULER["kube-scheduler<br/>:10259"]
            KONNECTIVITY["konnectivity-server<br/>(network proxy)"]
            CCM["cloud-controller-manager"]
            ADDON_MGR["kube-addon-manager"]
        end

        subgraph "Worker Node 1..N (e2-standard-2)"
            direction TB
            KUBELET["kubelet"]
            KUBE_PROXY["kube-proxy"]
            CONTAINERD["containerd<br/>v2.1.4"]
            CALICO_NODE["calico-node<br/>v3.19.1<br/>(DaemonSet)"]
            NODE_DNS["node-local-dns<br/>v1.26.7<br/>(DaemonSet)"]
            FLUENTD["fluentd-gcp<br/>(DaemonSet)"]
            NPD["node-problem-detector<br/>(DaemonSet)"]
            PODS["Application Pods"]
        end

        subgraph "Cluster Addons (kube-system)"
            METRICS["metrics-server<br/>v0.8.0<br/>(Deployment)"]
            DNS_HPA["dns-horizontal-autoscaler"]
            CALICO_TYPHA["calico-typha<br/>(Deployment)"]
            CLUSTER_AS["cluster-autoscaler"]
            GLBC["GCE L7 LB Controller<br/>(glbc)"]
            IP_MASQ["ip-masq-agent<br/>(DaemonSet)"]
            ETCD_MON["etcd-version-monitor"]
        end
    end

    APISERVER --> ETCD
    CONTROLLER --> APISERVER
    SCHEDULER --> APISERVER
    KONNECTIVITY --> APISERVER
    CCM --> APISERVER
    CCM --> GCE

    KUBELET --> APISERVER
    KUBE_PROXY --> APISERVER
    KUBELET --> CONTAINERD
    CONTAINERD --> PODS
    CALICO_NODE --> CALICO_TYPHA

    METRICS --> KUBELET
    CLUSTER_AS --> GCE
    GLBC --> GCE

    FLUENTD --> STACKDRIVER_LOG
    NPD --> APISERVER
    ETCD_MON --> ETCD

    APISERVER --> KMS
    CONTAINERD --> REGISTRY
    KUBELET --> GCS
```

## Control Plane コンポーネント詳細

```mermaid
graph LR
    subgraph "Master Node (e2-standard-N, pd-ssd)"
        APISERVER["kube-apiserver<br/>hostNetwork: true<br/>priority: 2000001000<br/>seccomp: RuntimeDefault<br/>cap: net_bind_service"]
        ETCD_MAIN["etcd<br/>(main)<br/>data: /var/etcd/data<br/>snapshot_count: 10000"]
        ETCD_EVENTS["etcd<br/>(events)"]
        CM["kube-controller-manager<br/>hostNetwork: true<br/>privilegeEscalation: false<br/>capabilities: drop all"]
        SCHED["kube-scheduler<br/>hostNetwork: true<br/>privilegeEscalation: false<br/>capabilities: drop all"]
        KONN["konnectivity-server<br/>v0.34.0"]
    end

    APISERVER -- "TLS" --> ETCD_MAIN
    APISERVER -- "TLS" --> ETCD_EVENTS
    CM -- "HTTPS :10257" --> APISERVER
    SCHED -- "HTTPS :10259" --> APISERVER
    KONN -- "agent port" --> APISERVER
```

## ネットワーク構成図

```mermaid
graph TB
    subgraph "Network Architecture"
        subgraph "External"
            INTERNET["Internet"]
            LB["GCE L7 Load Balancer<br/>(Ingress)"]
        end

        subgraph "Node Network"
            MASTER_NET["Master IP Range<br/>10.246.0.0/24"]
            NODE_NET["Node IP Range<br/>(IP Aliases)"]
        end

        subgraph "Cluster Network (Overlay)"
            POD_NET["Pod CIDR<br/>(CLUSTER_IP_RANGE)"]
            SVC_NET["Service CIDR<br/>10.0.0.0/16"]
        end

        subgraph "CNI: Calico"
            CALICO["calico-node (DaemonSet)<br/>IPAM: host-local<br/>Backend: none (policy only)<br/>Felix + Typha"]
        end

        subgraph "DNS"
            COREDNS["CoreDNS / kube-dns"]
            NODE_CACHE["NodeLocal DNSCache<br/>:53 UDP/TCP<br/>:9253 metrics"]
        end

        subgraph "Proxy"
            KPROXY["kube-proxy<br/>iptables/ipvs"]
            MASQ["ip-masq-agent<br/>(SNAT)"]
        end
    end

    INTERNET --> LB
    LB --> NODE_NET
    NODE_NET --> KPROXY
    KPROXY --> POD_NET
    KPROXY --> SVC_NET
    POD_NET --- CALICO
    NODE_CACHE --> COREDNS
    MASQ --> NODE_NET
```

## 監視・ログ構成図

```mermaid
graph LR
    subgraph "Monitoring & Logging"
        subgraph "Metrics"
            METRICS_SRV["metrics-server v0.8.0<br/>resolution: 15s<br/>:10250 HTTPS"]
            PROM_CALICO["Calico Prometheus<br/>Felix metrics"]
            PROM_DNS["NodeLocal DNS<br/>:9253"]
            ETCD_MON2["etcd-version-monitor"]
        end

        subgraph "Logging"
            FLUENTD2["fluentd-gcp<br/>(DaemonSet)<br/>/var/log<br/>/var/lib/docker/containers"]
            EVENT_EXP["event-exporter"]
            METADATA["metadata-agent<br/>(Stackdriver)"]
        end

        subgraph "Health"
            NPD2["node-problem-detector"]
        end
    end

    KUBELET2["kubelet"] --> METRICS_SRV
    FLUENTD2 --> STACKDRIVER2["Stackdriver Logging"]
    EVENT_EXP --> STACKDRIVER2
    METADATA --> STACKDRIVER_MON2["Stackdriver Monitoring"]
    METRICS_SRV --> APISERVER2["kube-apiserver<br/>(metrics API)"]
```
