# インフラ設計書

## 概要

本ドキュメントは、Kubernetes（k8s.io/kubernetes）プロジェクトのインフラストラクチャ設計を記載する。本プロジェクトはコンテナオーケストレーションプラットフォームであり、Control Plane（マスター）とWorker Node群で構成されるクラスタアーキテクチャを採用している。主要なデプロイメント対象環境としてGoogle Compute Engine（GCE）が構成ファイルにより定義されている。

## システム構成

### 全体構成

Kubernetesクラスタは以下の2層で構成される。

1. **Control Plane（マスターノード）**: クラスタ全体の管理・制御を担当。kube-apiserver、kube-controller-manager、kube-scheduler、etcdが稼働する。
2. **Worker Node群**: コンテナワークロードの実行を担当。kubelet、kube-proxy、コンテナランタイム（containerd）が稼働する。

デフォルト構成では、1台のマスターノードと3台のワーカーノードで構成される（`NUM_NODES=3`）。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| マスターノード | Control Plane（API Server, Controller Manager, Scheduler, etcd） | e2-standard-{動的算出}（GCE）、ディスク: pd-ssd | 1（デフォルト） |
| ワーカーノード（Linux） | コンテナワークロードの実行 | e2-standard-2（GCE）、ディスク: pd-standard 100GB | 3（デフォルト、`NUM_NODES`で設定可能） |
| ワーカーノード（Windows） | Windowsコンテナワークロードの実行 | GCE、OS: Windows Server 2019 | 0（デフォルト、`NUM_WINDOWS_NODES`で設定可能） |

### ネットワーク構成

- **クラスタネットワーク**: `CLUSTER_IP_RANGE` で定義されるPod CIDR
- **サービスネットワーク**: `SERVICE_CLUSTER_IP_RANGE=10.0.0.0/16`
- **マスターIP範囲**: `MASTER_IP_RANGE=10.246.0.0/24`
- **ノードIP範囲**: IP Aliasesが有効な場合、サブネットのプライマリ範囲を使用
- **ネットワークプラグイン（CNI）**: Calico（v3.19.1）によるネットワークポリシー制御。CNI設定名: `10-calico.conflist`、IPAMタイプ: `host-local`（PodCIDR使用）
- **DNS**: NodeLocal DNSCache（k8s-dns-node-cache:1.26.7）をDaemonSetとして各ノードで実行。CoreDNSベースのCorefile設定でキャッシュを提供
- **L7ロードバランシング**: GCE L7 Load Balancer Controller（glbc）によるIngress処理
- **Konnectivity Server**: API ServerとNodeエージェント間のネットワークプロキシ（proxy-server:v0.34.0）
- **IP Masquerade**: ip-masq-agentによる送信元NATの管理

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| etcd | 3.6.7 | クラスタ状態の分散KVストア |
| containerd | v2.1.4（Ubuntu）/ OS同梱（COS） | コンテナランタイム |
| runc | v1.3.2（Ubuntu） | OCI準拠コンテナ実行ランタイム |
| CoreDNS / NodeLocal DNS | 1.26.7 | クラスタ内DNS解決・キャッシュ |
| Calico | v3.19.1（CNI + Node） | ネットワークポリシー・CNIプラグイン |
| Calico Typha | Typhaデプロイメント経由 | Calicoのスケーラビリティ向上コンポーネント |
| Metrics Server | v0.8.0 | リソースメトリクス収集 |
| addon-resizer | 1.8.20 | メトリクスサーバー等のリソース自動調整 |
| Fluentd (Stackdriver) | 構成テンプレートで定義 | ログ収集・Stackdriver連携 |
| konnectivity-server | v0.34.0 | API Server-Node間ネットワークプロキシ |
| Go言語 | 1.25.0 | ビルド言語 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Google Compute Engine（GCE） | IaaS基盤（VM、ディスク、ネットワーク） | gcloud CLI / GCE API（`https://www.googleapis.com/compute/v1/`） |
| Google Cloud Storage | ノードスコープ: `storage-ro` | GCEサービスアカウント |
| Stackdriver Logging | ログ収集・集約 | Fluentd DaemonSet + Metadata Agent経由 |
| Stackdriver Monitoring | メトリクス監視 | ノードスコープ: `monitoring` |
| Container Registry（registry.k8s.io, gcr.io） | コンテナイメージの取得 | HTTPS |
| OIDC Provider | 認証連携（coreos/go-oidc依存） | HTTPS |
| KMS Provider | 暗号化鍵管理（kms-provider対応） | UNIXソケット |

## スケーリング設計

### ノードスケーリング

- **Cluster Autoscaler**: GCE環境においてクラスタオートスケーラーが利用可能（`cluster/gce/manifests/cluster-autoscaler.manifest`）。ノード数を自動的に増減する。
- **ノード数設定**: `NUM_NODES` 環境変数により初期ノード数を指定（デフォルト: 3）。
- **追加ノードタイプ**: `NUM_ADDITIONAL_NODES` と `ADDITIONAL_MACHINE_TYPE` により異種ノードの追加が可能。

### コンポーネントスケーリング

- **Metrics Server**: addon-resizer（pod_nanny）によるVertical Pod Autoscaling。ノード数に応じてCPU/メモリを自動調整（`--extra-cpu=0.5m`、`--extra-memory` per node設定）。
- **DNS Horizontal Autoscaler**: `dns-horizontal-autoscaler` アドオンによりCoreDNS/kube-dnsレプリカ数を自動調整。
- **Calico Typha**: Horizontal Autoscaler（HPA）およびVertical Autoscalerの両方を利用してTyphaデプロイメントをスケーリング。
- **Calico Node**: Vertical Autoscalerによるリソース自動調整。

## 可用性設計

### Control Plane

- kube-apiserver、kube-controller-manager、kube-scheduler、etcdは全て `priorityClassName: system-node-critical`（priority: 2000001000）で実行され、最優先でスケジューリングされる。
- 各コンポーネントにliveness probeおよびreadiness probeが設定されており、障害検知と自動再起動が行われる。
  - kube-apiserver: HTTPS `/livez` および `/readyz`
  - kube-controller-manager: HTTPS `:10257/healthz`
  - kube-scheduler: HTTPS `:10259/healthz`
  - etcd: `etcdctl endpoint health` コマンドによるヘルスチェック

### Worker Node

- kube-proxyは全ノードで `system-node-critical` として実行。
- Calico NodeはDaemonSetとして全ノードに配置、全tolerationを設定して確実にスケジューリング。
- NodeLocal DNSCacheはDaemonSetで全ノードに配置、`system-node-critical` で実行。

### セキュリティコンテキスト

- 全Control Planeコンポーネントで `seccompProfile: RuntimeDefault` を適用。
- kube-controller-manager、kube-schedulerでは `allowPrivilegeEscalation: false` および `capabilities.drop: all` を設定。
- kube-apiserverには `cap_net_bind_service` のみ付与（1024番未満のポートバインド用）。
- pauseコンテナは非rootユーザー（UID:65535）で実行。

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| etcdデータ（`/var/etcd/data`） | etcdスナップショット（`ETCD_SNAPSHOT_COUNT=10000`イベントごと） | イベント駆動 | 構成による |
| マスターディスク | GCE Persistent Disk（pd-ssd）のスナップショット | 運用ポリシーによる | 運用ポリシーによる |

## 監視設計

### メトリクス収集

- **Metrics Server（v0.8.0）**: kubeletからリソースメトリクス（CPU/メモリ）を収集。15秒間隔（`--metric-resolution=15s`）。ポート10250でHTTPS提供。
- **Prometheus対応**: Calico NodeおよびNodeLocal DNSCacheがPrometheusメトリクスエンドポイントを公開。
  - Calico Node: `FELIX_PROMETHEUSMETRICSENABLED=true`
  - NodeLocal DNS: `:9253` でPrometheusメトリクス提供（`prometheus.io/scrape: "true"`）
- **etcd Version Monitor**: etcdのバージョン情報を監視するPod（`etcd-version-monitor:0.1.3`）。

### ログ収集

- **Fluentd GCP**: DaemonSetとして全ノードに配置。`/var/log` および `/var/lib/docker/containers` からログを収集し、Stackdriver Loggingに転送。
- **Event Exporter**: Kubernetesイベントの外部転送用コンポーネント。

### ヘルスチェック

- 全主要コンポーネントにliveness probe / readiness probeを設定（前述の可用性設計を参照）。
- Node Problem Detector: ノードレベルの問題検出デーモン。

## 備考

- 本プロジェクトはKubernetesそのもののソースコードリポジトリであり、特定のアプリケーションをデプロイするためのインフラではなく、コンテナオーケストレーション基盤そのものである。
- GCE向けの構成が最も詳細に定義されているが、kubeadmによるオンプレミスやその他クラウド環境へのデプロイもサポートされている。
- 構成ファイルの多くはテンプレート変数（`{{ }}`、`__PILLAR__`）を含んでおり、デプロイ時に実際の値に置換される。
- OSイメージはContainer-Optimized OS（cos/gci、`cos-125-lts`ファミリー）がデフォルトで使用される。
- マルチアーキテクチャ対応: Dockerfileで`BUILDARCH`/`TARGETARCH`によるクロスプラットフォームビルドが行われる。
- Windows Nodeのサポート: 一部コンポーネント（kube-proxy、busybox、nginx等）にWindows向けDockerfile（`Dockerfile_windows`）が存在する。
