---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **CORS 設定のデフォルト値**：ソースコード上で `--cors-allowed-origins` のデフォルト値を直接確認できていない
  2. **ServiceAccount バインドトークンの有効期限仕様**：TokenRequest API の詳細実装は本解析スコープ外
  3. **NetworkPolicy の詳細仕様**：CNI プラグイン依存の実装であり、コアコードからの確認が限定的
  4. **HSTS ヘッダ設定**：API サーバの HSTS ヘッダ設定に関する明示的なコードを確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/apiserver/pkg/authentication/authenticatorfactory/delegating.go` - 認証チェーン構成
- E-02: `staging/src/k8s.io/apiserver/pkg/authentication/authenticator/interfaces.go` - 認証インターフェース定義
- E-03: `staging/src/k8s.io/apiserver/pkg/authorization/authorizer/interfaces.go` - 認可インターフェース・Decision 定義
- E-04: `plugin/pkg/auth/authorizer/rbac/rbac.go` - RBAC 認可実装
- E-05: `staging/src/k8s.io/apiserver/pkg/server/options/authentication.go` - 認証オプション・Webhook リトライ設定
- E-06: `staging/src/k8s.io/apiserver/pkg/server/options/serving.go` - TLS/HTTPS サーバ設定
- E-07: `staging/src/k8s.io/apiserver/pkg/server/options/encryptionconfig/config.go` - 暗号化プロバイダ設定
- E-08: `staging/src/k8s.io/apiserver/pkg/audit/types.go` - 監査 Sink/Backend インターフェース
- E-09: `staging/src/k8s.io/apiserver/pkg/apis/audit/types.go` - 監査レベル・ステージ定義
- E-10: `staging/src/k8s.io/apiserver/pkg/audit/request.go` - 監査イベント記録内容
- E-11: `staging/src/k8s.io/apiserver/pkg/audit/policy/checker.go` - 監査ポリシー評価
- E-12: `staging/src/k8s.io/apiserver/pkg/server/options/audit.go` - 監査バックエンド・バッチ設定
- E-13: `staging/src/k8s.io/apiserver/pkg/admission/interfaces.go` - Admission Controller インターフェース
- E-14: `staging/src/k8s.io/apiserver/pkg/admission/plugin/` - Admission プラグイン一覧（cel, namespace, policy, resourcequota, webhook）
- E-15: `staging/src/k8s.io/pod-security-admission/policy/` - Pod Security Admission チェック一覧
- E-16: `staging/src/k8s.io/apiserver/pkg/authentication/serviceaccount/util.go` - ServiceAccount トークン検証
- E-17: `staging/src/k8s.io/apiserver/pkg/server/options/authorization.go` - 認可オプション（AlwaysAllowPaths, AlwaysAllowGroups）
- E-18: `plugin/pkg/auth/authorizer/node/` - Node 認可プラグイン

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証チェーンは unionauth.New() で連結され複数方式を同時有効化できる | E-01 | ○ |
| C-02 | 認証順序: Front Proxy -> X.509 -> Bearer Token -> Anonymous | E-01 | ○ |
| C-03 | X.509 クライアント証明書認証で CommonName をユーザ名として抽出 | E-01 (x509.CommonNameUserConversion) | ○ |
| C-04 | Bearer Token は Webhook 経由で TokenReview API を使用 | E-01, E-05 | ○ |
| C-05 | トークンキャッシュは cache.New() で CacheTTL に基づき設定 | E-01 | ○ |
| C-06 | Webhook リトライのデフォルト: Duration 500ms, Factor 1.5, Jitter 0.2, Steps 5 | E-05 | ○ |
| C-07 | Front Proxy 認証は X-Remote-User, X-Remote-Group, X-Remote-Extra- ヘッダを使用 | E-01, E-05 | ○ |
| C-08 | Anonymous 認証は条件付きで有効化可能 | E-01 (AnonymousAuthConfig.Conditions) | ○ |
| C-09 | API サーバはステートレスでリクエストごとに認証を行う | E-01, E-02 | ○ |
| C-10 | RBAC は Role, ClusterRole, RoleBinding, ClusterRoleBinding の4種で構成 | E-04 | ○ |
| C-11 | 認可判定は DecisionAllow, DecisionDeny, DecisionNoOpinion の3値 | E-03 | ○ |
| C-12 | RBAC 認可は Verb, APIGroup, Resource, ResourceName でマッチング | E-04 | ○ |
| C-13 | Node 認可プラグインにより kubelet のアクセスを制限 | E-18 | ○ |
| C-14 | AlwaysAllowPaths, AlwaysAllowGroups で認可スキップが可能 | E-17 | ○ |
| C-15 | API サーバは SecureServingOptions により TLS 必須 | E-06 | ○ |
| C-16 | MinTLSVersion で最小 TLS バージョンを指定可能 | E-06 | ○ |
| C-17 | CipherSuites で暗号スイートを制限可能 | E-06 | ○ |
| C-18 | HTTP/2 の無効化とストリーム数制限が可能 | E-06 | ○ |
| C-19 | SNI 対応の複数証明書設定が可能 | E-06 (SNICertKeys) | ○ |
| C-20 | etcd 保存データの暗号化プロバイダ: AES-CBC, AES-GCM, Secretbox, KMS v1, KMS v2, Identity | E-07 | ○ |
| C-21 | KMS v2 の DEK/Seed 最大 TTL は 3分 | E-07 | ○ |
| C-22 | Admission Controller は ValidationInterface と MutationInterface で構成 | E-13 | ○ |
| C-23 | Pod Security Admission は Privileged, Baseline, Restricted の3レベル | E-15 | ○ |
| C-24 | CEL ベースのカスタムバリデーションが利用可能 | E-14 | ○ |
| C-25 | 監査レベルは None, Metadata, Request, RequestResponse の4段階 | E-09 | ○ |
| C-26 | 監査バックエンドのバッチ設定: バッファ10000, バッチ400, 間隔30秒, 10 QPS | E-12 | ○ |
| C-27 | CORS は --cors-allowed-origins で設定可能 | **根拠なし** | △ |
| C-28 | ServiceAccount バインドトークンの時間制限付き発行 | **根拠なし** | △ |
| C-29 | HSTS ヘッダの設定 | **根拠なし** | △ |
| C-30 | NetworkPolicy によるPod間通信制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: CORS 設定はコマンドラインフラグとして知られているが、本解析で参照したソースコード範囲内で明示的な実装箇所を確認できなかった
  - 候補: `cmd/kube-apiserver/app/` / `staging/src/k8s.io/apiserver/pkg/server/config.go` / `staging/src/k8s.io/apiserver/pkg/server/filters/`
- C-28: ServiceAccount のバインドトークン（ProjectedVolume）の詳細実装は TokenRequest API のコントローラ側にある
  - 候補: `pkg/controller/serviceaccount/` / `staging/src/k8s.io/apiserver/pkg/authentication/token/` / `pkg/serviceaccount/`
- C-29: HSTS ヘッダに関する明示的な設定コードが見当たらなかった。API サーバの HTTP フィルタチェーンを確認する必要がある
  - 候補: `staging/src/k8s.io/apiserver/pkg/server/filters/` / `staging/src/k8s.io/apiserver/pkg/server/config.go`
- C-30: NetworkPolicy はリソース定義であり、実際の enforcement は CNI プラグイン（Calico, Cilium 等）に依存する
  - 候補: `staging/src/k8s.io/api/networking/v1/types.go` / CNI プラグインのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: **暗号化プロバイダの設定**：AES-CBC, AES-GCM, Secretbox, KMS v1/v2 の各プロバイダはソースコードで確認済み。低リスク
- 0: **RBAC 認可**：PolicyRule マッチングロジックはソースコードで確認済み。低リスク
- 0: **認証チェーン**：構成順序と各認証方式はソースコードで確認済み。低リスク
- 1: **CORS / HSTS**：Web セキュリティヘッダの設定に関する根拠が不足。API サーバが直接ブラウザからアクセスされるケースでの影響を確認する必要がある。中リスク
- 1: **ServiceAccount トークンの有効期限管理**：バインドトークンの詳細な有効期限設定の根拠が不足。中リスク
- 0: **監査ログ**：監査レベル、バックエンド、バッチ設定はソースコードで確認済み。低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 認証チェーンの構成順序が運用環境の要件と一致しているか確認
- [ ] RBAC の権限体系（Role, ClusterRole, RoleBinding, ClusterRoleBinding）の説明が実際の運用と整合しているか確認
- [ ] etcd 暗号化プロバイダの一覧と各プレフィックスがソースコードと一致しているか確認
- [ ] CORS / HSTS に関する記述が不足していないか、`staging/src/k8s.io/apiserver/pkg/server/filters/` を別途確認
- [ ] ServiceAccount トークンのバインドトークン仕様について `pkg/serviceaccount/` を別途確認
- [ ] 監査ログのバッチ設定デフォルト値がソースコードと一致しているか確認
- [ ] Pod Security Admission の3レベル（Privileged, Baseline, Restricted）が正しく記載されているか確認
- [ ] NetworkPolicy の記述が CNI プラグイン依存である旨が適切に記載されているか確認
