---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **Prowによるpresubmit/postsubmitジョブの具体的な構成**：Prowの設定ファイルがリポジトリ外（k8s.io/test-infra）にあるため根拠不足
  2. **カバレッジ目標値の不在確認**：明示的な目標値がないという主張の裏付けが間接的
  3. **適合性テストのAPI仕様全カバー**：ゴールデンリストの内容は確認したが網羅性の判定は外部情報に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `go.mod`（Go バージョン、依存ライブラリ定義）
- E-02: `Makefile`（テスト実行ターゲット定義）
- E-03: `hack/make-rules/test.sh`（単体テスト実行スクリプト）
- E-04: `hack/make-rules/test-integration.sh`（結合テスト実行スクリプト）
- E-05: `hack/ginkgo-e2e.sh`（E2Eテスト実行スクリプト）
- E-06: `test/e2e/e2e.go`（E2Eテストエントリポイント）
- E-07: `test/` ディレクトリ構成（e2e, e2e_node, e2e_kubeadm, e2e_dra, integration, fuzz, conformance 等）
- E-08: `test/conformance/README.md`（適合性テスト管理の説明）
- E-09: `test/e2e/framework/`（E2Eテストフレームワーク構成）
- E-10: `hack/verify-*.sh`（49種類の静的解析・検証スクリプト）
- E-11: `test/fuzz/`（cbor, json, yaml ファジングテスト）
- E-12: `.github/ISSUE_TEMPLATE/`（イシューテンプレート）
- E-13: `hack/install-etcd.sh`（etcdインストールスクリプト）
- E-14: `hack/local-up-cluster.sh`（ローカルクラスタ起動スクリプト）
- E-15: `hack/benchmark-go.sh`（ベンチマークスクリプト）
- E-16: `test/e2e/testing-manifests/`（テスト用マニフェスト）
- E-17: `test/fixtures/`（テストフィクスチャ）
- E-18: `hack/e2e-internal/`（E2E内部スクリプト群）
- E-19: `pkg/**/*_test.go`（パッケージ単体テストファイル群）
- E-20: `hack/golangci.yaml`（golangci-lint設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Go 1.25.0で実装されている | E-01 | ○ |
| C-02 | 単体テストは pkg/, cmd/, staging/ 配下の *_test.go で実施 | E-03, E-19 | ○ |
| C-03 | 結合テストは test/integration/ に配置 | E-04, E-07 | ○ |
| C-04 | E2Eテストは test/e2e/ にGinkgo/Gomegaで実装 | E-06, E-07 | ○ |
| C-05 | ノードE2Eテストは test/e2e_node/ に配置 | E-02, E-07 | ○ |
| C-06 | 適合性テストは test/conformance/ で管理 | E-08 | ○ |
| C-07 | kubeadm E2Eテストは test/e2e_kubeadm/ に配置 | E-07 | ○ |
| C-08 | DRA E2Eテストは test/e2e_dra/ に配置 | E-07 | ○ |
| C-09 | ファズテストは test/fuzz/ にCBOR/JSON/YAML形式で配置 | E-11 | ○ |
| C-10 | hack/verify-*.sh が49種類存在 | E-10 | ○ |
| C-11 | Ginkgo v2.27.4を使用 | E-01 | ○ |
| C-12 | Gomega v1.39.0を使用 | E-01 | ○ |
| C-13 | google/go-cmp v0.7.0を使用 | E-01 | ○ |
| C-14 | etcdを結合テストで使用 | E-04, E-13 | ○ |
| C-15 | KUBE_COVER=y でカバレッジ収集を有効化 | E-03 | ○ |
| C-16 | KUBE_COVERMODE=atomic がデフォルト | E-03 | ○ |
| C-17 | 明示的なカバレッジ数値目標は設定されていない | E-03 | △ |
| C-18 | テスト用マニフェストは test/e2e/testing-manifests/ に配置 | E-16 | ○ |
| C-19 | フィクスチャは test/fixtures/ に配置 | E-17 | ○ |
| C-20 | [Flaky]ラベルでフレーキーテストを管理 | E-02, E-05 | ○ |
| C-21 | make test で単体テスト実行 | E-02, E-03 | ○ |
| C-22 | make test-integration で結合テスト実行 | E-02, E-04 | ○ |
| C-23 | make verify で全presubmit検証を実行 | E-02 | ○ |
| C-24 | レースディテクターがデフォルトで有効（-race） | E-03 | ○ |
| C-25 | KUBE_CACHE_MUTATION_DETECTOR=true がデフォルト | E-03 | ○ |
| C-26 | 単体テストタイムアウト180秒、結合テスト600秒 | E-03, E-04 | ○ |
| C-27 | ProwによるCI/CD管理 | **根拠なし（リポジトリ外）** | △ |
| C-28 | Presubmitで単体・結合・静的解析が自動実行される | **根拠なし（Prow設定外部）** | △ |
| C-29 | E2Eテストフレームワークが test/e2e/framework/ に整備 | E-09 | ○ |
| C-30 | デバッグ実行にdelve/gdbをサポート | E-02, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Prowの設定ファイル**: Prowのジョブ定義は `k8s.io/test-infra` リポジトリで管理されており、本リポジトリ内には存在しない。そのためCI/CDの具体的なジョブ構成・トリガー条件は直接検証できない
  - 候補：`k8s.io/test-infra` リポジトリの `config/jobs/` / Prow公式ドキュメント / Kubernetes開発者ガイド
- **カバレッジ目標値の公式方針**: コード内にはカバレッジ収集の仕組みは確認できるが、プロジェクトとしての公式カバレッジ目標の有無を確定するにはコミュニティドキュメントの確認が必要
  - 候補：SIG-Testing のチャーター / Kubernetes開発者ガイド / コミュニティミーティング議事録
- **Postsubmitジョブの詳細**: presubmitとpostsubmitの区分はProwの設定に依存するため、本リポジトリだけでは詳細を確認できない
  - 候補：`k8s.io/test-infra` の `config/` ディレクトリ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - テストツール・フレームワークの記述（go.mod、Makefileから直接確認可能）
- **0: 低リスク** - テストディレクトリ構成の記述（ファイルシステムから直接確認可能）
- **1: 中リスク** - CI/CDパイプラインの記述（Prowの設定が外部リポジトリにあるため間接的な推測を含む）
- **0: 低リスク** - テスト実行コマンド・環境変数の記述（シェルスクリプトから直接確認可能）
- **1: 中リスク** - カバレッジ目標の不在という主張（明示的な目標文書が見つからないことの確認は「ないことの証明」であり完全性に限界がある）

## 6) レビュアーチェックリスト（最小）
- [ ] テストレベルの分類が実態と一致しているか（特にE2E系テストの区分）
- [ ] テストツールのバージョンが最新の `go.mod` と一致しているか
- [ ] CI/CDの記述がProwの実際のジョブ定義と整合しているか（`k8s.io/test-infra` を参照して確認）
- [ ] カバレッジに関する公式方針が別途存在しないか確認
- [ ] 静的解析スクリプトの種類数（49種類）が現在のリポジトリ状態と一致しているか
- [ ] 適合性テストのゴールデンリストが最新のAPI仕様を反映しているか
