# ER図

## 概要

Kubernetesのリソース間の関連性をER図で表現する。Kubernetesはetcd（KVS）を使用するため、リレーショナルDBのような外部キー制約は存在しないが、`ownerReferences`、`spec`内の参照フィールド、`LabelSelector`によるリソース間の論理的な関連が存在する。

## Core リソース関連図

```mermaid
erDiagram
    Namespace ||--o{ Pod : "contains"
    Namespace ||--o{ Service : "contains"
    Namespace ||--o{ ConfigMap : "contains"
    Namespace ||--o{ Secret : "contains"
    Namespace ||--o{ ServiceAccount : "contains"
    Namespace ||--o{ PersistentVolumeClaim : "contains"
    Namespace ||--o{ Endpoints : "contains"
    Namespace ||--o{ ResourceQuota : "contains"
    Namespace ||--o{ LimitRange : "contains"
    Namespace ||--o{ Event : "contains"

    Pod {
        string name
        string namespace
        string uid
        string resourceVersion
        string nodeName
        string serviceAccountName
        string phase
    }

    Node {
        string name
        string uid
        string podCIDR
        bool unschedulable
        string phase
    }

    Namespace {
        string name
        string uid
        string phase
    }

    Service {
        string name
        string namespace
        string type
        string clusterIP
        string sessionAffinity
    }

    Endpoints {
        string name
        string namespace
    }

    ConfigMap {
        string name
        string namespace
        bool immutable
    }

    Secret {
        string name
        string namespace
        string type
        bool immutable
    }

    ServiceAccount {
        string name
        string namespace
        bool automountServiceAccountToken
    }

    PersistentVolume {
        string name
        string uid
        string storageClassName
        string phase
        string reclaimPolicy
    }

    PersistentVolumeClaim {
        string name
        string namespace
        string storageClassName
        string volumeName
        string phase
    }

    ResourceQuota {
        string name
        string namespace
    }

    LimitRange {
        string name
        string namespace
    }

    Event {
        string name
        string namespace
        string type
        string reason
        int32 count
    }

    Node ||--o{ Pod : "schedules"
    Pod }o--|| ServiceAccount : "uses"
    Pod }o--o{ ConfigMap : "mounts/references"
    Pod }o--o{ Secret : "mounts/references"
    Pod }o--o{ PersistentVolumeClaim : "mounts"
    Service ||--o{ Endpoints : "selects"
    Service }o--o{ Pod : "routes-to (via selector)"
    PersistentVolumeClaim }o--|| PersistentVolume : "binds"
    PersistentVolume }o--o| StorageClass : "provisioned-by"
    PersistentVolumeClaim }o--o| StorageClass : "requests"
    Event }o--|| Pod : "references (involvedObject)"
```

## Workload リソース関連図

```mermaid
erDiagram
    Deployment ||--o{ ReplicaSet : "owns (ownerReferences)"
    ReplicaSet ||--o{ Pod : "owns (ownerReferences)"
    StatefulSet ||--o{ Pod : "owns (ownerReferences)"
    StatefulSet ||--o{ PersistentVolumeClaim : "creates (volumeClaimTemplates)"
    DaemonSet ||--o{ Pod : "owns (ownerReferences)"
    CronJob ||--o{ Job : "owns (ownerReferences)"
    Job ||--o{ Pod : "owns (ownerReferences)"
    Deployment ||--o{ ControllerRevision : "references"
    StatefulSet ||--o{ ControllerRevision : "owns (ownerReferences)"
    DaemonSet ||--o{ ControllerRevision : "owns (ownerReferences)"

    Deployment {
        string name
        string namespace
        int32 replicas
        string strategy
        int32 revisionHistoryLimit
    }

    ReplicaSet {
        string name
        string namespace
        int32 replicas
    }

    StatefulSet {
        string name
        string namespace
        int32 replicas
        string serviceName
        string updateStrategy
    }

    DaemonSet {
        string name
        string namespace
        string updateStrategy
    }

    Job {
        string name
        string namespace
        int32 parallelism
        int32 completions
        int32 backoffLimit
    }

    CronJob {
        string name
        string namespace
        string schedule
        string concurrencyPolicy
    }

    ControllerRevision {
        string name
        string namespace
        int64 revision
    }

    Pod {
        string name
        string namespace
        string phase
    }

    PersistentVolumeClaim {
        string name
        string namespace
        string phase
    }

    StatefulSet }o--|| Service : "headless-service (serviceName)"
    Service {
        string name
        string namespace
        string type
    }
```

## RBAC リソース関連図

```mermaid
erDiagram
    ClusterRole ||--o{ ClusterRoleBinding : "referenced-by (roleRef)"
    Role ||--o{ RoleBinding : "referenced-by (roleRef)"
    ClusterRole ||--o{ RoleBinding : "referenced-by (roleRef)"
    ClusterRoleBinding }o--o{ ServiceAccount : "grants (subjects)"
    RoleBinding }o--o{ ServiceAccount : "grants (subjects)"

    ClusterRole {
        string name
        string uid
    }

    ClusterRoleBinding {
        string name
        string uid
    }

    Role {
        string name
        string namespace
    }

    RoleBinding {
        string name
        string namespace
    }

    ServiceAccount {
        string name
        string namespace
    }
```

## Storage リソース関連図

```mermaid
erDiagram
    StorageClass ||--o{ PersistentVolume : "provisions"
    StorageClass ||--o{ PersistentVolumeClaim : "requested-by"
    PersistentVolume ||--o| PersistentVolumeClaim : "bound-to (claimRef)"
    CSIDriver ||--o{ CSINode : "registered-on"
    CSIDriver ||--o{ VolumeAttachment : "used-by"
    VolumeAttachment }o--|| Node : "attaches-to"
    VolumeAttachment }o--|| PersistentVolume : "attaches"

    StorageClass {
        string name
        string provisioner
        string reclaimPolicy
        string volumeBindingMode
    }

    PersistentVolume {
        string name
        string storageClassName
        string phase
    }

    PersistentVolumeClaim {
        string name
        string namespace
        string storageClassName
        string volumeName
        string phase
    }

    CSIDriver {
        string name
    }

    CSINode {
        string name
    }

    VolumeAttachment {
        string name
        string attacher
        string nodeName
    }

    Node {
        string name
    }
```

## Networking リソース関連図

```mermaid
erDiagram
    IngressClass ||--o{ Ingress : "classifies"
    Ingress }o--o{ Service : "routes-to (backend)"
    NetworkPolicy }o--o{ Pod : "applies-to (podSelector)"
    Service }o--o{ Pod : "selects (selector)"
    ServiceCIDR ||--o{ IPAddress : "allocates"

    Ingress {
        string name
        string namespace
        string ingressClassName
    }

    IngressClass {
        string name
        string controller
    }

    NetworkPolicy {
        string name
        string namespace
    }

    Service {
        string name
        string namespace
        string type
        string clusterIP
    }

    Pod {
        string name
        string namespace
    }

    IPAddress {
        string name
    }

    ServiceCIDR {
        string name
    }
```

## Scheduling / Autoscaling リソース関連図

```mermaid
erDiagram
    PriorityClass ||--o{ Pod : "assigned-to (priorityClassName)"
    HorizontalPodAutoscaler }o--|| Deployment : "scales (scaleTargetRef)"
    HorizontalPodAutoscaler }o--|| ReplicaSet : "scales (scaleTargetRef)"
    HorizontalPodAutoscaler }o--|| StatefulSet : "scales (scaleTargetRef)"
    Lease }o--o| Node : "heartbeat (holderIdentity)"

    PriorityClass {
        string name
        int32 value
        bool globalDefault
    }

    HorizontalPodAutoscaler {
        string name
        string namespace
        int32 minReplicas
        int32 maxReplicas
    }

    Lease {
        string name
        string namespace
        string holderIdentity
        int32 leaseDurationSeconds
    }

    Deployment {
        string name
        string namespace
    }

    ReplicaSet {
        string name
        string namespace
    }

    StatefulSet {
        string name
        string namespace
    }

    Node {
        string name
    }

    Pod {
        string name
        string namespace
        string priorityClassName
    }
```
