---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **Event WatchCache無効設定のデフォルト値**: WatchCacheSizeが0であることのコード外運用確認
  2. **一部リソースのetcdキープレフィックス完全性**: SpecialDefaultResourcePrefixes以外のデフォルトプレフィックスの網羅確認
  3. **全APIリソースの網羅性**: 本設計書に含まれていないマイナーリソース（Discovery, FlowControl等）の存在
  4. **ER図のリレーション完全性**: ownerReferences以外の暗黙的関連の網羅確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/apis/core/types.go` - Coreリソースの型定義
- E-02: `pkg/apis/apps/types.go` - Appsリソースの型定義
- E-03: `pkg/apis/batch/types.go` - Batchリソースの型定義
- E-04: `pkg/apis/networking/types.go` - Networkingリソースの型定義
- E-05: `pkg/apis/rbac/types.go` - RBACリソースの型定義
- E-06: `pkg/apis/coordination/types.go` - Coordinationリソースの型定義
- E-07: `pkg/apis/certificates/types.go` - Certificatesリソースの型定義
- E-08: `pkg/apis/storage/types.go` - Storageリソースの型定義
- E-09: `pkg/apis/scheduling/types.go` - Schedulingリソースの型定義
- E-10: `pkg/kubeapiserver/default_storage_factory_builder.go` - SpecialDefaultResourcePrefixesおよびStorageFactory設定
- E-11: `staging/src/k8s.io/apiserver/pkg/storage/etcd3/store.go` - etcd3ストア実装
- E-12: `staging/src/k8s.io/apiserver/pkg/storage/storagebackend/config.go` - ストレージバックエンド設定（StorageTypeETCD3等）
- E-13: `staging/src/k8s.io/apiserver/pkg/server/options/etcd.go` - EtcdOptions定義
- E-14: `staging/src/k8s.io/apiserver/pkg/storage/interfaces.go` - Storage Interface定義
- E-15: `staging/src/k8s.io/apiserver/pkg/server/storage/storage_factory.go` - StorageFactory Interface
- E-16: `pkg/registry/` ディレクトリ - 各リソースのregistry実装（storage/strategy）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Kubernetesはetcd v3をバックエンドストレージとして使用 | E-11, E-12 | ○ |
| C-02 | デフォルトシリアライゼーション形式はProtocol Buffers | E-13 (DefaultStorageMediaType) | ○ |
| C-03 | etcdキー構造は /{prefix}/{resource}/{namespace}/{name} | E-11 (pathPrefix, resourcePrefix), E-14 | ○ |
| C-04 | デフォルトプレフィックスは /registry | E-12, E-13 | ○ |
| C-05 | ResourceVersionはetcdのModRevisionに基づく | E-14 (Versioner interface), E-11 | ○ |
| C-06 | Encryption at Restをサポート | E-13 (EncryptionProviderConfigFilepath) | ○ |
| C-07 | Watch Cache機構を持つ | E-13 (EnableWatchCache) | ○ |
| C-08 | コンパクション間隔はデフォルト5分 | E-12 (DefaultCompactInterval = 5 * time.Minute) | ○ |
| C-09 | replicationcontrollersのプレフィックスはcontrollers | E-10 | ○ |
| C-10 | endpointsのプレフィックスはservices/endpoints | E-10 | ○ |
| C-11 | nodesのプレフィックスはminions | E-10 | ○ |
| C-12 | servicesのプレフィックスはservices/specs | E-10 | ○ |
| C-13 | ingressesのプレフィックスはingress | E-10 | ○ |
| C-14 | Pod型定義（spec.containers, status.phase等のフィールド） | E-01 | ○ |
| C-15 | Node型定義（spec.podCIDR, status.conditions等のフィールド） | E-01 | ○ |
| C-16 | Service型定義（spec.type, spec.clusterIP等のフィールド） | E-01 | ○ |
| C-17 | ConfigMap型定義（data, binaryData, immutableフィールド） | E-01 | ○ |
| C-18 | Secret型定義（type, data, immutableフィールド） | E-01 | ○ |
| C-19 | Deployment型定義（spec.replicas, spec.strategy等のフィールド） | E-02 | ○ |
| C-20 | StatefulSet型定義（spec.serviceName, spec.volumeClaimTemplates等） | E-02 | ○ |
| C-21 | Job/CronJob型定義 | E-03 | ○ |
| C-22 | RBAC型定義（Role, RoleBinding, ClusterRole, ClusterRoleBinding） | E-05 | ○ |
| C-23 | Lease型定義 | E-06 | ○ |
| C-24 | StorageClass型定義 | E-08 | ○ |
| C-25 | apps/deploymentsとextensions/deploymentsは同一etcdキー空間を共有 | E-10 (AddCohabitatingResources) | ○ |
| C-26 | EventリソースのWatchCacheはデフォルトで無効 | E-10 (DefaultWatchCacheSizes: events -> 0) | ○ |
| C-27 | 全リソースのetcdキープレフィックスの完全な一覧 | **根拠なし** | △ |
| C-28 | 全APIリソースの網羅性（FlowControl, Discovery, Node等の一部リソースが未記載の可能性） | **根拠なし** | △ |
| C-29 | ER図のownerReferences関連の完全性 | **根拠なし** | △ |
| C-30 | 各フィールドのNULL許容性の正確さ（optional/requiredタグの完全確認） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-27: SpecialDefaultResourcePrefixes以外のリソースは、リソース名がそのままプレフィックスとなる仕様であるが、全リソースについて個別に検証していない
  - 候補：各registry packageのNewStorage実装 / apiserver integration test
- C-28: pkg/registry以下にはFlowControl, Discovery, Node, Events（events.k8s.io）等のサブディレクトリが存在し、それらのリソースは設計書に一部含まれていない
  - 候補：`pkg/registry/flowcontrol/` / `pkg/registry/discovery/` / `pkg/registry/node/`
- C-29: ownerReferencesの実際の設定はコントローラー実装側にあり、types.go定義からは直接読み取れない
  - 候補：各コントローラーの実装コード（`pkg/controller/`）
- C-30: Goの構造体定義ではoptionalタグとポインタ型の有無で判断しているが、全フィールドの完全なチェックは実施していない
  - 候補：OpenAPI Spec生成コード / CRD定義 / API validation実装

## 5) リスクフラグ（レビュー観点）
- リスク1（中）: APIリソースの網羅性 - FlowControl（FlowSchema, PriorityLevelConfiguration）、Discovery（EndpointSlice）、Resource（ResourceClaim等）など一部のAPIグループリソースが設計書に含まれていない可能性がある
- リスク1（低）: NULL許容性の正確さ - Go言語のポインタ型（*string等）をNULL許容と解釈しているが、APIサーバーのvalidation実装で必須扱いとなるケースがある
- リスク0（低）: etcdキープレフィックスの正確さ - SpecialDefaultResourcePrefixesで明示されたものは正確、その他はリソース名がデフォルトプレフィックスとなるルールに基づく推定

## 6) レビュアーチェックリスト（最小）
- [ ] 主要リソース（Pod, Node, Service, Deployment等）のフィールド定義が最新のソースコードと一致するか
- [ ] SpecialDefaultResourcePrefixesの記載がコード（`pkg/kubeapiserver/default_storage_factory_builder.go`）と一致するか
- [ ] 設計書に含まれていないAPIグループ（FlowControl, Discovery, Resource, Node等）が業務上必要か確認
- [ ] ER図のリレーションが実際のownerReferences設定と整合するか（特にWorkloadリソース間）
- [ ] 各フィールドのNULL許容性がAPI仕様（OpenAPI Spec）と一致するか
- [ ] 暗号化設定に関する記述がプロジェクトの運用要件と合致するか
