# データベース設計書

## 概要

本ドキュメントは、Kubernetesプロジェクトにおけるデータストレージ設計を記述する。Kubernetesはリレーショナルデータベースを使用せず、分散KVS（Key-Value Store）である **etcd v3** をバックエンドストレージとして採用している。すべてのクラスター状態（APIリソース）はetcdに永続化され、kube-apiserverを通じてCRUD操作が行われる。

本設計書では、etcdに格納される主要なAPIリソースを「テーブル」に見立て、そのキー構造、フィールド（Spec/Status）、および関連性を整理する。

### ストレージアーキテクチャ

- **ストレージバックエンド**: etcd v3（`storagebackend.StorageTypeETCD3`）
- **シリアライゼーション形式**: Protocol Buffers（デフォルト: `application/vnd.kubernetes.protobuf`）またはJSON
- **キー構造**: `/{prefix}/{resource}/{namespace}/{name}` または `/{prefix}/{resource}/{name}`（クラスタースコープ）
- **デフォルトプレフィックス**: `/registry`
- **バージョニング**: etcdのModRevisionを利用したOptimistic Concurrency Control（ResourceVersion）
- **暗号化**: オプションでEncryption at Rest（AES-CBC、AES-GCM、KMS v2等）
- **キャッシュ**: Watch Cache機構による読み取り性能最適化
- **コンパクション**: 定期的なetcdコンパクション（デフォルト5分間隔）

### 特殊なリソースプレフィックス

以下のリソースは歴史的経緯から、リソース名と異なるetcdキープレフィックスを持つ（`SpecialDefaultResourcePrefixes`として定義）。

| リソース | グループ | etcdプレフィックス |
| --- | --- | --- |
| replicationcontrollers | (core) | `controllers` |
| endpoints | (core) | `services/endpoints` |
| nodes | (core) | `minions` |
| services | (core) | `services/specs` |
| ingresses | extensions | `ingress` |
| ingresses | networking.k8s.io | `ingress` |

## テーブル一覧

### Core APIグループ（v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| pods | Pod | コンテナの実行単位 |
| nodes | Node | クラスター内のワーカーマシン |
| namespaces | Namespace | リソースの論理的な分離単位 |
| services | Service | Podへのネットワークアクセスを抽象化 |
| endpoints | Endpoints | Serviceに関連付けられたネットワークエンドポイント |
| configmaps | ConfigMap | 設定データのKey-Valueストア |
| secrets | Secret | 機密データの格納 |
| serviceaccounts | ServiceAccount | Pod内プロセスのアイデンティティ |
| persistentvolumes | PersistentVolume | クラスターレベルのストレージリソース |
| persistentvolumeclaims | PersistentVolumeClaim | ストレージの要求 |
| replicationcontrollers | ReplicationController | Podレプリカの管理（レガシー） |
| resourcequotas | ResourceQuota | Namespace内のリソース使用制限 |
| limitranges | LimitRange | Namespace内のリソースデフォルト制限 |
| events | Event | クラスター内イベントの記録 |
| podtemplates | PodTemplate | Podのテンプレート定義 |

### Apps APIグループ（apps/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| deployments | Deployment | 宣言的なPodデプロイ管理 |
| replicasets | ReplicaSet | Podレプリカの維持 |
| statefulsets | StatefulSet | ステートフルアプリケーションの管理 |
| daemonsets | DaemonSet | 全/選択ノードでのPod実行保証 |
| controllerrevisions | ControllerRevision | コントローラーのリビジョン履歴 |

### Batch APIグループ（batch/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| jobs | Job | 一度限りのタスク実行 |
| cronjobs | CronJob | スケジュールベースのJob実行 |

### Networking APIグループ（networking.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| networkpolicies | NetworkPolicy | Pod間のネットワークアクセス制御 |
| ingresses | Ingress | 外部からのHTTP(S)ルーティング |
| ingressclasses | IngressClass | Ingressコントローラーの分類 |
| ipaddresses | IPAddress | IPアドレスの割り当て管理 |
| servicecidrs | ServiceCIDR | Service用CIDRの管理 |

### RBAC APIグループ（rbac.authorization.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| roles | Role | Namespace内の権限定義 |
| rolebindings | RoleBinding | Roleとサブジェクトの紐付け |
| clusterroles | ClusterRole | クラスタースコープの権限定義 |
| clusterrolebindings | ClusterRoleBinding | ClusterRoleとサブジェクトの紐付け |

### Coordination APIグループ（coordination.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| leases | Lease | リーダー選出・ノードハートビートの管理 |
| leasecandidates | LeaseCandidate | リーダー選出候補の管理 |

### Certificates APIグループ（certificates.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| certificatesigningrequests | CertificateSigningRequest | 証明書署名要求 |
| clustertrustbundles | ClusterTrustBundle | クラスター信頼バンドル |

### Storage APIグループ（storage.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| storageclasses | StorageClass | ストレージプロビジョナーの分類 |
| volumeattachments | VolumeAttachment | ボリュームのノードアタッチ管理 |
| csidrivers | CSIDriver | CSIドライバーの登録情報 |
| csinodes | CSINode | CSIノード情報 |
| csistoragecapacities | CSIStorageCapacity | CSIストレージ容量情報 |
| volumeattributesclasses | VolumeAttributesClass | ボリューム属性クラスの定義 |

### Scheduling APIグループ（scheduling.k8s.io/v1）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| priorityclasses | PriorityClass | Podスケジューリング優先度の定義 |

### Autoscaling APIグループ（autoscaling/v2）

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| horizontalpodautoscalers | HorizontalPodAutoscaler | 水平Pod自動スケーリング |

### Policy APIグループ

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| poddisruptionbudgets | PodDisruptionBudget | Pod中断予算の管理 |

### AdmissionRegistration APIグループ

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| mutatingwebhookconfigurations | MutatingWebhookConfiguration | 変更Webhookの登録 |
| validatingwebhookconfigurations | ValidatingWebhookConfiguration | 検証Webhookの登録 |
| validatingadmissionpolicies | ValidatingAdmissionPolicy | CELベースの検証ポリシー |
| validatingadmissionpolicybindings | ValidatingAdmissionPolicyBinding | 検証ポリシーの適用先定義 |
| mutatingadmissionpolicies | MutatingAdmissionPolicy | CELベースの変更ポリシー |
| mutatingadmissionpolicybindings | MutatingAdmissionPolicyBinding | 変更ポリシーの適用先定義 |

## 各テーブル定義

### 共通メタデータ（全リソース共通）

すべてのKubernetesリソースは `metav1.ObjectMeta` を埋め込んでおり、以下の共通フィールドをetcd上に持つ。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | string | NO | リソース名（DNS-1123準拠） |
| namespace | string | YES | 所属Namespace（クラスタースコープリソースはなし） |
| uid | types.UID (string) | NO | グローバル一意識別子 |
| resourceVersion | string | NO | etcdのModRevision。楽観的排他制御に使用 |
| generation | int64 | YES | Specの世代番号 |
| creationTimestamp | metav1.Time | NO | 作成日時 |
| deletionTimestamp | metav1.Time | YES | 削除開始日時（Graceful Deletion） |
| deletionGracePeriodSeconds | int64 | YES | 削除猶予秒数 |
| labels | map[string]string | YES | ラベル（セレクタによる検索用） |
| annotations | map[string]string | YES | アノテーション（任意メタデータ） |
| ownerReferences | []OwnerReference | YES | 親リソースへの参照（GC用） |
| finalizers | []string | YES | 削除前フック |

### 1. Pod

Kubernetesにおけるコンテナの最小デプロイ単位。1つ以上のコンテナを内包する。

**etcdキー**: `/registry/pods/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.containers | []Container | NO | メインコンテナの定義リスト |
| spec.initContainers | []Container | YES | 初期化コンテナのリスト |
| spec.ephemeralContainers | []EphemeralContainer | YES | 一時デバッグコンテナ |
| spec.volumes | []Volume | YES | Pod内ボリューム定義 |
| spec.nodeName | string | YES | スケジュール先ノード名 |
| spec.nodeSelector | map[string]string | YES | ノード選択条件 |
| spec.serviceAccountName | string | YES | 使用するServiceAccount名 |
| spec.restartPolicy | RestartPolicy | NO | 再起動ポリシー（Always/OnFailure/Never） |
| spec.tolerations | []Toleration | YES | ノードTaintへの許容設定 |
| spec.affinity | Affinity | YES | スケジューリングアフィニティルール |
| spec.priorityClassName | string | YES | 優先度クラス名 |
| spec.schedulerName | string | YES | スケジューラー名 |
| status.phase | PodPhase | YES | Podフェーズ（Pending/Running/Succeeded/Failed/Unknown） |
| status.conditions | []PodCondition | YES | Pod状態条件リスト |
| status.hostIP | string | YES | 割り当てノードIP |
| status.podIP | string | YES | 割り当てPod IP |
| status.podIPs | []PodIP | YES | 割り当てPod IPリスト（dual-stack対応） |
| status.containerStatuses | []ContainerStatus | YES | 各コンテナの実行状態 |
| status.startTime | metav1.Time | YES | Pod開始時刻 |

### 2. Node

クラスター内のワーカーマシンを表すリソース。

**etcdキー**: `/registry/minions/{name}`（特殊プレフィックス）

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.podCIDR | string | YES | 割り当てPod CIDR |
| spec.podCIDRs | []string | YES | 割り当てPod CIDRリスト |
| spec.providerID | string | YES | クラウドプロバイダー識別子 |
| spec.unschedulable | bool | NO | スケジュール不可フラグ |
| spec.taints | []Taint | YES | ノードTaint定義 |
| status.capacity | ResourceList | YES | ノードの総リソース容量 |
| status.allocatable | ResourceList | YES | スケジュール可能リソース容量 |
| status.conditions | []NodeCondition | YES | ノード状態条件（Ready/MemoryPressure等） |
| status.addresses | []NodeAddress | YES | ノードアドレス（InternalIP/ExternalIP/Hostname） |
| status.nodeInfo | NodeSystemInfo | YES | ノードシステム情報（OS/カーネル/kubeletバージョン等） |
| status.images | []ContainerImage | YES | ノード上のコンテナイメージ一覧 |
| status.daemonEndpoints | NodeDaemonEndpoints | YES | kubelet等デーモンのエンドポイント |

### 3. Namespace

リソースの論理的な分離単位。

**etcdキー**: `/registry/namespaces/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.finalizers | []FinalizerName | YES | Namespace削除時のファイナライザー |
| status.phase | NamespacePhase | YES | Active/Terminating |
| status.conditions | []NamespaceCondition | YES | Namespace状態条件 |

### 4. Service

Pod群へのネットワークアクセスを抽象化するリソース。

**etcdキー**: `/registry/services/specs/{namespace}/{name}`（特殊プレフィックス）

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.type | ServiceType | NO | ClusterIP/NodePort/LoadBalancer/ExternalName |
| spec.clusterIP | string | YES | 割り当てクラスターIP |
| spec.clusterIPs | []string | YES | 割り当てクラスターIPリスト（dual-stack） |
| spec.ports | []ServicePort | YES | ポート定義リスト |
| spec.selector | map[string]string | YES | ターゲットPodのラベルセレクタ |
| spec.externalIPs | []string | YES | 外部IPリスト |
| spec.sessionAffinity | ServiceAffinity | YES | セッションアフィニティ設定 |
| spec.loadBalancerIP | string | YES | ロードバランサーIP（非推奨） |
| spec.externalTrafficPolicy | ServiceExternalTrafficPolicy | YES | 外部トラフィックポリシー |
| spec.internalTrafficPolicy | ServiceInternalTrafficPolicy | YES | 内部トラフィックポリシー |
| spec.ipFamilies | []IPFamily | YES | IPファミリー（IPv4/IPv6） |
| spec.ipFamilyPolicy | IPFamilyPolicy | YES | IPファミリーポリシー |
| status.loadBalancer | LoadBalancerStatus | YES | LBの状態情報 |

### 5. Endpoints

Serviceに関連付けられたネットワークエンドポイント。

**etcdキー**: `/registry/services/endpoints/{namespace}/{name}`（特殊プレフィックス）

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| subsets | []EndpointSubset | YES | エンドポイントサブセットのリスト |
| subsets[].addresses | []EndpointAddress | YES | 利用可能なエンドポイントアドレス |
| subsets[].notReadyAddresses | []EndpointAddress | YES | 未準備のエンドポイントアドレス |
| subsets[].ports | []EndpointPort | YES | ポート定義 |

### 6. ConfigMap

設定データをKey-Valueペアで格納するリソース。

**etcdキー**: `/registry/configmaps/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| data | map[string]string | YES | UTF-8テキストデータ |
| binaryData | map[string][]byte | YES | バイナリデータ |
| immutable | bool | YES | 不変フラグ（trueの場合変更不可） |

### 7. Secret

機密情報を格納するリソース。etcd上では暗号化オプションにより保護可能。

**etcdキー**: `/registry/secrets/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| type | SecretType | NO | シークレット種別（Opaque/kubernetes.io/tls等） |
| data | map[string][]byte | YES | Base64エンコードされた機密データ |
| stringData | map[string]string | YES | 平文機密データ（書き込み専用） |
| immutable | bool | YES | 不変フラグ |

### 8. ServiceAccount

Pod内プロセスのアイデンティティを定義するリソース。

**etcdキー**: `/registry/serviceaccounts/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| secrets | []ObjectReference | YES | 関連Secretへの参照（非推奨） |
| imagePullSecrets | []LocalObjectReference | YES | イメージPull用Secret |
| automountServiceAccountToken | bool | YES | トークン自動マウントフラグ |

### 9. PersistentVolume

クラスタースコープのストレージリソース。

**etcdキー**: `/registry/persistentvolumes/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.capacity | ResourceList | YES | ストレージ容量 |
| spec.accessModes | []PersistentVolumeAccessMode | YES | アクセスモード（RWO/ROX/RWX） |
| spec.persistentVolumeReclaimPolicy | PersistentVolumeReclaimPolicy | YES | 回収ポリシー（Retain/Recycle/Delete） |
| spec.storageClassName | string | YES | StorageClass名 |
| spec.claimRef | ObjectReference | YES | バインドされたPVCへの参照 |
| spec.nodeAffinity | VolumeNodeAffinity | YES | ノードアフィニティ |
| spec.volumeMode | PersistentVolumeMode | YES | Filesystem/Block |
| status.phase | PersistentVolumePhase | YES | Available/Bound/Released/Failed |
| status.message | string | YES | 状態メッセージ |

### 10. PersistentVolumeClaim

ストレージの要求を定義するNamespacedリソース。

**etcdキー**: `/registry/persistentvolumeclaims/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.accessModes | []PersistentVolumeAccessMode | YES | 要求アクセスモード |
| spec.resources | VolumeResourceRequirements | YES | 要求リソース量 |
| spec.storageClassName | string | YES | StorageClass名 |
| spec.volumeName | string | YES | バインド先PV名 |
| spec.volumeMode | PersistentVolumeMode | YES | Filesystem/Block |
| spec.selector | LabelSelector | YES | PV選択用ラベルセレクタ |
| status.phase | PersistentVolumeClaimPhase | YES | Pending/Bound/Lost |
| status.accessModes | []PersistentVolumeAccessMode | YES | 実際のアクセスモード |
| status.capacity | ResourceList | YES | 実際の容量 |

### 11. ReplicationController

Podレプリカの管理を行うレガシーリソース。

**etcdキー**: `/registry/controllers/{namespace}/{name}`（特殊プレフィックス）

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.replicas | int32 | YES | 希望レプリカ数 |
| spec.selector | map[string]string | YES | Podセレクタ |
| spec.template | PodTemplateSpec | YES | Podテンプレート |
| status.replicas | int32 | NO | 現在のレプリカ数 |
| status.readyReplicas | int32 | YES | Ready状態のレプリカ数 |
| status.availableReplicas | int32 | YES | 利用可能レプリカ数 |
| status.conditions | []ReplicationControllerCondition | YES | 状態条件 |

### 12. ResourceQuota

Namespace内のリソース使用量に上限を設けるリソース。

**etcdキー**: `/registry/resourcequotas/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.hard | ResourceList | YES | リソース上限値 |
| spec.scopes | []ResourceQuotaScope | YES | 適用スコープ |
| spec.scopeSelector | ScopeSelector | YES | スコープセレクタ |
| status.hard | ResourceList | YES | 適用中の上限値 |
| status.used | ResourceList | YES | 現在の使用量 |

### 13. LimitRange

Namespace内のデフォルトリソース制限を定義するリソース。

**etcdキー**: `/registry/limitranges/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.limits | []LimitRangeItem | NO | 制限項目リスト |
| spec.limits[].type | LimitType | NO | 制限対象（Pod/Container/PersistentVolumeClaim） |
| spec.limits[].max | ResourceList | YES | 最大値 |
| spec.limits[].min | ResourceList | YES | 最小値 |
| spec.limits[].default | ResourceList | YES | デフォルト上限 |
| spec.limits[].defaultRequest | ResourceList | YES | デフォルト要求 |

### 14. Event

クラスター内のイベントを記録するリソース。WatchCacheがデフォルトで無効。

**etcdキー**: `/registry/events/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| involvedObject | ObjectReference | NO | 関連オブジェクトへの参照 |
| reason | string | YES | イベント理由 |
| message | string | YES | イベントメッセージ |
| source | EventSource | YES | イベント発生元 |
| firstTimestamp | metav1.Time | YES | 初回発生時刻 |
| lastTimestamp | metav1.Time | YES | 最終発生時刻 |
| count | int32 | YES | 発生回数 |
| type | string | YES | Normal/Warning |
| series | EventSeries | YES | イベントシリーズ情報 |

### 15. Deployment

宣言的なPodデプロイメントを管理するリソース。

**etcdキー**: `/registry/deployments/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.replicas | int32 | YES | 希望レプリカ数 |
| spec.selector | LabelSelector | NO | Podセレクタ |
| spec.template | PodTemplateSpec | NO | Podテンプレート |
| spec.strategy | DeploymentStrategy | YES | 更新戦略（RollingUpdate/Recreate） |
| spec.minReadySeconds | int32 | YES | Ready判定最小秒数 |
| spec.revisionHistoryLimit | int32 | YES | リビジョン履歴保持数 |
| spec.paused | bool | YES | 一時停止フラグ |
| spec.progressDeadlineSeconds | int32 | YES | 進行デッドライン秒数 |
| status.observedGeneration | int64 | YES | 監視済みGeneration |
| status.replicas | int32 | YES | 現在レプリカ数 |
| status.updatedReplicas | int32 | YES | 更新済みレプリカ数 |
| status.readyReplicas | int32 | YES | Ready状態レプリカ数 |
| status.availableReplicas | int32 | YES | 利用可能レプリカ数 |
| status.conditions | []DeploymentCondition | YES | 状態条件 |

### 16. ReplicaSet

Podレプリカの安定的な維持を担うリソース。

**etcdキー**: `/registry/replicasets/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.replicas | int32 | YES | 希望レプリカ数 |
| spec.selector | LabelSelector | NO | Podセレクタ |
| spec.template | PodTemplateSpec | YES | Podテンプレート |
| spec.minReadySeconds | int32 | YES | Ready判定最小秒数 |
| status.replicas | int32 | NO | 現在レプリカ数 |
| status.fullyLabeledReplicas | int32 | YES | 完全ラベル付きレプリカ数 |
| status.readyReplicas | int32 | YES | Ready状態レプリカ数 |
| status.availableReplicas | int32 | YES | 利用可能レプリカ数 |
| status.conditions | []ReplicaSetCondition | YES | 状態条件 |

### 17. StatefulSet

ステートフルアプリケーションの管理を行うリソース。

**etcdキー**: `/registry/statefulsets/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.replicas | int32 | YES | 希望レプリカ数 |
| spec.selector | LabelSelector | NO | Podセレクタ |
| spec.template | PodTemplateSpec | NO | Podテンプレート |
| spec.volumeClaimTemplates | []PersistentVolumeClaim | YES | PVCテンプレート |
| spec.serviceName | string | NO | ヘッドレスService名 |
| spec.updateStrategy | StatefulSetUpdateStrategy | YES | 更新戦略 |
| spec.podManagementPolicy | PodManagementPolicyType | YES | Pod管理ポリシー（OrderedReady/Parallel） |
| spec.revisionHistoryLimit | int32 | YES | リビジョン履歴保持数 |
| spec.ordinals | StatefulSetOrdinals | YES | 開始序数の設定 |
| status.observedGeneration | int64 | YES | 監視済みGeneration |
| status.replicas | int32 | NO | 現在レプリカ数 |
| status.readyReplicas | int32 | YES | Ready状態レプリカ数 |
| status.currentRevision | string | YES | 現在のリビジョン名 |
| status.updateRevision | string | YES | 更新先リビジョン名 |
| status.conditions | []StatefulSetCondition | YES | 状態条件 |

### 18. DaemonSet

全ノード（または選択ノード）でPodの実行を保証するリソース。

**etcdキー**: `/registry/daemonsets/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.selector | LabelSelector | NO | Podセレクタ |
| spec.template | PodTemplateSpec | NO | Podテンプレート |
| spec.updateStrategy | DaemonSetUpdateStrategy | YES | 更新戦略 |
| spec.minReadySeconds | int32 | YES | Ready判定最小秒数 |
| spec.revisionHistoryLimit | int32 | YES | リビジョン履歴保持数 |
| status.currentNumberScheduled | int32 | NO | スケジュール済みノード数 |
| status.numberMisscheduled | int32 | NO | 誤スケジュールノード数 |
| status.desiredNumberScheduled | int32 | NO | 目標ノード数 |
| status.numberReady | int32 | NO | Ready Pod数 |
| status.numberAvailable | int32 | YES | 利用可能Pod数 |
| status.conditions | []DaemonSetCondition | YES | 状態条件 |

### 19. Job

一度限りのタスク実行を管理するリソース。

**etcdキー**: `/registry/jobs/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.parallelism | int32 | YES | 並列度 |
| spec.completions | int32 | YES | 完了数 |
| spec.backoffLimit | int32 | YES | リトライ上限 |
| spec.activeDeadlineSeconds | int64 | YES | アクティブデッドライン秒数 |
| spec.selector | LabelSelector | YES | Podセレクタ |
| spec.template | PodTemplateSpec | NO | Podテンプレート |
| spec.ttlSecondsAfterFinished | int32 | YES | 完了後TTL秒数 |
| spec.completionMode | CompletionMode | YES | Indexed/NonIndexed |
| spec.suspend | bool | YES | 一時停止フラグ |
| spec.podFailurePolicy | PodFailurePolicy | YES | Pod失敗ポリシー |
| spec.successPolicy | SuccessPolicy | YES | 成功判定ポリシー |
| status.conditions | []JobCondition | YES | 状態条件 |
| status.active | int32 | YES | アクティブPod数 |
| status.succeeded | int32 | YES | 成功Pod数 |
| status.failed | int32 | YES | 失敗Pod数 |
| status.startTime | metav1.Time | YES | 開始時刻 |
| status.completionTime | metav1.Time | YES | 完了時刻 |

### 20. CronJob

スケジュールベースでJobを生成するリソース。

**etcdキー**: `/registry/cronjobs/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.schedule | string | NO | cron式スケジュール |
| spec.timeZone | string | YES | タイムゾーン |
| spec.jobTemplate | JobTemplateSpec | NO | Jobテンプレート |
| spec.concurrencyPolicy | ConcurrencyPolicy | YES | Allow/Forbid/Replace |
| spec.suspend | bool | YES | 一時停止フラグ |
| spec.successfulJobsHistoryLimit | int32 | YES | 成功Job履歴保持数 |
| spec.failedJobsHistoryLimit | int32 | YES | 失敗Job履歴保持数 |
| spec.startingDeadlineSeconds | int64 | YES | 開始デッドライン秒数 |
| status.active | []ObjectReference | YES | アクティブJobリスト |
| status.lastScheduleTime | metav1.Time | YES | 最終スケジュール時刻 |
| status.lastSuccessfulTime | metav1.Time | YES | 最終成功時刻 |

### 21. NetworkPolicy

Pod間のネットワークアクセスを制御するリソース。

**etcdキー**: `/registry/networkpolicies/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.podSelector | LabelSelector | NO | 対象Podセレクタ |
| spec.ingress | []NetworkPolicyIngressRule | YES | Ingressルール |
| spec.egress | []NetworkPolicyEgressRule | YES | Egressルール |
| spec.policyTypes | []PolicyType | YES | ポリシー種別（Ingress/Egress） |

### 22. Ingress

外部からクラスター内Serviceへのルーティングを定義するリソース。

**etcdキー**: `/registry/ingress/{namespace}/{name}`（特殊プレフィックス）

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.ingressClassName | string | YES | IngressClass名 |
| spec.defaultBackend | IngressBackend | YES | デフォルトバックエンド |
| spec.tls | []IngressTLS | YES | TLS設定 |
| spec.rules | []IngressRule | YES | ルーティングルール |
| status.loadBalancer | IngressLoadBalancerStatus | YES | LBの状態情報 |

### 23. Role / ClusterRole

RBAC権限の定義リソース。

**etcdキー（Role）**: `/registry/roles/{namespace}/{name}`
**etcdキー（ClusterRole）**: `/registry/clusterroles/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| rules | []PolicyRule | YES | 権限ルールリスト |
| rules[].verbs | []string | NO | 許可操作（get/list/watch/create/update/delete等） |
| rules[].apiGroups | []string | YES | 対象APIグループ |
| rules[].resources | []string | YES | 対象リソース |
| rules[].resourceNames | []string | YES | 対象リソース名（特定名指定） |
| aggregationRule | AggregationRule | YES | ClusterRoleのみ。ルール集約設定 |

### 24. RoleBinding / ClusterRoleBinding

RoleまたはClusterRoleとサブジェクト（User/Group/ServiceAccount）を紐付けるリソース。

**etcdキー（RoleBinding）**: `/registry/rolebindings/{namespace}/{name}`
**etcdキー（ClusterRoleBinding）**: `/registry/clusterrolebindings/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| roleRef | RoleRef | NO | 参照先Role/ClusterRole |
| roleRef.apiGroup | string | NO | APIグループ（rbac.authorization.k8s.io） |
| roleRef.kind | string | NO | Role/ClusterRole |
| roleRef.name | string | NO | Role/ClusterRole名 |
| subjects | []Subject | YES | 権限付与対象リスト |
| subjects[].kind | string | NO | User/Group/ServiceAccount |
| subjects[].name | string | NO | サブジェクト名 |
| subjects[].namespace | string | YES | サブジェクトNamespace |

### 25. Lease

リーダー選出およびノードハートビートに使用されるリソース。

**etcdキー**: `/registry/leases/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.holderIdentity | string | YES | リース保持者の識別子 |
| spec.leaseDurationSeconds | int32 | YES | リース期間（秒） |
| spec.acquireTime | metav1.MicroTime | YES | 取得時刻 |
| spec.renewTime | metav1.MicroTime | YES | 更新時刻 |
| spec.leaseTransitions | int32 | YES | リーダー遷移回数 |

### 26. StorageClass

ストレージプロビジョナーの分類を定義するクラスタースコープリソース。

**etcdキー**: `/registry/storageclasses/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| provisioner | string | NO | プロビジョナー名 |
| parameters | map[string]string | YES | プロビジョナーパラメータ |
| reclaimPolicy | PersistentVolumeReclaimPolicy | YES | 回収ポリシー |
| mountOptions | []string | YES | マウントオプション |
| allowVolumeExpansion | bool | YES | ボリューム拡張許可フラグ |
| volumeBindingMode | VolumeBindingMode | YES | バインディングモード（Immediate/WaitForFirstConsumer） |

### 27. HorizontalPodAutoscaler

Pod数の水平自動スケーリングを定義するリソース。

**etcdキー**: `/registry/horizontalpodautoscalers/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.scaleTargetRef | CrossVersionObjectReference | NO | スケール対象リソース |
| spec.minReplicas | int32 | YES | 最小レプリカ数 |
| spec.maxReplicas | int32 | NO | 最大レプリカ数 |
| spec.metrics | []MetricSpec | YES | メトリクス定義 |
| spec.behavior | HorizontalPodAutoscalerBehavior | YES | スケーリング動作設定 |
| status.currentReplicas | int32 | YES | 現在レプリカ数 |
| status.desiredReplicas | int32 | NO | 目標レプリカ数 |
| status.currentMetrics | []MetricStatus | YES | 現在メトリクス値 |
| status.conditions | []HorizontalPodAutoscalerCondition | YES | 状態条件 |

### 28. CertificateSigningRequest

証明書署名要求を管理するクラスタースコープリソース。

**etcdキー**: `/registry/certificatesigningrequests/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| spec.request | []byte | NO | PEMエンコードされたCSR |
| spec.signerName | string | NO | 署名者名 |
| spec.usages | []KeyUsage | YES | 鍵用途 |
| spec.expirationSeconds | int32 | YES | 有効期限秒数 |
| spec.username | string | YES | 要求者ユーザー名 |
| spec.groups | []string | YES | 要求者グループ |
| status.certificate | []byte | YES | 署名済み証明書 |
| status.conditions | []CertificateSigningRequestCondition | YES | 承認/拒否条件 |

### 29. PriorityClass

Podスケジューリング優先度を定義するクラスタースコープリソース。

**etcdキー**: `/registry/priorityclasses/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| value | int32 | NO | 優先度値 |
| globalDefault | bool | YES | グローバルデフォルトフラグ |
| description | string | YES | 説明文 |
| preemptionPolicy | PreemptionPolicy | YES | プリエンプションポリシー（PreemptLowerPriority/Never） |

### 30. ControllerRevision

StatefulSetやDaemonSetのリビジョン履歴を格納するリソース。

**etcdキー**: `/registry/controllerrevisions/{namespace}/{name}`

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| data | runtime.RawExtension | YES | リビジョンデータ |
| revision | int64 | NO | リビジョン番号 |

## 備考

### etcdにおけるデータモデルの特性

1. **スキーマレスKVS**: etcdはKey-Value Storeであり、テーブルスキーマの概念はない。上記の「テーブル定義」は、Kubernetes APIリソースの構造体定義を便宜上テーブル形式で表現したものである。

2. **リソースバージョニング**: 各リソースの `resourceVersion` はetcdの `ModRevision`（グローバルに単調増加する整数）に基づく。これにより楽観的排他制御（Optimistic Concurrency Control）が実現される。

3. **Protobufシリアライゼーション**: デフォルトではProtocol Buffersを用いてリソースをシリアライズしetcdに格納する。これによりJSONよりもストレージ効率と性能が向上する。

4. **Watch Cache**: kube-apiserverは頻繁に参照されるリソースに対してインメモリのWatch Cacheを保持する。EventリソースはデフォルトでWatch Cacheが無効（サイズ0）である。

5. **共存リソース（Cohabitating Resources）**: 一部のリソースは異なるAPIグループ間で同一のetcdストレージを共有する。例えば `apps/deployments` と `extensions/deployments` は同一のetcdキー空間を使用する。

6. **TTLとリース**: etcdのリース機構を利用して、一部のリソース（Event等）にTTLを設定可能。期限切れのデータは自動的に削除される。

7. **暗号化**: `EncryptionConfiguration` を使用して、etcd上の特定リソース（Secret等）を暗号化できる。KMS v2、AES-GCM、AES-CBC等のプロバイダーをサポートする。

8. **OwnerReferenceによるガベージコレクション**: `ownerReferences` フィールドにより親子関係を定義し、親リソース削除時に子リソースを自動的にカスケード削除できる。これはリレーショナルDBにおける外部キー制約+CASCADE DELETEに相当する。
