# バッチ設計書 11-Job Registry（Storage）

## 概要

本ドキュメントは、Kubernetes Batch APIにおけるJobリソースのRESTストレージ実装（Job Registry Storage）の設計について記述する。API ServerがJobリソースのCRUD操作を処理するためのストレージバックエンド層の仕様を定義する。

### 本バッチの処理概要

Job Registry（Storage）は、Kubernetes API ServerにおけるJobリソースのRESTful APIエンドポイントを実装するストレージ層であり、etcdを永続化バックエンドとしてJobリソースのライフサイクル管理を提供する。

**業務上の目的・背景**：Kubernetes API Serverは、クライアント（kubectl、コントローラー等）からのJobリソースに対するCRUD操作リクエストを処理する必要がある。Job Registry Storageは、APIリクエストをetcdストレージ操作に変換し、Jobリソースの永続化・取得・更新・削除を統一的に管理する。これにより、Batch APIの全てのJobリソース操作がAPI Serverを通じて一貫した方法で処理される。

**バッチの実行タイミング**：API Serverの起動時にストレージが初期化され、以降はAPIリクエスト駆動で処理が実行される。常時稼働のサーバーサイドコンポーネントとして動作する。

**主要な処理内容**：
1. JobリソースのRESTストレージ（REST構造体）の初期化とetcd接続設定
2. Job本体のCRUD操作（Create、Get、List、Update、Delete、DeleteCollection）の提供
3. Jobステータスサブリソース（StatusREST）のGet/Update操作の提供
4. 削除時のデフォルトガベージコレクションポリシー（OrphanDependents）に基づく警告メッセージ発行
5. カテゴリ情報（"all"）の提供によるkubectl get allでの表示対応

**前後の処理との関連**：API Server起動時にBatch APIグループの登録処理から呼び出される。Job Controllerおよびkubectl等のクライアントがこのストレージ層を通じてJobリソースを操作する。Batch API Types（No.8）で定義された型定義、Batch API Validation（No.9）で定義されたバリデーションロジック、Batch API Defaults（No.10）で定義されたデフォルト値設定がストラテジーを通じて適用される。

**影響範囲**：Kubernetes API Server全体、etcdストレージ、Job Controllerを含む全てのJobリソース操作クライアント。

## バッチ種別

APIリソースストレージ（RESTストレージ実装）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 常時（API Serverの起動中） |
| 実行時刻 | API Server起動時に初期化 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | APIリクエスト駆動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| API Server起動 | kube-apiserverプロセスが起動していること |
| etcd接続 | etcdクラスタに接続可能であること |
| Batch APIグループ登録 | Batch API v1がAPI Serverに登録されていること |

### 実行可否判定

API Serverの起動シーケンスの一部として自動的に初期化される。RESTOptionsGetterを通じてetcd接続オプションが正常に取得できない場合はエラーを返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| optsGetter | generic.RESTOptionsGetter | Yes | なし | etcdストレージオプションを取得するためのインターフェース |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| etcd | KV Store | Jobリソースの永続化データを格納するetcdクラスタ |
| APIリクエスト | HTTP/gRPC | クライアントからのJobリソース操作リクエスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| etcd | KV Store | Jobリソースの永続化データ |
| APIレスポンス | JSON/Protobuf | クライアントへのレスポンス |

### 出力ファイル仕様

ファイル出力なし（etcdへのKVストア書き込みのみ）。

## 処理フロー

### 処理シーケンス

```
1. NewStorage関数によるストレージ初期化
   └─ NewREST関数を呼び出してRESTストレージとStatusRESTストレージを生成
2. genericregistry.Storeの設定
   └─ NewFunc/NewListFunc/PredicateFunc/Strategy/TableConvertorを設定
3. StoreOptionsによるetcd接続完了
   └─ CompleteWithOptionsでetcdバックエンドとの接続を確立
4. StatusRESTストレージの構築
   └─ メインStoreをコピーしてStatusStrategyを適用
5. APIリクエスト処理（以降はリクエスト駆動）
   └─ Create/Get/List/Update/Delete/DeleteCollectionの各操作を処理
6. Delete時の警告処理
   └─ PropagationPolicy未指定時にOrphanDependentsポリシーの場合は警告を発行
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[NewStorage呼び出し]
    B --> C[genericregistry.Store設定]
    C --> D[CompleteWithOptions - etcd接続]
    D --> E{接続成功?}
    E -->|Yes| F[REST/StatusREST構造体生成]
    E -->|No| G[エラー返却]
    F --> H[APIリクエスト待機]
    H --> I{リクエスト種別}
    I -->|Create| J[job.Strategy.Create]
    I -->|Get/List| K[etcdからデータ取得]
    I -->|Update| L[job.Strategy.Update]
    I -->|Delete| M{PropagationPolicy設定?}
    M -->|未設定| N[警告メッセージ発行]
    M -->|設定済| O[Store.Delete実行]
    N --> O
    I -->|Status Update| P[StatusStrategy.Update]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Job作成 | /registry/jobs/{namespace}/{name} | INSERT | 新規Jobリソースをetcdに格納 |
| Job取得 | /registry/jobs/{namespace}/{name} | SELECT | 指定Jobリソースをetcdから取得 |
| Job一覧 | /registry/jobs/{namespace}/ | SELECT | 名前空間内のJob一覧をetcdから取得 |
| Job更新 | /registry/jobs/{namespace}/{name} | UPDATE | 既存Jobリソースをetcd上で更新 |
| Job削除 | /registry/jobs/{namespace}/{name} | DELETE | 指定Jobリソースをetcdから削除 |
| Jobステータス更新 | /registry/jobs/{namespace}/{name} | UPDATE | Jobのステータスサブリソースを更新 |

### テーブル別操作詳細

#### /registry/jobs/{namespace}/{name}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | Job全フィールド | job.Strategyによるバリデーション済みオブジェクト | CreateStrategy適用後に格納 |
| UPDATE | Job specフィールド | job.Strategyによるバリデーション済みオブジェクト | UpdateStrategy適用後に更新 |
| UPDATE（Status） | Job statusフィールド | StatusStrategyによるバリデーション済みオブジェクト | forceAllowCreate=false |
| DELETE | - | 名前指定、PropagationPolicyに基づく | v1ではデフォルトOrphanDependents |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | Internal Server Error | etcd接続失敗 | etcdクラスタの状態を確認 |
| 404 | Not Found | 指定Jobが存在しない | リソース名・名前空間を確認 |
| 409 | Conflict | 楽観的ロックの競合（ResourceVersion不一致） | リソースを再取得してリトライ |
| 422 | Unprocessable Entity | バリデーションエラー | リクエスト内容を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | クライアント側で制御（ストレージ層自体にはリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 409 Conflictエラー（楽観的ロック競合時） |

### 障害時対応

etcd障害時はAPI Serverが全てのリクエストに対してエラーを返す。etcdクラスタの復旧が必要。データの整合性はetcdのトランザクション機構により保証される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個々のリソース操作単位 |
| コミットタイミング | 各操作完了時（etcdのアトミック操作） |
| ロールバック条件 | etcdトランザクション失敗時（ResourceVersion不一致等） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | APIリクエストレートに依存（数千RPS） |
| 目標処理時間 | 単一操作：数ミリ秒〜数十ミリ秒 |
| メモリ使用量上限 | API Serverのメモリ制限に依存 |

## 排他制御

etcdの楽観的並行性制御（ResourceVersion）により排他を実現。同一リソースへの同時更新はResourceVersionの不一致により409 Conflictエラーとなる。Store.DeleteCollectionはリスト取得後に個別削除を行うため、処理中に新規作成されたリソースは対象外となる場合がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | Job削除時（PropagationPolicy未指定） | "child pods are preserved by default when jobs are deleted" メッセージ |
| エラーログ | ストレージ操作失敗時 | エラー詳細、対象リソース情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| APIレイテンシ | API ServerのSLO閾値 | クラスタ管理者 |
| etcd接続エラー率 | 0% 超過 | クラスタ管理者 |

## 備考

- REST構造体はgenericregistry.Storeを埋め込みで利用し、CRUD操作の大部分を汎用ストレージ実装に委譲している
- Delete/DeleteCollectionメソッドはオーバーライドされており、v1 APIでのデフォルトガベージコレクションポリシー（OrphanDependents）に対する警告メッセージを発行する
- StatusRESTはメインStoreとストレージインスタンスを共有し、Destroy時に明示的なクリーンアップを行わない
- CategoriesProvider("all")を実装しており、kubectl get allコマンドで表示される
- ソースコード: `pkg/registry/batch/job/storage/storage.go`
