# バッチ設計書 12-CronJob Registry（Storage）

## 概要

本ドキュメントは、Kubernetes Batch APIにおけるCronJobリソースのRESTストレージ実装（CronJob Registry Storage）の設計について記述する。API ServerがCronJobリソースのCRUD操作を処理するためのストレージバックエンド層の仕様を定義する。

### 本バッチの処理概要

CronJob Registry（Storage）は、Kubernetes API ServerにおけるCronJobリソースのRESTful APIエンドポイントを実装するストレージ層であり、etcdを永続化バックエンドとしてCronJobリソースのライフサイクル管理を提供する。

**業務上の目的・背景**：Kubernetes API Serverは、クライアント（kubectl、CronJob Controller等）からのCronJobリソースに対するCRUD操作リクエストを処理する必要がある。CronJob Registry Storageは、APIリクエストをetcdストレージ操作に変換し、CronJobリソースの永続化・取得・更新・削除を統一的に管理する。これにより、Cron形式のスケジュールに基づくJob定期実行の設定管理がAPI Serverを通じて行われる。

**バッチの実行タイミング**：API Serverの起動時にストレージが初期化され、以降はAPIリクエスト駆動で処理が実行される。常時稼働のサーバーサイドコンポーネントとして動作する。

**主要な処理内容**：
1. CronJobリソースのRESTストレージ（REST構造体）の初期化とetcd接続設定
2. CronJob本体のCRUD操作（Create、Get、List、Update、Delete）の提供
3. CronJobステータスサブリソース（StatusREST）のGet/Update操作の提供
4. カテゴリ情報（"all"）およびショートネーム（"cj"）の提供
5. cronjob.Strategyによるバリデーション・デフォルト値設定の適用

**前後の処理との関連**：API Server起動時にBatch APIグループの登録処理から呼び出される。CronJob Controllerがこのストレージ層を通じてCronJobリソースを監視・管理する。Batch API Types（No.8）で定義された型定義、Batch API Validation（No.9）で定義されたバリデーションロジックがストラテジーを通じて適用される。

**影響範囲**：Kubernetes API Server全体、etcdストレージ、CronJob Controllerを含む全てのCronJobリソース操作クライアント。

## バッチ種別

APIリソースストレージ（RESTストレージ実装）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 常時（API Serverの起動中） |
| 実行時刻 | API Server起動時に初期化 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | APIリクエスト駆動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| API Server起動 | kube-apiserverプロセスが起動していること |
| etcd接続 | etcdクラスタに接続可能であること |
| Batch APIグループ登録 | Batch API v1がAPI Serverに登録されていること |

### 実行可否判定

API Serverの起動シーケンスの一部として自動的に初期化される。RESTOptionsGetterを通じてetcd接続オプションが正常に取得できない場合はエラーを返す。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| optsGetter | generic.RESTOptionsGetter | Yes | なし | etcdストレージオプションを取得するためのインターフェース |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| etcd | KV Store | CronJobリソースの永続化データを格納するetcdクラスタ |
| APIリクエスト | HTTP/gRPC | クライアントからのCronJobリソース操作リクエスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| etcd | KV Store | CronJobリソースの永続化データ |
| APIレスポンス | JSON/Protobuf | クライアントへのレスポンス |

### 出力ファイル仕様

ファイル出力なし（etcdへのKVストア書き込みのみ）。

## 処理フロー

### 処理シーケンス

```
1. NewREST関数によるストレージ初期化
   └─ genericregistry.Storeを設定してRESTストレージとStatusRESTストレージを生成
2. genericregistry.Storeの設定
   └─ NewFunc/NewListFunc/Strategy/TableConvertorを設定
3. StoreOptionsによるetcd接続完了
   └─ CompleteWithOptionsでetcdバックエンドとの接続を確立
4. StatusRESTストレージの構築
   └─ メインStoreをコピーしてStatusStrategyを適用
5. APIリクエスト処理（以降はリクエスト駆動）
   └─ Create/Get/List/Update/Deleteの各操作を処理
```

### フローチャート

```mermaid
flowchart TD
    A[API Server起動] --> B[NewREST呼び出し]
    B --> C[genericregistry.Store設定]
    C --> D[CompleteWithOptions - etcd接続]
    D --> E{接続成功?}
    E -->|Yes| F[REST/StatusREST構造体生成]
    E -->|No| G[エラー返却]
    F --> H[APIリクエスト待機]
    H --> I{リクエスト種別}
    I -->|Create| J[cronjob.Strategy.Create]
    I -->|Get/List| K[etcdからデータ取得]
    I -->|Update| L[cronjob.Strategy.Update]
    I -->|Delete| M[cronjob.Strategy.Delete]
    I -->|Status Update| N[StatusStrategy.Update]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| CronJob作成 | /registry/cronjobs/{namespace}/{name} | INSERT | 新規CronJobリソースをetcdに格納 |
| CronJob取得 | /registry/cronjobs/{namespace}/{name} | SELECT | 指定CronJobリソースをetcdから取得 |
| CronJob一覧 | /registry/cronjobs/{namespace}/ | SELECT | 名前空間内のCronJob一覧をetcdから取得 |
| CronJob更新 | /registry/cronjobs/{namespace}/{name} | UPDATE | 既存CronJobリソースをetcd上で更新 |
| CronJob削除 | /registry/cronjobs/{namespace}/{name} | DELETE | 指定CronJobリソースをetcdから削除 |
| CronJobステータス更新 | /registry/cronjobs/{namespace}/{name} | UPDATE | CronJobのステータスサブリソースを更新 |

### テーブル別操作詳細

#### /registry/cronjobs/{namespace}/{name}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | CronJob全フィールド | cronjob.Strategyによるバリデーション済みオブジェクト | CreateStrategy適用後に格納 |
| UPDATE | CronJob specフィールド | cronjob.Strategyによるバリデーション済みオブジェクト | UpdateStrategy適用後に更新 |
| UPDATE（Status） | CronJob statusフィールド | StatusStrategyによるバリデーション済みオブジェクト | forceAllowCreate=false |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | Internal Server Error | etcd接続失敗 | etcdクラスタの状態を確認 |
| 404 | Not Found | 指定CronJobが存在しない | リソース名・名前空間を確認 |
| 409 | Conflict | 楽観的ロックの競合（ResourceVersion不一致） | リソースを再取得してリトライ |
| 422 | Unprocessable Entity | バリデーションエラー（Cronスケジュール形式不正等） | リクエスト内容を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | クライアント側で制御（ストレージ層自体にはリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 409 Conflictエラー（楽観的ロック競合時） |

### 障害時対応

etcd障害時はAPI Serverが全てのリクエストに対してエラーを返す。etcdクラスタの復旧が必要。データの整合性はetcdのトランザクション機構により保証される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 個々のリソース操作単位 |
| コミットタイミング | 各操作完了時（etcdのアトミック操作） |
| ロールバック条件 | etcdトランザクション失敗時（ResourceVersion不一致等） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | APIリクエストレートに依存 |
| 目標処理時間 | 単一操作：数ミリ秒〜数十ミリ秒 |
| メモリ使用量上限 | API Serverのメモリ制限に依存 |

## 排他制御

etcdの楽観的並行性制御（ResourceVersion）により排他を実現。同一リソースへの同時更新はResourceVersionの不一致により409 Conflictエラーとなる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | ストレージ操作失敗時 | エラー詳細、対象リソース情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| APIレイテンシ | API ServerのSLO閾値 | クラスタ管理者 |
| etcd接続エラー率 | 0% 超過 | クラスタ管理者 |

## 備考

- REST構造体はgenericregistry.Storeを埋め込みで利用し、CRUD操作の大部分を汎用ストレージ実装に委譲している
- Job Registry（No.11）と異なり、CronJob RegistryではDelete/DeleteCollectionのオーバーライドは行っていない（CronJobにはOrphanDependentsのデフォルトポリシーが不要）
- CategoriesProvider("all")とShortNamesProvider("cj")の両方を実装している
- StatusRESTはメインStoreとストレージインスタンスを共有し、Destroy時に明示的なクリーンアップを行わない
- StatusRESTのUpdateはforceAllowCreate=falseを強制し、サブリソース経由での新規作成を禁止する
- ソースコード: `pkg/registry/batch/cronjob/storage/storage.go`
